/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.exceptions.UnsupportedProtocolVersionException;
import com.datastax.driver.core.utils.DseVersion;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ProtocolVersionRenegotiationTest
extends CCMTestsSupport {
    private ProtocolVersion bestProtocolVersion;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.bestProtocolVersion = this.ccm().getProtocolVersion();
    }

    @Test(groups={"short"})
    public void should_negotiate_when_no_version_provided() throws Exception {
        Cluster cluster = this.connectWithoutVersion();
        Assertions.assertThat((Comparable)this.actualProtocolVersion(cluster)).isEqualTo((Object)this.bestProtocolVersion);
    }

    @Test(groups={"short"})
    public void should_succeed_when_version_provided_and_matches() throws Exception {
        Cluster cluster = this.connectWithVersion(this.bestProtocolVersion);
        Assertions.assertThat((Comparable)this.actualProtocolVersion(cluster)).isEqualTo((Object)this.bestProtocolVersion);
    }

    @Test(groups={"short"})
    @DseVersion(value="5.1.0")
    public void should_fail_when_version_provided_and_too_low() throws Exception {
        UnsupportedProtocolVersionException e = this.connectWithUnsupportedVersion(ProtocolVersion.V1);
        Assertions.assertThat((Comparable)e.getUnsupportedVersion()).isEqualTo((Object)ProtocolVersion.V1);
        Assertions.assertThat((Comparable)e.getServerVersion()).isEqualTo((Object)ProtocolVersion.V1);
    }

    private UnsupportedProtocolVersionException connectWithUnsupportedVersion(ProtocolVersion version) {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(version).build());
        return this.initWithUnsupportedVersion(cluster);
    }

    private UnsupportedProtocolVersionException connectWithUnsupportedBetaVersion() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).allowBetaProtocolVersion().build());
        return this.initWithUnsupportedVersion(cluster);
    }

    private UnsupportedProtocolVersionException initWithUnsupportedVersion(Cluster cluster) {
        Throwable t = null;
        try {
            cluster.init();
        }
        catch (Throwable t2) {
            t = t2;
        }
        if (t instanceof UnsupportedProtocolVersionException) {
            return (UnsupportedProtocolVersionException)t;
        }
        throw new AssertionError((Object)("Expected UnsupportedProtocolVersionException, got " + t));
    }

    private Cluster connectWithVersion(ProtocolVersion version) {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(version).build());
        cluster.init();
        return cluster;
    }

    private Cluster connectWithoutVersion() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).build());
        cluster.init();
        return cluster;
    }

    private ProtocolVersion actualProtocolVersion(Cluster cluster) {
        return cluster.getConfiguration().getProtocolOptions().getProtocolVersion();
    }
}

