/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.UnsupportedFeatureException;
import org.assertj.core.api.Assertions;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class ProtocolV1Test
extends CCMTestsSupport {
    @Override
    public Cluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withProtocolVersion(ProtocolVersion.V1);
    }

    @Override
    public void beforeTestClass(Object testInstance) throws Exception {
        if (CCMBridge.getGlobalCassandraVersion().compareTo(VersionNumber.parse((String)"3.0")) >= 0) {
            throw new SkipException("C* 3.0+ does not support Protocol V1");
        }
        super.beforeTestClass(testInstance);
    }

    @Test(groups={"short"})
    public void should_execute_query_with_no_variables() throws Exception {
        this.session().execute("select * from system.local");
    }

    @Test(groups={"short"})
    public void should_not_execute_query_with_variables() throws Exception {
        try {
            this.session().execute((Statement)new SimpleStatement("select * from system.local where key=?", new Object[]{"local"}));
        }
        catch (UnsupportedFeatureException e) {
            Assertions.assertThat((Throwable)e).hasMessageContaining("Unsupported feature with the native protocol V1 (which is currently in use): Binary values are not supported");
        }
    }

    @Test(groups={"short"})
    public void should_execute_prepared_statement_with_no_variables() throws Exception {
        PreparedStatement ps = this.session().prepare("select * from system.local");
        this.session().execute((Statement)ps.bind());
    }

    @Test(groups={"short"})
    public void should_execute_prepared_statement_with_variables() throws Exception {
        PreparedStatement ps = this.session().prepare("select * from system.local where key=?");
        this.session().execute((Statement)ps.bind(new Object[]{"local"}));
    }
}

