/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.utils.DseVersion;
import junit.framework.TestCase;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@DseVersion(value="6.0")
public class PreparedStatementInvalidationTest
extends CCMTestsSupport {
    @BeforeMethod(groups={"short"}, alwaysRun=true)
    public void setup() throws Exception {
        this.execute("CREATE TABLE prepared_statement_invalidation_test (a int PRIMARY KEY, b int, c int);");
        this.execute("INSERT INTO prepared_statement_invalidation_test (a, b, c) VALUES (1, 1, 1);");
        this.execute("INSERT INTO prepared_statement_invalidation_test (a, b, c) VALUES (2, 2, 2);");
        this.execute("INSERT INTO prepared_statement_invalidation_test (a, b, c) VALUES (3, 3, 3);");
        this.execute("INSERT INTO prepared_statement_invalidation_test (a, b, c) VALUES (4, 4, 4);");
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void teardown() throws Exception {
        this.execute("DROP TABLE prepared_statement_invalidation_test");
    }

    @Test(groups={"short"})
    public void should_update_statement_id_when_metadata_changed_across_executions() {
        PreparedStatement ps = this.session().prepare("SELECT * FROM prepared_statement_invalidation_test WHERE a = ?");
        MD5Digest idBefore = ps.getPreparedId().resultSetMetadata.id;
        this.session().execute("ALTER TABLE prepared_statement_invalidation_test ADD d int");
        BoundStatement bs = ps.bind(new Object[]{1});
        ResultSet rows = this.session().execute((Statement)bs);
        MD5Digest idAfter = ps.getPreparedId().resultSetMetadata.id;
        Assertions.assertThat((Object)idBefore).isNotEqualTo((Object)idAfter);
        Assertions.assertThat(ps.getPreparedId().resultSetMetadata.variables).hasSize(4).containsVariable("d", DataType.cint());
        Assertions.assertThat(bs.preparedStatement().getPreparedId().resultSetMetadata.variables).hasSize(4).containsVariable("d", DataType.cint());
        Assertions.assertThat(rows.getColumnDefinitions()).hasSize(4).containsVariable("d", DataType.cint());
    }

    @Test(groups={"short"})
    public void should_update_statement_id_when_metadata_changed_across_pages() throws Exception {
        PreparedStatement ps = this.session().prepare("SELECT * FROM prepared_statement_invalidation_test");
        ResultSet rows = this.session().execute(ps.bind().setFetchSize(2));
        Assertions.assertThat((boolean)rows.isFullyFetched()).isFalse();
        MD5Digest idBefore = ps.getPreparedId().resultSetMetadata.id;
        ColumnDefinitions definitionsBefore = rows.getColumnDefinitions();
        Assertions.assertThat(definitionsBefore).hasSize(3).doesNotContainVariable("d");
        int remaining = rows.getAvailableWithoutFetching();
        while (remaining-- > 0) {
            try {
                rows.one().getInt("d");
                TestCase.fail((String)"expected an error");
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        this.session().execute("ALTER TABLE prepared_statement_invalidation_test ADD d int");
        for (Row row : rows) {
            Assertions.assertThat((boolean)row.isNull("d")).isTrue();
        }
        MD5Digest idAfter = ps.getPreparedId().resultSetMetadata.id;
        ColumnDefinitions definitionsAfter = rows.getColumnDefinitions();
        Assertions.assertThat((Object)idBefore).isNotEqualTo((Object)idAfter);
        Assertions.assertThat(definitionsAfter).hasSize(4).containsVariable("d", DataType.cint());
    }

    @Test(groups={"short"})
    public void should_update_statement_id_when_metadata_changed_across_sessions() {
        Session session1 = this.cluster().connect();
        this.useKeyspace(session1, this.keyspace);
        Session session2 = this.cluster().connect();
        this.useKeyspace(session2, this.keyspace);
        PreparedStatement ps1 = session1.prepare("SELECT * FROM prepared_statement_invalidation_test WHERE a = ?");
        PreparedStatement ps2 = session2.prepare("SELECT * FROM prepared_statement_invalidation_test WHERE a = ?");
        MD5Digest id1a = ps1.getPreparedId().resultSetMetadata.id;
        MD5Digest id2a = ps2.getPreparedId().resultSetMetadata.id;
        ResultSet rows1 = session1.execute((Statement)ps1.bind(new Object[]{1}));
        ResultSet rows2 = session2.execute((Statement)ps2.bind(new Object[]{1}));
        Assertions.assertThat(rows1.getColumnDefinitions()).hasSize(3).containsVariable("a", DataType.cint()).containsVariable("b", DataType.cint()).containsVariable("c", DataType.cint());
        Assertions.assertThat(rows2.getColumnDefinitions()).hasSize(3).containsVariable("a", DataType.cint()).containsVariable("b", DataType.cint()).containsVariable("c", DataType.cint());
        session1.execute("ALTER TABLE prepared_statement_invalidation_test ADD d int");
        rows1 = session1.execute((Statement)ps1.bind(new Object[]{1}));
        rows2 = session2.execute((Statement)ps2.bind(new Object[]{1}));
        MD5Digest id1b = ps1.getPreparedId().resultSetMetadata.id;
        MD5Digest id2b = ps2.getPreparedId().resultSetMetadata.id;
        Assertions.assertThat((Object)id1a).isNotEqualTo((Object)id1b);
        Assertions.assertThat((Object)id2a).isNotEqualTo((Object)id2b);
        Assertions.assertThat(ps1.getPreparedId().resultSetMetadata.variables).hasSize(4).containsVariable("d", DataType.cint());
        Assertions.assertThat(ps2.getPreparedId().resultSetMetadata.variables).hasSize(4).containsVariable("d", DataType.cint());
        Assertions.assertThat(rows1.getColumnDefinitions()).hasSize(4).containsVariable("d", DataType.cint());
        Assertions.assertThat(rows2.getColumnDefinitions()).hasSize(4).containsVariable("d", DataType.cint());
    }

    @Test(groups={"short"}, expectedExceptions={NoHostAvailableException.class})
    public void should_not_reprepare_invalid_statements() {
        this.session().execute("ALTER TABLE prepared_statement_invalidation_test ADD d int");
        PreparedStatement ps = this.session().prepare("SELECT a, b, c, d FROM prepared_statement_invalidation_test WHERE a = ?");
        this.session().execute("ALTER TABLE prepared_statement_invalidation_test DROP d");
        this.session().execute((Statement)ps.bind());
    }

    @Test(groups={"short"})
    public void should_never_update_statement_id_for_conditional_updates_in_modern_protocol() {
        this.should_never_update_statement_id_for_conditional_updates(this.session());
    }

    private void should_never_update_statement_id_for_conditional_updates(Session session) {
        PreparedStatement ps = session.prepare("INSERT INTO prepared_statement_invalidation_test (a, b, c) VALUES (?, ?, ?) IF NOT EXISTS");
        Assertions.assertThat(ps.getPreparedId().resultSetMetadata.variables).isNull();
        MD5Digest idBefore = ps.getPreparedId().resultSetMetadata.id;
        ResultSet rs = session.execute((Statement)ps.bind(new Object[]{5, 5, 5}));
        Assertions.assertThat((boolean)rs.wasApplied()).isTrue();
        Assertions.assertThat(rs.getColumnDefinitions()).hasSize(1).containsVariable("[applied]", DataType.cboolean());
        Assertions.assertThat(ps.getPreparedId().resultSetMetadata.variables).isNull();
        Assertions.assertThat((Object)ps.getPreparedId().resultSetMetadata.id).isEqualTo((Object)idBefore);
        rs = session.execute((Statement)ps.bind(new Object[]{5, 5, 5}));
        Assertions.assertThat((boolean)rs.wasApplied()).isFalse();
        Assertions.assertThat(rs.getColumnDefinitions()).hasSize(4);
        Row row = rs.one();
        Assertions.assertThat((boolean)row.getBool("[applied]")).isFalse();
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(5);
        Assertions.assertThat((int)row.getInt("b")).isEqualTo(5);
        Assertions.assertThat((int)row.getInt("c")).isEqualTo(5);
        Assertions.assertThat(ps.getPreparedId().resultSetMetadata.variables).isNull();
        Assertions.assertThat((Object)ps.getPreparedId().resultSetMetadata.id).isEqualTo((Object)idBefore);
        session.execute("ALTER TABLE prepared_statement_invalidation_test ADD d int");
        rs = session.execute((Statement)ps.bind(new Object[]{5, 5, 5}));
        Assertions.assertThat((boolean)rs.wasApplied()).isFalse();
        Assertions.assertThat(rs.getColumnDefinitions()).hasSize(5);
        row = rs.one();
        Assertions.assertThat((boolean)row.getBool("[applied]")).isFalse();
        Assertions.assertThat((int)row.getInt("a")).isEqualTo(5);
        Assertions.assertThat((int)row.getInt("b")).isEqualTo(5);
        Assertions.assertThat((int)row.getInt("c")).isEqualTo(5);
        Assertions.assertThat((boolean)row.isNull("d")).isTrue();
        Assertions.assertThat(ps.getPreparedId().resultSetMetadata.variables).isNull();
        Assertions.assertThat((Object)ps.getPreparedId().resultSetMetadata.id).isEqualTo((Object)idBefore);
    }

    @Test(groups={"short"})
    public void should_never_update_statement_for_conditional_updates_in_legacy_protocols() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withProtocolVersion(this.ccm().getProtocolVersion(ProtocolVersion.DSE_V1)).build());
        Session session = cluster.connect(this.keyspace);
        this.should_never_update_statement_id_for_conditional_updates(session);
    }
}

