/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import org.testng.annotations.Test;

public class PreparedIdTest
extends CCMTestsSupport {
    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE foo(k1 int, k2 int, k3 int, v int, PRIMARY KEY ((k1, k2, k3)))");
    }

    @Test(groups={"short"})
    public void should_have_routing_key_indexes_when_all_bound() {
        PreparedStatement pst = this.session().prepare("INSERT INTO foo (k3, k1, k2, v) VALUES (?, ?, ?, ?)");
        Assertions.assertThat((int[])pst.getPreparedId().routingKeyIndexes).containsExactly(new int[]{1, 2, 0});
    }

    @Test(groups={"short"})
    public void should_not_have_routing_key_indexes_when_some_not_bound() {
        PreparedStatement pst = this.session().prepare("INSERT INTO foo (k3, k1, k2, v) VALUES (1, ?, ?, ?)");
        Assertions.assertThat((int[])pst.getPreparedId().routingKeyIndexes).isNull();
    }

    @Test(groups={"short"})
    public void should_not_have_routing_key_indexes_when_none_bound() {
        PreparedStatement pst = this.session().prepare("INSERT INTO foo (k3, k1, k2, v) VALUES (1, 1, 1, 1)");
        Assertions.assertThat((int[])pst.getPreparedId().routingKeyIndexes).isNull();
    }
}

