/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

@CCMConfig(createSession={false})
public class PoolingOptionsIntegrationTest
extends CCMTestsSupport {
    private ThreadPoolExecutor executor;

    @Override
    public Cluster.Builder createClusterBuilder() {
        this.executor = (ThreadPoolExecutor)Mockito.spy((Object)new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>()));
        PoolingOptions poolingOptions = new PoolingOptions();
        poolingOptions.setInitializationExecutor((Executor)this.executor);
        return Cluster.builder().withPoolingOptions(poolingOptions);
    }

    @AfterMethod(groups={"short"})
    public void shutdownExecutor() {
        if (this.executor != null) {
            this.executor.shutdown();
        }
    }

    @Test(groups={"short"})
    public void should_be_able_to_use_custom_initialization_executor() {
        this.cluster().init();
        ((ThreadPoolExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeastOnce())).execute((Runnable)Matchers.any(Runnable.class));
        Mockito.reset((Object[])new Object[0]);
        Session session = this.cluster().connect();
        ((ThreadPoolExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeastOnce())).execute((Runnable)Matchers.any(Runnable.class));
        Assertions.assertThat((Integer)((Integer)this.cluster().getMetrics().getOpenConnections().getValue())).isEqualTo(TestUtils.numberOfLocalCoreConnections(this.cluster()) + 1);
        Mockito.reset((Object[])new Object[0]);
        session.close();
        ((ThreadPoolExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeastOnce())).execute((Runnable)Matchers.any(Runnable.class));
        Assertions.assertThat((Integer)((Integer)this.cluster().getMetrics().getOpenConnections().getValue())).isEqualTo(1);
    }
}

