/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.PlatformInfoFinder;
import com.google.common.base.Function;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class PlatformInfoFinderTest {
    private static final Function<PlatformInfoFinder.DependencyInfo, URL> NULL_URL_PROVIDER = new Function<PlatformInfoFinder.DependencyInfo, URL>(){

        public URL apply(PlatformInfoFinder.DependencyInfo d) {
            return null;
        }
    };
    private static final Function<PlatformInfoFinder.DependencyInfo, URL> NETTY_URL_PROVIDER = new Function<PlatformInfoFinder.DependencyInfo, URL>(){

        public URL apply(PlatformInfoFinder.DependencyInfo d) {
            return this.getClass().getResource("/insights/pom.properties");
        }
    };
    private static final Function<PlatformInfoFinder.DependencyInfo, URL> MALFORMED_URL_PROVIDER = new Function<PlatformInfoFinder.DependencyInfo, URL>(){

        public URL apply(PlatformInfoFinder.DependencyInfo d) {
            return this.getClass().getResource("/insights/malformed-pom.properties");
        }
    };
    private static final Function<PlatformInfoFinder.DependencyInfo, URL> NON_EXISTING_URL_PROVIDER = new Function<PlatformInfoFinder.DependencyInfo, URL>(){

        public URL apply(PlatformInfoFinder.DependencyInfo d) {
            return this.getClass().getResource("/insights/non-existing.pom");
        }
    };

    @Test(groups={"unit"})
    public void should_find_dependencies_from_file() throws IOException {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/test-dependencies.txt");
        HashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> expected = new HashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        expected.put("io.netty:netty-transport-native-epoll", this.withUnverifiedRuntimeVersionOptional("4.0.56.Final"));
        expected.put("org.slf4j:slf4j-api", this.withUnverifiedRuntimeVersion("1.7.25"));
        expected.put("org.ow2.asm:asm", this.withUnverifiedRuntimeVersion("5.0.3"));
        expected.put("com.esri.geometry:esri-geometry-api", this.withUnverifiedRuntimeVersion("1.2.1"));
        expected.put("io.netty:netty-transport", this.withUnverifiedRuntimeVersion("4.0.56.Final"));
        expected.put("com.github.jnr:jnr-x86asm", this.withUnverifiedRuntimeVersion("1.0.2"));
        expected.put("org.ow2.asm:asm-analysis", this.withUnverifiedRuntimeVersion("5.0.3"));
        expected.put("com.github.jnr:jnr-constants", this.withUnverifiedRuntimeVersion("0.9.9"));
        expected.put("io.netty:netty-common", this.withUnverifiedRuntimeVersion("4.0.56.Final"));
        expected.put("com.google.guava:guava", this.withUnverifiedRuntimeVersion("19.0"));
        expected.put("org.xerial.snappy:snappy-java", this.withUnverifiedRuntimeVersionOptional("1.1.2.6"));
        expected.put("io.dropwizard.metrics:metrics-core", this.withUnverifiedRuntimeVersion("3.2.2"));
        expected.put("org.ow2.asm:asm-tree", this.withUnverifiedRuntimeVersion("5.0.3"));
        expected.put("com.github.jnr:jnr-posix", this.withUnverifiedRuntimeVersion("3.0.44"));
        expected.put("org.codehaus.jackson:jackson-core-asl", this.withUnverifiedRuntimeVersion("1.9.12"));
        expected.put("com.fasterxml.jackson.core:jackson-databind", this.withUnverifiedRuntimeVersion("2.7.9.3"));
        expected.put("io.netty:netty-codec", this.withUnverifiedRuntimeVersion("4.0.56.Final"));
        expected.put("com.fasterxml.jackson.core:jackson-annotations", this.withUnverifiedRuntimeVersion("2.8.11"));
        expected.put("com.fasterxml.jackson.core:jackson-core", this.withUnverifiedRuntimeVersion("2.8.11"));
        expected.put("io.netty:netty-handler", this.withUnverifiedRuntimeVersion("4.0.56.Final"));
        expected.put("org.lz4:lz4-java", this.withUnverifiedRuntimeVersionOptional("1.4.1"));
        expected.put("org.hdrhistogram:HdrHistogram", this.withUnverifiedRuntimeVersionOptional("2.1.10"));
        expected.put("com.github.jnr:jffi", this.withUnverifiedRuntimeVersion("1.2.16"));
        expected.put("io.netty:netty-buffer", this.withUnverifiedRuntimeVersion("4.0.56.Final"));
        expected.put("org.ow2.asm:asm-commons", this.withUnverifiedRuntimeVersion("5.0.3"));
        expected.put("org.json:json", this.withUnverifiedRuntimeVersion("20090211"));
        expected.put("org.ow2.asm:asm-util", this.withUnverifiedRuntimeVersion("5.0.3"));
        expected.put("com.github.jnr:jnr-ffi", this.withUnverifiedRuntimeVersion("2.1.7"));
        Map stringStringMap = new PlatformInfoFinder(NULL_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).hasSize(28);
        Assertions.assertThat((Map)stringStringMap).isEqualTo(expected);
    }

    @Test(groups={"unit"})
    public void should_find_dependencies_from_file_without_duplicate() {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/duplicate-dependencies.txt");
        Map stringStringMap = new PlatformInfoFinder(NULL_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).hasSize(1);
    }

    @Test(groups={"unit"})
    public void should_keep_order_of_dependencies() {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/ordered-dependencies.txt");
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> expected = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        expected.put("b-org.com:art1", this.withUnverifiedRuntimeVersion("1.0"));
        expected.put("a-org.com:art1", this.withUnverifiedRuntimeVersion("2.0"));
        expected.put("c-org.com:art1", this.withUnverifiedRuntimeVersion("3.0"));
        Map stringStringMap = new PlatformInfoFinder(NULL_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).isEqualTo(expected);
        Iterator iterator = expected.keySet().iterator();
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo((Object)"b-org.com:art1");
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo((Object)"a-org.com:art1");
        Assertions.assertThat((String)((String)iterator.next())).isEqualTo((Object)"c-org.com:art1");
    }

    @Test(groups={"unit"})
    public void should_add_information_about_java_platform() {
        HashMap runtimeDependencies = new HashMap();
        new PlatformInfoFinder(NULL_URL_PROVIDER).addJavaVersion(runtimeDependencies);
        Map javaDependencies = (Map)runtimeDependencies.get("java");
        Assertions.assertThat((int)javaDependencies.size()).isEqualTo(3);
    }

    @Test(groups={"unit"})
    public void should_load_runtime_version_from_pom_properties_URL() {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/netty-dependency.txt");
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> expected = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        expected.put("io.netty:netty-handler", new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions("4.0.56.Final", "4.0.0.Final", false));
        Map stringStringMap = new PlatformInfoFinder(NETTY_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).isEqualTo(expected);
    }

    @Test(groups={"unit"})
    public void should_load_runtime_version_of_optional_dependency_from_pom_properties_URL() {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/netty-dependency-optional.txt");
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> expected = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        expected.put("io.netty:netty-handler", new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions("4.0.56.Final", "4.0.0.Final", true));
        Map stringStringMap = new PlatformInfoFinder(NETTY_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).isEqualTo(expected);
    }

    @Test(groups={"unit"})
    public void should_not_load_runtime_dependency_from_malformed_pom_properties() {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/netty-dependency.txt");
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> expected = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        expected.put("io.netty:netty-handler", this.withUnverifiedRuntimeVersion("4.0.0.Final"));
        Map stringStringMap = new PlatformInfoFinder(MALFORMED_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).isEqualTo(expected);
    }

    @Test(groups={"unit"})
    public void should_not_load_runtime_dependency_from_non_existing_pom_properties() {
        InputStream inputStream = this.getClass().getResourceAsStream("/insights/netty-dependency.txt");
        LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions> expected = new LinkedHashMap<String, InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions>();
        expected.put("io.netty:netty-handler", this.withUnverifiedRuntimeVersion("4.0.0.Final"));
        Map stringStringMap = new PlatformInfoFinder(NON_EXISTING_URL_PROVIDER).fetchDependenciesFromFile(inputStream);
        Assertions.assertThat((Map)stringStringMap).isEqualTo(expected);
    }

    private InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions withUnverifiedRuntimeVersion(String compileVersion) {
        return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions("UNVERIFIED", compileVersion, false);
    }

    private InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions withUnverifiedRuntimeVersionOptional(String compileVersion) {
        return new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions("UNVERIFIED", compileVersion, true);
    }
}

