/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.ParseUtils;
import org.testng.annotations.Test;

public class ParseUtilsTest {
    @Test(groups={"unit"})
    public void testQuote() {
        Assertions.assertThat((String)ParseUtils.quote(null)).isEqualTo((Object)"''");
        Assertions.assertThat((String)ParseUtils.quote((String)"")).isEqualTo((Object)"''");
        Assertions.assertThat((String)ParseUtils.quote((String)" ")).isEqualTo((Object)"' '");
        Assertions.assertThat((String)ParseUtils.quote((String)"foo")).isEqualTo((Object)"'foo'");
        Assertions.assertThat((String)ParseUtils.quote((String)" 'foo' ")).isEqualTo((Object)"' ''foo'' '");
    }

    @Test(groups={"unit"})
    public void testUnquote() {
        Assertions.assertThat((String)ParseUtils.unquote(null)).isNull();
        Assertions.assertThat((String)ParseUtils.unquote((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)ParseUtils.unquote((String)" ")).isEqualTo((Object)" ");
        Assertions.assertThat((String)ParseUtils.unquote((String)"'")).isEqualTo((Object)"'");
        Assertions.assertThat((String)ParseUtils.unquote((String)"foo")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)ParseUtils.unquote((String)"''")).isEqualTo((Object)"");
        Assertions.assertThat((String)ParseUtils.unquote((String)"' '")).isEqualTo((Object)" ");
        Assertions.assertThat((String)ParseUtils.unquote((String)"'foo")).isEqualTo((Object)"'foo");
        Assertions.assertThat((String)ParseUtils.unquote((String)"'foo'")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)ParseUtils.unquote((String)" 'foo' ")).isEqualTo((Object)" 'foo' ");
        Assertions.assertThat((String)ParseUtils.unquote((String)"'''foo'''")).isEqualTo((Object)"'foo'");
        Assertions.assertThat((String)ParseUtils.unquote((String)"'''")).isEqualTo((Object)"'");
        Assertions.assertThat((String)ParseUtils.unquote((String)"''foo'")).isEqualTo((Object)"'foo");
        Assertions.assertThat((String)ParseUtils.unquote((String)"'foo''")).isEqualTo((Object)"foo'");
    }

    @Test(groups={"unit"})
    public void testIsQuoted() {
        Assertions.assertThat((boolean)ParseUtils.isQuoted(null)).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)" ")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"'")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"foo")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"''")).isTrue();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"' '")).isTrue();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"'foo")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"'foo'")).isTrue();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)" 'foo' ")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isQuoted((String)"'''foo'''")).isTrue();
    }

    @Test(groups={"unit"})
    public void testDoubleQuote() {
        Assertions.assertThat((String)ParseUtils.doubleQuote(null)).isEqualTo((Object)"\"\"");
        Assertions.assertThat((String)ParseUtils.doubleQuote((String)"")).isEqualTo((Object)"\"\"");
        Assertions.assertThat((String)ParseUtils.doubleQuote((String)" ")).isEqualTo((Object)"\" \"");
        Assertions.assertThat((String)ParseUtils.doubleQuote((String)"foo")).isEqualTo((Object)"\"foo\"");
        Assertions.assertThat((String)ParseUtils.doubleQuote((String)" \"foo\" ")).isEqualTo((Object)"\" \"\"foo\"\" \"");
    }

    @Test(groups={"unit"})
    public void testDoubleUnquote() {
        Assertions.assertThat((String)ParseUtils.unDoubleQuote(null)).isNull();
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"")).isEqualTo((Object)"");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)" ")).isEqualTo((Object)" ");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"")).isEqualTo((Object)"\"");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"foo")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"\"")).isEqualTo((Object)"");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\" \"")).isEqualTo((Object)" ");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"foo")).isEqualTo((Object)"\"foo");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"foo\"")).isEqualTo((Object)"foo");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)" \"foo\" ")).isEqualTo((Object)" \"foo\" ");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"\"\"foo\"\"\"")).isEqualTo((Object)"\"foo\"");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"\"\"")).isEqualTo((Object)"\"");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"\"foo\"")).isEqualTo((Object)"\"foo");
        Assertions.assertThat((String)ParseUtils.unDoubleQuote((String)"\"foo\"\"")).isEqualTo((Object)"foo\"");
    }

    @Test(groups={"unit"})
    public void testIsDoubleQuoted() {
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted(null)).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)" ")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"\"")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"foo")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"\"\"")).isTrue();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"\" \"")).isTrue();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"\"foo")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"\"foo\"")).isTrue();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)" \"foo\" ")).isFalse();
        Assertions.assertThat((boolean)ParseUtils.isDoubleQuoted((String)"\"\"\"foo\"\"\"")).isTrue();
    }
}

