/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PagingState;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.exceptions.PagingStateException;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.Iterator;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

@CassandraVersion(value="2.0.0")
public class PagingStateTest
extends CCMTestsSupport {
    private static final Logger logger = LoggerFactory.getLogger(PagingStateTest.class);
    public static final String KEY = "paging_test";

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))");
        for (int i = 0; i < 100; ++i) {
            this.execute(String.format("INSERT INTO test (k, v) VALUES ('%s', %d)", KEY, i));
        }
    }

    @Test(groups={"short"})
    public void should_complete_when_using_paging_state() {
        SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        ResultSet result = this.session().execute(st.setFetchSize(20));
        int pageSize = result.getAvailableWithoutFetching();
        String savedPagingStateString = result.getExecutionInfo().getPagingState().toString();
        st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        result = this.session().execute(st.setFetchSize(20).setPagingState(PagingState.fromString((String)savedPagingStateString)));
        Assertions.assertThat((int)result.one().getInt("v")).isEqualTo(pageSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_fail_if_paging_state_altered() {
        boolean setWithFalseContent = false;
        boolean setWithWrongStatement = false;
        SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        ResultSet result = this.session().execute(st.setFetchSize(20));
        PagingState savedPagingState = result.getExecutionInfo().getPagingState();
        byte[] savedPagingStateBuffer = savedPagingState.toBytes();
        String savedPagingStateString = savedPagingState.toString();
        savedPagingStateBuffer[6] = 42;
        try {
            st.setFetchSize(20).setPagingState(PagingState.fromBytes((byte[])savedPagingStateBuffer));
        }
        catch (PagingStateException e) {
            setWithFalseContent = true;
            logger.debug(e.getMessage());
        }
        finally {
            Assertions.assertThat((boolean)setWithFalseContent).isTrue();
            Assertions.assertThat((Comparable)st.getPagingState()).isNull();
        }
        st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", "paging"));
        try {
            st.setFetchSize(20).setPagingState(PagingState.fromString((String)savedPagingStateString));
        }
        catch (PagingStateException e) {
            setWithWrongStatement = true;
            logger.debug(e.getMessage());
        }
        finally {
            Assertions.assertThat((boolean)setWithWrongStatement).isTrue();
            Assertions.assertThat((Comparable)st.getPagingState()).isNull();
        }
    }

    @Test(groups={"short"})
    public void should_use_state_with_wrapped_statement() {
        TestWrapper st = new TestWrapper((Statement)new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY)));
        ResultSet result = this.session().execute(st.setFetchSize(20));
        int pageSize = result.getAvailableWithoutFetching();
        String savedPagingStateString = result.getExecutionInfo().getPagingState().toString();
        st = new TestWrapper((Statement)new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY)));
        result = this.session().execute(st.setFetchSize(20).setPagingState(PagingState.fromString((String)savedPagingStateString)));
        Assertions.assertThat((int)result.one().getInt("v")).isEqualTo(pageSize);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_be_able_to_use_state_with_bound_statement() {
        PreparedStatement prepared = this.session().prepare("SELECT v from test where k=?");
        BoundStatement bs = prepared.bind(new Object[]{KEY});
        ResultSet result = this.session().execute(bs.setFetchSize(20));
        int pageSize = result.getAvailableWithoutFetching();
        PagingState pagingState = result.getExecutionInfo().getPagingState();
        result = this.session().execute(bs.setFetchSize(20).setPagingState(pagingState));
        Assertions.assertThat((int)result.one().getInt("v")).isEqualTo(pageSize);
    }

    @Test(groups={"short"}, expectedExceptions={PagingStateException.class})
    @CassandraVersion(value="2.0.0")
    public void should_not_be_able_to_use_state_with_different_bound_statement() {
        PreparedStatement prepared = this.session().prepare("SELECT v from test where k=?");
        BoundStatement bs0 = prepared.bind(new Object[]{KEY});
        ResultSet result = this.session().execute(bs0.setFetchSize(20));
        PagingState pagingState = result.getExecutionInfo().getPagingState();
        BoundStatement bs1 = prepared.bind(new Object[]{"different_key"});
        this.session().execute(bs1.setFetchSize(20).setPagingState(pagingState));
    }

    @Test(groups={"short"})
    public void should_return_no_rows_when_paged_to_end() {
        SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        ResultSet result = this.session().execute(st.setFetchSize(20));
        Iterator rowIt = result.iterator();
        for (int i = 0; i < 83; ++i) {
            ((Row)rowIt.next()).getInt("v");
        }
        String savedPagingStateString = result.getExecutionInfo().getPagingState().toString();
        st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        result = this.session().execute(st.setFetchSize(20).setPagingState(PagingState.fromString((String)savedPagingStateString)));
        Assertions.assertThat((Object)result.one()).isNull();
    }

    @Test(groups={"unit"}, expectedExceptions={PagingStateException.class})
    public void should_fail_when_given_invalid_string() {
        PagingState.fromString((String)"0101");
    }

    @Test(groups={"unit"}, expectedExceptions={PagingStateException.class})
    public void should_fail_when_given_invalid_byte_array() {
        byte[] complete = new byte[]{0, 1, 0, 1, 0};
        PagingState.fromBytes((byte[])complete);
    }

    @Test(groups={"unit"}, expectedExceptions={UnsupportedOperationException.class})
    public void should_fail_when_setting_paging_state_on_batch_statement() {
        PagingState emptyStatement = PagingState.fromString((String)"00000000");
        BatchStatement batch = new BatchStatement();
        batch.setPagingState(emptyStatement);
    }

    @Test(groups={"short"})
    public void should_complete_when_using_unsafe_paging_state() {
        SimpleStatement st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        ResultSet result = this.session().execute(st.setFetchSize(20));
        int pageSize = result.getAvailableWithoutFetching();
        byte[] savedPagingState = result.getExecutionInfo().getPagingStateUnsafe();
        st = new SimpleStatement(String.format("SELECT v FROM test WHERE k='%s'", KEY));
        result = this.session().execute(st.setFetchSize(20).setPagingStateUnsafe(savedPagingState));
        Assertions.assertThat((int)result.one().getInt("v")).isEqualTo(pageSize);
    }

    static class TestWrapper
    extends StatementWrapper {
        TestWrapper(Statement wrapped) {
            super(wrapped);
        }
    }
}

