/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.utils.Bytes;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class OPPTokenFactoryTest {
    private static final Token.Factory factory = Token.OPPToken.FACTORY;
    private static final Token minToken = OPPTokenFactoryTest.token(ByteBuffer.allocate(0));

    @Test(groups={"unit"})
    public void should_split_range() {
        List splits = factory.split(OPPTokenFactoryTest.token('a'), OPPTokenFactoryTest.token('d'), 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{OPPTokenFactoryTest.token('b'), OPPTokenFactoryTest.token('c')});
    }

    @Test(groups={"unit"})
    public void should_split_range_producing_empty_splits_near_ring_end() {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[]{0});
        Token zero = OPPTokenFactoryTest.token(buffer);
        List splits = factory.split(minToken, zero, 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{zero, zero});
    }

    @Test(groups={"unit"})
    public void should_split_range_where_start_as_int_equals_end_as_int() {
        Token start = OPPTokenFactoryTest.token(Bytes.fromHexString((String)"0x11"));
        Token end = OPPTokenFactoryTest.token(Bytes.fromHexString((String)"0x1100"));
        List splits = factory.split(start, end, 3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new Token[]{end, end});
    }

    @Test(groups={"unit"})
    public void should_split_range_that_wraps_around_the_ring() {
        for (int start = 1; start < 128; ++start) {
            for (int end = start; end < start; ++end) {
                long expected = 129 + (start + end) / 2;
                TokenRange tr = new TokenRange(OPPTokenFactoryTest.token(start), OPPTokenFactoryTest.token(end), factory);
                ((AbstractListAssert)Assertions.assertThat((List)factory.split(tr.getStart(), tr.getEnd(), 2)).as("Expected 0x%X for start: %d, end: %d", new Object[]{expected, start, end})).containsExactly((Object[])new Token[]{OPPTokenFactoryTest.token(expected)});
            }
        }
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_not_be_allowed_to_split_with_min_token() {
        factory.split(minToken, minToken, 1);
    }

    private static Token token(char c) {
        return new Token.OPPToken(ByteBuffer.wrap(new byte[]{(byte)c}));
    }

    private static Token token(long i) {
        return new Token.OPPToken(ByteBuffer.wrap(BigInteger.valueOf(i).toByteArray()));
    }

    private static Token token(ByteBuffer buffer) {
        return factory.deserialize(buffer, ProtocolVersion.NEWEST_SUPPORTED);
    }
}

