/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import org.testng.Assert;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(numberOfNodes={2}, dirtiesContext={true}, createCluster={false})
public class MissingRpcAddressTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void testMissingRpcAddressAtStartup() throws Exception {
        this.deleteNode2RpcAddressFromNode1();
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).build());
        cluster.connect();
        Assert.assertEquals((int)((Integer)cluster.getMetrics().getConnectedToHosts().getValue()), (int)1);
        Assert.assertNull((Object)cluster.getMetadata().getHost(this.getContactPointsWithPorts().get(1)));
    }

    private void deleteNode2RpcAddressFromNode1() throws Exception {
        InetSocketAddress firstHost = this.ccm().addressOfNode(1);
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{firstHost.getAddress()}).withPort(this.ccm().getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy(Policies.defaultLoadBalancingPolicy(), (Collection)Lists.newArrayList((Object[])new InetSocketAddress[]{firstHost}))).build());
        Session session = cluster.connect();
        String deleteStmt = String.format("DELETE rpc_address FROM system.peers WHERE peer = '%s'", this.ccm().addressOfNode(2).getHostName());
        session.execute(deleteStmt);
        session.close();
        cluster.close();
    }
}

