/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.scassandra.Scassandra;
import org.scassandra.http.client.PrimingRequest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MetricsInFlightTest {
    private ScassandraCluster sCluster;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.sCluster = ScassandraCluster.builder().withNodes(1).build();
        this.sCluster.init();
    }

    @AfterMethod(groups={"short"})
    public void tearDown() {
        this.clearActivityLog();
        this.sCluster.stop();
    }

    public void clearActivityLog() {
        for (Scassandra node : this.sCluster.nodes()) {
            node.activityClient().clearAllRecordedActivity();
        }
    }

    public Cluster.Builder builder() {
        return Cluster.builder().addContactPoints(new InetAddress[]{this.sCluster.address(1).getAddress()}).withPort(this.sCluster.getBinaryPort()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions);
    }

    @Test(groups={"short"})
    public void should_count_inflight_requests_metrics() {
        this.sCluster.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withFixedDelay(Long.valueOf(100000L))).build());
        Cluster cluster = null;
        try {
            cluster = this.builder().build();
            Session session = cluster.connect();
            Assertions.assertThat((Integer)((Integer)cluster.getMetrics().getInFlightRequests().getValue())).isEqualTo(0);
            session.executeAsync("mock query");
            session.executeAsync("mock query");
            Assertions.assertThat((Integer)((Integer)cluster.getMetrics().getInFlightRequests().getValue())).isEqualTo(2);
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
    }

    @Test(groups={"short"})
    public void should_countdown_inflight_requests_metrics() {
        this.sCluster.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then()).build());
        Cluster cluster = null;
        try {
            cluster = this.builder().build();
            Session session = cluster.connect();
            Assertions.assertThat((Integer)((Integer)cluster.getMetrics().getInFlightRequests().getValue())).isEqualTo(0);
            session.executeAsync("mock query").getUninterruptibly();
            session.executeAsync("mock query").getUninterruptibly();
            Assertions.assertThat((Integer)((Integer)cluster.getMetrics().getInFlightRequests().getValue())).isEqualTo(0);
        }
        finally {
            if (cluster != null) {
                cluster.close();
            }
        }
    }
}

