/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.google.common.collect.Maps;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class MetadataTest
extends CCMTestsSupport {
    @Test(groups={"long"})
    @CCMConfig(numberOfNodes={3}, dirtiesContext={true}, createCluster={false})
    public void should_update_metadata_on_topology_change() {
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build());
        Session session = cluster.connect();
        String keyspace = "test";
        session.execute("CREATE KEYSPACE " + keyspace + " WITH replication = {'class': 'SimpleStrategy', 'replication_factor': 1}");
        Metadata metadata = cluster.getMetadata();
        Assertions.assertThat((Iterable)metadata.getTokenRanges()).hasSize(3);
        Map<Host, Token> tokensForHost = this.getTokenForHosts(metadata);
        Host host3 = TestUtils.findHost(cluster, 3);
        Token host3Token = tokensForHost.get(host3);
        this.ccm().decommission(3);
        this.ccm().remove(3);
        Assertions.assertThat((Iterable)metadata.getTokenRanges()).hasSize(2);
        Assertions.assertThat(this.getTokenForHosts(metadata)).doesNotContainValue((Object)host3Token);
        Assertions.assertThat(cluster).hasValidTokenRanges("test");
        Assertions.assertThat(cluster).hasValidTokenRanges();
        this.ccm().add(4);
        this.ccm().start(4);
        TestUtils.waitForUp(TestUtils.IP_PREFIX + '4', cluster);
        Assertions.assertThat((Iterable)metadata.getTokenRanges()).hasSize(3);
        Host host4 = TestUtils.findHost(cluster, 4);
        TokenRange host4Range = (TokenRange)metadata.getTokenRanges(keyspace, host4).iterator().next();
        for (Host host : metadata.getAllHosts()) {
            if (host.equals((Object)host4)) continue;
            TokenRange hostRange = (TokenRange)metadata.getTokenRanges(keyspace, host).iterator().next();
            Assertions.assertThat(host4Range).doesNotIntersect(hostRange);
        }
        Assertions.assertThat(cluster).hasValidTokenRanges("test");
        Assertions.assertThat(cluster).hasValidTokenRanges();
    }

    private Map<Host, Token> getTokenForHosts(Metadata metadata) {
        HashMap tokensByHost = Maps.newHashMap();
        for (Host host : metadata.getAllHosts()) {
            tokensByHost.put(host, host.getTokens().iterator().next());
        }
        return tokensByHost;
    }

    @Test(groups={"unit"})
    public void handleId_should_lowercase_unquoted_alphanumeric_identifiers() {
        Assertions.assertThat((String)Metadata.handleId((String)"FooBar1")).isEqualTo((Object)"foobar1");
        Assertions.assertThat((String)Metadata.handleId((String)"Foo_Bar_1")).isEqualTo((Object)"foo_bar_1");
        Assertions.assertThat((String)Metadata.handleId((String)"foo_bar_1")).isEqualTo((Object)"foo_bar_1");
    }

    @Test(groups={"unit"})
    public void handleId_should_unquote_and_preserve_case_of_quoted_identifiers() {
        Assertions.assertThat((String)Metadata.handleId((String)"\"FooBar1\"")).isEqualTo((Object)"FooBar1");
        Assertions.assertThat((String)Metadata.handleId((String)"\"Foo_Bar_1\"")).isEqualTo((Object)"Foo_Bar_1");
        Assertions.assertThat((String)Metadata.handleId((String)"\"Foo Bar 1\"")).isEqualTo((Object)"Foo Bar 1");
    }

    @Test(groups={"unit"})
    public void handleId_should_unescape_duplicate_double_quotes_in_quoted_identifiers() {
        Assertions.assertThat((String)Metadata.handleId((String)"\"Foo\"\"Bar\"")).isEqualTo((Object)"Foo\"Bar");
    }

    @Test(groups={"unit"})
    public void handleId_should_preserve_unquoted_non_alphanumeric_identifiers() {
        Assertions.assertThat((String)Metadata.handleId((String)"Foo Bar")).isEqualTo((Object)"Foo Bar");
    }

    @Test(groups={"unit"})
    public void escapeId_should_not_quote_lowercase_identifiers() {
        String id = "this_does_not_need_quoting_0123456789abcdefghijklmnopqrstuvwxyz";
        Assertions.assertThat((String)Metadata.quoteIfNecessary((String)id)).isEqualTo((Object)id);
    }

    @Test(groups={"unit"})
    public void escapeId_should_quote_non_lowercase_identifiers() {
        Assertions.assertThat((String)Metadata.quoteIfNecessary((String)"This_Needs_Quoting_1234")).isEqualTo((Object)"\"This_Needs_Quoting_1234\"");
        Assertions.assertThat((String)Metadata.quoteIfNecessary((String)"This Needs Quoting 1234!!")).isEqualTo((Object)"\"This Needs Quoting 1234!!\"");
    }

    @Test(groups={"unit"})
    public void escapeId_should_quote_reserved_cql_keywords() {
        Assertions.assertThat((String)Metadata.quoteIfNecessary((String)"columnfamily")).isEqualTo((Object)"\"columnfamily\"");
    }

    @Test(groups={"unit"})
    public void escapeId_should_quote_empty_keyword() {
        Assertions.assertThat((String)Metadata.quoteIfNecessary((String)"")).isEqualTo((Object)"\"\"");
    }

    @Test(groups={"unit"})
    public void should_detect_reserved_keywords_in_upper_case() {
        Assertions.assertThat((boolean)Metadata.isReservedCqlKeyword((String)"COLUMNFAMILY")).isTrue();
        Assertions.assertThat((boolean)Metadata.isReservedCqlKeyword((String)"TEST_COLUMNFAMILY")).isFalse();
    }

    @Test(groups={"unit"})
    public void should_detect_reserved_keywords_in_lower_case() {
        Assertions.assertThat((boolean)Metadata.isReservedCqlKeyword((String)"columnfamily")).isTrue();
        Assertions.assertThat((boolean)Metadata.isReservedCqlKeyword((String)"test_columnfamily")).isFalse();
    }

    @Test(groups={"unit"})
    public void should_detect_reserved_keywords_in_mixed_case() {
        Assertions.assertThat((boolean)Metadata.isReservedCqlKeyword((String)"ColumnFamily")).isTrue();
        Assertions.assertThat((boolean)Metadata.isReservedCqlKeyword((String)"Test_ColumnFamily")).isFalse();
    }
}

