/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.utils.MoreObjects;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={2}, dirtiesContext={true}, createCluster={false})
@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
public class LoadBalancingPolicyBootstrapTest
extends CCMTestsSupport {
    private static final Logger logger = LoggerFactory.getLogger(LoadBalancingPolicyBootstrapTest.class);

    @Test(groups={"short"})
    public void should_init_policy_with_up_contact_points() throws Exception {
        HistoryPolicy policy = new HistoryPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build());
        try {
            cluster.init();
            Assertions.assertThat(policy.history).containsOnly((Object[])new Entry[]{LoadBalancingPolicyBootstrapTest.entry(Action.INIT, TestUtils.findHost(cluster, 1)), LoadBalancingPolicyBootstrapTest.entry(Action.INIT, TestUtils.findHost(cluster, 2))});
        }
        finally {
            cluster.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"})
    public void should_send_down_notifications_after_init_when_contact_points_are_down() throws Exception {
        int tries;
        int nodeToStop = 1;
        int maxTries = 10;
        for (tries = 1; tries <= maxTries; ++tries) {
            nodeToStop = nodeToStop == 1 ? 2 : 1;
            int activeNode = nodeToStop == 2 ? 1 : 2;
            this.ccm().stop(nodeToStop);
            this.ccm().waitForDown(nodeToStop);
            HistoryPolicy policy = new HistoryPolicy((LoadBalancingPolicy)new RoundRobinPolicy());
            Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).build());
            try {
                cluster.init();
                if (policy.history.contains(LoadBalancingPolicyBootstrapTest.entry(Action.DOWN, TestUtils.findHost(cluster, nodeToStop)))) {
                    Assertions.assertThat(policy.history).containsExactly((Object[])new Entry[]{LoadBalancingPolicyBootstrapTest.entry(Action.INIT, TestUtils.findHost(cluster, activeNode)), LoadBalancingPolicyBootstrapTest.entry(Action.DOWN, TestUtils.findHost(cluster, nodeToStop))});
                    break;
                }
                Assertions.assertThat(policy.history).containsOnly((Object[])new Entry[]{LoadBalancingPolicyBootstrapTest.entry(Action.INIT, TestUtils.findHost(cluster, 1)), LoadBalancingPolicyBootstrapTest.entry(Action.INIT, TestUtils.findHost(cluster, 2))});
                logger.info("Could not get first contact point to fail, retrying");
                cluster.close();
                this.ccm().start(nodeToStop);
                this.ccm().waitForUp(nodeToStop);
                continue;
            }
            finally {
                cluster.close();
            }
        }
        if (tries == maxTries + 1) {
            logger.warn("Could not get first contact point to fail after {} tries", (Object)maxTries);
        }
    }

    static Entry entry(Action action, Host host) {
        return new Entry(action, host);
    }

    static class HistoryPolicy
    extends DelegatingLoadBalancingPolicy {
        List<Entry> history = Lists.newArrayList();

        public HistoryPolicy(LoadBalancingPolicy delegate) {
            super(delegate);
        }

        @Override
        public void init(Cluster cluster, Collection<Host> hosts) {
            super.init(cluster, hosts);
            for (Host host : hosts) {
                this.history.add(LoadBalancingPolicyBootstrapTest.entry(Action.INIT, host));
            }
        }

        @Override
        public void onAdd(Host host) {
            this.history.add(LoadBalancingPolicyBootstrapTest.entry(Action.ADD, host));
            super.onAdd(host);
        }

        @Override
        public void onUp(Host host) {
            this.history.add(LoadBalancingPolicyBootstrapTest.entry(Action.UP, host));
            super.onUp(host);
        }

        @Override
        public void onDown(Host host) {
            this.history.add(LoadBalancingPolicyBootstrapTest.entry(Action.DOWN, host));
            super.onDown(host);
        }

        @Override
        public void onRemove(Host host) {
            this.history.add(LoadBalancingPolicyBootstrapTest.entry(Action.REMOVE, host));
            super.onRemove(host);
        }
    }

    static class Entry {
        final Action action;
        final Host host;

        public Entry(Action action, Host host) {
            this.action = action;
            this.host = host;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other instanceof Entry) {
                Entry that = (Entry)other;
                return this.action == that.action && this.host.equals((Object)that.host);
            }
            return false;
        }

        public int hashCode() {
            return MoreObjects.hashCode((Object[])new Object[]{this.action, this.host});
        }

        public String toString() {
            return String.format("Entry(action=%s, host=%s)", new Object[]{this.action, this.host});
        }
    }

    static enum Action {
        INIT,
        UP,
        DOWN,
        ADD,
        REMOVE;

    }
}

