/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.InsightsSupportVerifier;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.VersionNumber;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InsightsSupportVerifierTest {
    @Test(groups={"unit"}, dataProvider="dse-hosts-provider")
    public void should_detect_DSE_versions_that_supports_insights(Set<Host> hosts, boolean expected) {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)cluster.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)metadata.getAllHosts()).thenReturn(hosts);
        boolean result = InsightsSupportVerifier.supportsInsights((Cluster)cluster);
        Assertions.assertThat((boolean)result).isEqualTo(expected);
    }

    @DataProvider(name="dse-hosts-provider")
    public static Object[][] dseHostsProvider() {
        Host dse605 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)dse605.getDseVersion()).thenReturn((Object)VersionNumber.parse((String)"6.0.5"));
        Host dse604 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)dse604.getDseVersion()).thenReturn((Object)VersionNumber.parse((String)"6.0.4"));
        Host dse600 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)dse600.getDseVersion()).thenReturn((Object)VersionNumber.parse((String)"6.0.0"));
        Host dse5113 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)dse5113.getDseVersion()).thenReturn((Object)VersionNumber.parse((String)"5.1.13"));
        Host dse500 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)dse500.getDseVersion()).thenReturn((Object)VersionNumber.parse((String)"5.0.0"));
        Host nullHost = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)dse500.getDseVersion()).thenReturn(null);
        return new Object[][]{{ImmutableSet.of((Object)dse605), true}, {ImmutableSet.of((Object)dse604), false}, {ImmutableSet.of((Object)dse600), false}, {ImmutableSet.of((Object)dse5113), true}, {ImmutableSet.of((Object)dse500), false}, {ImmutableSet.of((Object)dse5113, (Object)dse605), true}, {ImmutableSet.of((Object)dse5113, (Object)dse600), false}, {ImmutableSet.of((Object)dse500, (Object)dse600), false}, {ImmutableSet.of(), false}, {ImmutableSet.of((Object)nullHost), false}};
    }
}

