/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.ConfigAntiPatternsFinder;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.ControlConnection;
import com.datastax.driver.core.DataCentersFinder;
import com.datastax.driver.core.ExecutionProfilesInfoFinder;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.InsightsClient;
import com.datastax.driver.core.InsightsConfiguration;
import com.datastax.driver.core.InsightsSchema;
import com.datastax.driver.core.PlatformInfoFinder;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.ReconnectionPolicyInfoFinder;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SessionManager;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.SpeculativeExecutionInfoFinder;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ConstantSpeculativeExecutionPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.dse.auth.DsePlainTextAuthProvider;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.assertj.core.api.Assertions;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class InsightsClientTest {
    private static final StackTraceElement[] EMPTY_STACK_TRACE = new StackTraceElement[0];
    private static final Map<String, Object> EMPTY_OBJECT_MAP = Collections.emptyMap();
    private static final Supplier<Long> MOCK_TIME_SUPPLIER = new Supplier<Long>(){

        public Long get() {
            return 1L;
        }
    };
    private static final InsightsConfiguration INSIGHTS_CONFIGURATION = new InsightsConfiguration(true, Long.valueOf(300000L));

    @Test(groups={"unit"})
    public void should_construct_json_event_startup_message() throws IOException {
        Cluster cluster = this.mockCluster();
        PlatformInfoFinder platformInfoFinder = (PlatformInfoFinder)Mockito.mock(PlatformInfoFinder.class);
        InsightsSchema.InsightsPlatformInfo.OS os = new InsightsSchema.InsightsPlatformInfo.OS("linux", "1.2", "x64");
        InsightsSchema.InsightsPlatformInfo.CPUS cpus = new InsightsSchema.InsightsPlatformInfo.CPUS(8, "intel i7");
        ImmutableMap javaDeps = ImmutableMap.of((Object)"version", (Object)new InsightsSchema.InsightsPlatformInfo.RuntimeAndCompileTimeVersions("1.8.0", "1.8.0", false));
        ImmutableMap runtimeInfo = ImmutableMap.of((Object)"java", (Object)javaDeps);
        InsightsSchema.InsightsPlatformInfo insightsPlatformInfo = new InsightsSchema.InsightsPlatformInfo(os, cpus, (Map)runtimeInfo);
        Mockito.when((Object)platformInfoFinder.getInsightsPlatformInfo()).thenReturn((Object)insightsPlatformInfo);
        ConfigAntiPatternsFinder configAntiPatternsFinder = (ConfigAntiPatternsFinder)Mockito.mock(ConfigAntiPatternsFinder.class);
        Mockito.when((Object)configAntiPatternsFinder.findAntiPatterns((Cluster)Matchers.any(Cluster.class))).thenReturn((Object)ImmutableMap.of((Object)"contactPointsMultipleDCs", (Object)"Contact points contain hosts from multiple data centers"));
        DataCentersFinder dataCentersFinder = (DataCentersFinder)Mockito.mock(DataCentersFinder.class);
        Mockito.when((Object)dataCentersFinder.getDataCenters((Cluster)Matchers.any(Cluster.class))).thenReturn((Object)Sets.newHashSet((Object[])new String[]{"dc1", "dc2"}));
        Mockito.when((Object)dataCentersFinder.getLocalDataCenter((Cluster)Matchers.any(Cluster.class))).thenReturn((Object)"dc1");
        InsightsClient insightsClient = new InsightsClient(cluster, null, MOCK_TIME_SUPPLIER, INSIGHTS_CONFIGURATION, platformInfoFinder, new ReconnectionPolicyInfoFinder(), new ExecutionProfilesInfoFinder(new SpeculativeExecutionInfoFinder(), dataCentersFinder), configAntiPatternsFinder, dataCentersFinder, EMPTY_STACK_TRACE);
        String startupMessage = insightsClient.createStartupMessage();
        InsightsSchema.Insight insight = (InsightsSchema.Insight)new ObjectMapper().readValue(startupMessage, (TypeReference)new TypeReference<InsightsSchema.Insight<InsightsSchema.InsightsStartupData>>(){});
        Assertions.assertThat((Object)insight.getMetadata()).isEqualTo((Object)new InsightsSchema.InsightsMetadata("driver.startup", 1L, (Map)ImmutableMap.of((Object)"language", (Object)"java"), InsightsSchema.InsightType.EVENT, "v1"));
        InsightsSchema.InsightsStartupData insightData = (InsightsSchema.InsightsStartupData)insight.getInsightsData();
        Assertions.assertThat((String)insightData.getClientId()).isEqualTo((Object)"client-id");
        Assertions.assertThat((String)insightData.getSessionId()).isNotNull();
        Assertions.assertThat((String)insightData.getDriverName()).isEqualTo((Object)"DataStax Enterprise Java Driver");
        Assertions.assertThat((String)insightData.getDriverVersion()).isNotEmpty();
        Assertions.assertThat((String)insightData.getApplicationName()).isEqualTo((Object)"app-name");
        Assertions.assertThat((String)insightData.getApplicationVersion()).isEqualTo((Object)"1.0.0");
        Assertions.assertThat((boolean)insightData.isApplicationNameWasGenerated()).isEqualTo(false);
        Assertions.assertThat((Map)insightData.getContactPoints()).isEqualTo((Object)ImmutableMap.of((Object)"127.0.0.1", (Object)ImmutableList.of((Object)"127.0.0.1"), (Object)"name1", (Object)ImmutableList.of((Object)"10.10.10.1:9094", (Object)"10.10.10.1:9093")));
        Assertions.assertThat((String)insightData.getInitialControlConnection()).isEqualTo((Object)"127.0.0.1:10");
        Assertions.assertThat((String)insightData.getLocalAddress()).isEqualTo((Object)"127.0.0.1");
        Assertions.assertThat((String)insightData.getHostName()).isNotEmpty();
        Assertions.assertThat((int)insightData.getProtocolVersion()).isEqualTo(ProtocolVersion.DSE_V2.toInt());
        Assertions.assertThat((Map)insightData.getExecutionProfiles()).isEqualTo((Object)ImmutableMap.of((Object)"default", (Object)new InsightsSchema.SpecificExecutionProfile(1000, new InsightsSchema.LoadBalancingInfo("RoundRobinPolicy", "com.datastax.driver.core.policies", (Map)ImmutableMap.of((Object)"localDataCenter", (Object)"dc1")), new InsightsSchema.SpeculativeExecutionInfo("ConstantSpeculativeExecutionPolicy", "com.datastax.driver.core.policies", (Map)ImmutableMap.of((Object)"constantDelayMillis", (Object)10, (Object)"maxSpeculativeExecutions", (Object)2)), "LOCAL_ONE", "SERIAL", EMPTY_OBJECT_MAP)));
        Assertions.assertThat((Object)insightData.getPoolSizeByHostDistance()).isEqualTo((Object)new InsightsSchema.PoolSizeByHostDistance(1, 2, 3));
        Assertions.assertThat((long)insightData.getHeartbeatInterval()).isEqualTo(1000L);
        Assertions.assertThat((Comparable)insightData.getCompression()).isEqualTo((Object)ProtocolOptions.Compression.NONE);
        Assertions.assertThat((Object)insightData.getReconnectionPolicy()).isEqualTo((Object)new InsightsSchema.ReconnectionPolicyInfo("ConstantReconnectionPolicy", "com.datastax.driver.core.policies", (Map)ImmutableMap.of((Object)"delayMs", (Object)100)));
        Assertions.assertThat((Object)insightData.getSsl()).isEqualTo((Object)new InsightsSchema.SSL(true));
        Assertions.assertThat((Object)insightData.getAuthProvider()).isEqualTo((Object)new InsightsSchema.AuthProviderType("DsePlainTextAuthProvider", "com.datastax.driver.dse.auth"));
        Assertions.assertThat((Map)insightData.getOtherOptions()).isEqualTo(EMPTY_OBJECT_MAP);
        Assertions.assertThat((Object)insightData.getPlatformInfo()).isEqualTo((Object)insightsPlatformInfo);
        Assertions.assertThat((Map)insightData.getConfigAntiPatterns()).isEqualTo((Object)ImmutableMap.of((Object)"contactPointsMultipleDCs", (Object)"Contact points contain hosts from multiple data centers"));
        Assertions.assertThat((long)insightData.getPeriodicStatusInterval()).isEqualTo(300L);
        Assertions.assertThat((Iterable)insightData.getDataCenters()).isEqualTo((Object)Sets.newHashSet((Object[])new String[]{"dc1", "dc2"}));
    }

    @Test(groups={"unit"})
    public void should_construct_json_event_status_message() throws IOException {
        InsightsClient insightsClient = new InsightsClient(this.mockCluster(), (Session)this.mockSessionManager(), MOCK_TIME_SUPPLIER, INSIGHTS_CONFIGURATION, null, null, null, null, null, EMPTY_STACK_TRACE);
        String statusMessage = insightsClient.createStatusMessage();
        InsightsSchema.Insight insight = (InsightsSchema.Insight)new ObjectMapper().readValue(statusMessage, (TypeReference)new TypeReference<InsightsSchema.Insight<InsightsSchema.InsightsStatusData>>(){});
        Assertions.assertThat((Object)insight.getMetadata()).isEqualTo((Object)new InsightsSchema.InsightsMetadata("driver.status", 1L, (Map)ImmutableMap.of((Object)"language", (Object)"java"), InsightsSchema.InsightType.EVENT, "v1"));
        InsightsSchema.InsightsStatusData insightData = (InsightsSchema.InsightsStatusData)insight.getInsightsData();
        Assertions.assertThat((String)insightData.getClientId()).isEqualTo((Object)"client-id");
        Assertions.assertThat((String)insightData.getSessionId()).isNotNull();
        Assertions.assertThat((String)insightData.getControlConnection()).isEqualTo((Object)"127.0.0.1:10");
        Assertions.assertThat((Map)insightData.getConnectedNodes()).isEqualTo((Object)ImmutableMap.of((Object)"127.0.0.1:10", (Object)new InsightsSchema.SessionStateForNode(Integer.valueOf(1), Integer.valueOf(10)), (Object)"127.0.0.1:20", (Object)new InsightsSchema.SessionStateForNode(Integer.valueOf(2), Integer.valueOf(20))));
    }

    @Test(groups={"unit"})
    public void should_schedule_task_with_initial_delay() {
        final AtomicInteger counter = new AtomicInteger();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                counter.incrementAndGet();
            }
        };
        InsightsClient.scheduleInsightsTask((long)100L, (ScheduledExecutorService)Executors.newScheduledThreadPool(1), (Runnable)runnable);
        ConditionChecker.check().before(1L, TimeUnit.SECONDS).that(new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return counter.get() >= 1;
            }
        }).becomesTrue();
    }

    @Test(groups={"unit"}, dataProvider="stack-trace-provider")
    public void should_get_caller_of_create_cluster(StackTraceElement[] stackTrace, String expected) {
        String result = InsightsClient.getClusterCreateCaller((StackTraceElement[])stackTrace);
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
    }

    @DataProvider(name="stack-trace-provider")
    public static Object[][] stackTraceProvider() {
        StackTraceElement[] onlyClusterCall = new StackTraceElement[]{new StackTraceElement("com.datastax.driver.core.Cluster", "connectAsync", "Cluster.java", 386)};
        StackTraceElement[] stackTraceElementsWithoutClusterCall = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.driver.core.InsightsClient", "getClusterCreateCaller", "InsightsClient.java", 302)};
        StackTraceElement[] stackTraceWithOneClusterCall = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.driver.core.InsightsClient", "getClusterCreateCaller", "InsightsClient.java", 302), new StackTraceElement("com.datastax.driver.core.Cluster", "connectAsync", "Cluster.java", 386)};
        StackTraceElement[] stackTraceWithOneClusterCallAndCaller = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.driver.core.InsightsClient", "getClusterCreateCaller", "InsightsClient.java", 302), new StackTraceElement("com.datastax.driver.core.Cluster", "connectAsync", "Cluster.java", 386), new StackTraceElement("com.example.ActualCallerNameApp", "main", "ActualCallerNameApp.java", 1)};
        StackTraceElement[] stackTraceWithTwoClusterCallAndCaller = new StackTraceElement[]{new StackTraceElement("java.lang.Thread", "getStackTrace", "Thread.java", 1559), new StackTraceElement("com.datastax.driver.core.InsightsClient", "getClusterCreateCaller", "InsightsClient.java", 302), new StackTraceElement("com.datastax.driver.core.Cluster", "connectAsync", "Cluster.java", 386), new StackTraceElement("com.datastax.driver.core.Cluster", "connect", "Cluster.java", 300), new StackTraceElement("com.example.ActualCallerNameApp", "main", "ActualCallerNameApp.java", 1)};
        StackTraceElement[] stackTraceWithThreeDifferentClusterCalls = new StackTraceElement[]{new StackTraceElement("com.datastax.driver.core.Cluster", "connectAsync", "Cluster.java", 386), new StackTraceElement("com.datastax.driver.core.DelegatingCluster", "connect", "DelegatingCluster.java", 1), new StackTraceElement("com.datastax.driver.dse.DseCluster", "connect", "DseCluster.java", 1)};
        StackTraceElement[] stackTraceWithThreeDifferentClusterCallsAndCaller = new StackTraceElement[]{new StackTraceElement("com.datastax.driver.core.Cluster", "connectAsync", "Cluster.java", 386), new StackTraceElement("com.datastax.driver.core.DelegatingCluster", "connect", "DelegatingCluster.java", 1), new StackTraceElement("com.datastax.driver.dse.DseCluster", "connect", "DseCluster.java", 1), new StackTraceElement("com.example.ActualCallerNameApp", "main", "ActualCallerNameApp.java", 1)};
        return new Object[][]{{new StackTraceElement[0], "Default Java Application"}, {stackTraceElementsWithoutClusterCall, "Default Java Application"}, {stackTraceWithOneClusterCall, "Default Java Application"}, {onlyClusterCall, "Default Java Application"}, {stackTraceWithOneClusterCallAndCaller, "com.example.ActualCallerNameApp"}, {stackTraceWithTwoClusterCallAndCaller, "com.example.ActualCallerNameApp"}, {stackTraceWithThreeDifferentClusterCalls, "Default Java Application"}, {stackTraceWithThreeDifferentClusterCallsAndCaller, "com.example.ActualCallerNameApp"}};
    }

    private SessionManager mockSessionManager() {
        SessionManager sessionManager = (SessionManager)Mockito.mock(SessionManager.class);
        final Host host1 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)host1.getSocketAddress()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 10));
        final Host host2 = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)host2.getSocketAddress()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 20));
        Mockito.when((Object)sessionManager.getState()).thenReturn((Object)new Session.State(){

            public Session getSession() {
                return null;
            }

            public Collection<Host> getConnectedHosts() {
                return Sets.newHashSet((Object[])new Host[]{host1, host2});
            }

            public int getOpenConnections(Host host) {
                if (host.equals((Object)host1)) {
                    return 1;
                }
                if (host.equals((Object)host2)) {
                    return 2;
                }
                return 0;
            }

            public int getTrashedConnections(Host host) {
                return 0;
            }

            public int getInFlightQueries(Host host) {
                if (host.equals((Object)host1)) {
                    return 10;
                }
                if (host.equals((Object)host2)) {
                    return 20;
                }
                return 0;
            }
        });
        return sessionManager;
    }

    private Cluster mockCluster() throws UnknownHostException {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Cluster.Manager manager = (Cluster.Manager)Mockito.mock(Cluster.Manager.class);
        Mockito.when((Object)cluster.getManager()).thenReturn((Object)manager);
        Mockito.when((Object)manager.loadBalancingPolicy()).thenReturn((Object)new RoundRobinPolicy());
        Mockito.when((Object)manager.reconnectionPolicy()).thenReturn((Object)new ConstantReconnectionPolicy(100L));
        Mockito.when((Object)manager.speculativeExecutionPolicy()).thenReturn((Object)new ConstantSpeculativeExecutionPolicy(10L, 2));
        HashMap<String, String> startupOptions = new HashMap<String, String>();
        startupOptions.put("CLIENT_ID", "client-id");
        startupOptions.put("APPLICATION_VERSION", "1.0.0");
        startupOptions.put("APPLICATION_NAME", "app-name");
        Mockito.when((Object)manager.getStartupOptions()).thenReturn(startupOptions);
        Mockito.when((Object)manager.protocolVersion()).thenReturn((Object)ProtocolVersion.DSE_V2);
        Mockito.when((Object)manager.getResolvedContactPoints()).thenReturn((Object)ImmutableMap.of((Object)"127.0.0.1", (Object)ImmutableList.of((Object)"127.0.0.1"), (Object)"name1", (Object)ImmutableList.of((Object)"10.10.10.1:9094", (Object)"10.10.10.1:9093")));
        Mockito.when((Object)manager.getContactPoints()).thenReturn(Arrays.asList(new InetSocketAddress(InetAddress.getLocalHost(), 9999)));
        SocketOptions socketOptions = new SocketOptions();
        socketOptions.setReadTimeoutMillis(1000);
        PoolingOptions poolingOptions = (PoolingOptions)Mockito.mock(PoolingOptions.class);
        Mockito.when((Object)poolingOptions.getCoreConnectionsPerHost((HostDistance)Matchers.eq((Object)HostDistance.LOCAL))).thenReturn((Object)1);
        Mockito.when((Object)poolingOptions.getCoreConnectionsPerHost((HostDistance)Matchers.eq((Object)HostDistance.REMOTE))).thenReturn((Object)2);
        Mockito.when((Object)poolingOptions.getCoreConnectionsPerHost((HostDistance)Matchers.eq((Object)HostDistance.IGNORED))).thenReturn((Object)3);
        Mockito.when((Object)poolingOptions.getHeartbeatIntervalSeconds()).thenReturn((Object)1);
        ProtocolOptions protocolOptions = (ProtocolOptions)Mockito.mock(ProtocolOptions.class);
        Mockito.when((Object)protocolOptions.getSSLOptions()).thenReturn(Mockito.mock(SSLOptions.class));
        Mockito.when((Object)protocolOptions.getAuthProvider()).thenReturn((Object)new DsePlainTextAuthProvider("u", "p"));
        Mockito.when((Object)protocolOptions.getCompression()).thenReturn((Object)ProtocolOptions.Compression.NONE);
        Configuration configuration = Configuration.builder().withSocketOptions(socketOptions).withQueryOptions(new QueryOptions()).withPoolingOptions(poolingOptions).withProtocolOptions(protocolOptions).build();
        Mockito.when((Object)cluster.getConfiguration()).thenReturn((Object)configuration);
        ControlConnection controlConnection = (ControlConnection)Mockito.mock(ControlConnection.class);
        Host host = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)host.getSocketAddress()).thenReturn((Object)new InetSocketAddress("127.0.0.1", 10));
        Mockito.when((Object)host.getAddress()).thenReturn((Object)InetAddress.getByName("127.0.0.1"));
        Mockito.when((Object)controlConnection.connectedHost()).thenReturn((Object)host);
        Mockito.when((Object)manager.getControlConnection()).thenReturn((Object)controlConnection);
        return cluster;
    }
}

