/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.ArrayBackedRow;
import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.IndexMetadataAssert;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

@CassandraVersion(value="1.2.0")
public class IndexMetadataTest
extends CCMTestsSupport {
    private static final ColumnDefinitions legacyColumnDefs = new ColumnDefinitions(new ColumnDefinitions.Definition[]{IndexMetadataTest.definition("column_name", DataType.text()), IndexMetadataTest.definition("component_index", DataType.cint()), IndexMetadataTest.definition("type", DataType.text()), IndexMetadataTest.definition("index_name", DataType.text()), IndexMetadataTest.definition("index_type", DataType.text()), IndexMetadataTest.definition("validator", DataType.text()), IndexMetadataTest.definition("index_options", DataType.text())}, CodecRegistry.DEFAULT_INSTANCE);
    private static final ColumnDefinitions indexColumnDefs = new ColumnDefinitions(new ColumnDefinitions.Definition[]{IndexMetadataTest.definition("index_name", DataType.text()), IndexMetadataTest.definition("kind", DataType.text()), IndexMetadataTest.definition("options", (DataType)DataType.map((DataType)DataType.text(), (DataType)DataType.text()))}, CodecRegistry.DEFAULT_INSTANCE);
    private static final TypeCodec<Map<String, String>> MAP_CODEC = TypeCodec.map((TypeCodec)TypeCodec.varchar(), (TypeCodec)TypeCodec.varchar());
    private ProtocolVersion protocolVersion;

    @Override
    public void onTestContextInitialized() {
        this.protocolVersion = this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion();
        String createTable = "CREATE TABLE indexing (id int,id2 int,map_values map<text, int>,map_keys map<text, int>,map_entries map<text, int>,map_all map<text, int>,text_column text, \"MixedCaseColumn\" list<text>," + (this.ccm().getCassandraVersion().compareTo(VersionNumber.parse((String)"2.1.3")) >= 0 ? ", map_full frozen<map<text, int>>,set_full frozen<set<text>>,list_full frozen<list<text>>," : "") + "PRIMARY KEY (id, id2));";
        this.execute(createTable);
    }

    @Test(groups={"short"})
    public void should_create_metadata_for_simple_index() {
        String createValuesIndex = String.format("CREATE INDEX text_column_index ON %s.indexing (text_column);", this.keyspace);
        this.session().execute(createValuesIndex);
        ColumnMetadata column = this.getColumn("text_column");
        IndexMetadata index = this.getIndex("text_column_index");
        Assertions.assertThat(index).hasName("text_column_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget("text_column").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createValuesIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1", description="index names with quoted identifiers and collection indexes not supported until 2.1")
    public void should_create_metadata_for_values_index_on_mixed_case_column() {
        String createValuesIndex = this.ccm().getCassandraVersion().getMajor() > 2 ? String.format("CREATE INDEX \"MixedCaseIndex\" ON %s.indexing (values(\"MixedCaseColumn\"));", this.keyspace) : String.format("CREATE INDEX \"MixedCaseIndex\" ON %s.indexing (\"MixedCaseColumn\");", this.keyspace);
        this.session().execute(createValuesIndex);
        ColumnMetadata column = this.getColumn("\"MixedCaseColumn\"");
        IndexMetadata index = this.getIndex("\"MixedCaseIndex\"");
        Assertions.assertThat(index).hasName("MixedCaseIndex").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget(this.ccm().getCassandraVersion().getMajor() > 2 ? "values(\"MixedCaseColumn\")" : "\"MixedCaseColumn\"").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createValuesIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_create_metadata_for_index_on_map_values() {
        String createValuesIndex = this.ccm().getCassandraVersion().getMajor() > 2 ? String.format("CREATE INDEX map_values_index ON %s.indexing (values(map_values));", this.keyspace) : String.format("CREATE INDEX map_values_index ON %s.indexing (map_values);", this.keyspace);
        this.session().execute(createValuesIndex);
        ColumnMetadata column = this.getColumn("map_values");
        IndexMetadata index = this.getIndex("map_values_index");
        Assertions.assertThat(index).hasName("map_values_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget(this.ccm().getCassandraVersion().getMajor() > 2 ? "values(map_values)" : "map_values").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createValuesIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.0")
    public void should_create_metadata_for_index_on_map_keys() {
        String createKeysIndex = String.format("CREATE INDEX map_keys_index ON %s.indexing (keys(map_keys));", this.keyspace);
        this.session().execute(createKeysIndex);
        ColumnMetadata column = this.getColumn("map_keys");
        IndexMetadata index = this.getIndex("map_keys_index");
        Assertions.assertThat(index).hasName("map_keys_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget("keys(map_keys)").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createKeysIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.3")
    public void should_create_metadata_for_full_index_on_map() {
        String createFullIndex = String.format("CREATE INDEX map_full_index ON %s.indexing (full(map_full));", this.keyspace);
        this.session().execute(createFullIndex);
        ColumnMetadata column = this.getColumn("map_full");
        IndexMetadata index = this.getIndex("map_full_index");
        Assertions.assertThat(index).hasName("map_full_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget("full(map_full)").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createFullIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.3")
    public void should_create_metadata_for_full_index_on_set() {
        String createFullIndex = String.format("CREATE INDEX set_full_index ON %s.indexing (full(set_full));", this.keyspace);
        this.session().execute(createFullIndex);
        ColumnMetadata column = this.getColumn("set_full");
        IndexMetadata index = this.getIndex("set_full_index");
        Assertions.assertThat(index).hasName("set_full_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget("full(set_full)").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createFullIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.1.3")
    public void should_create_metadata_for_full_index_on_list() {
        String createFullIndex = String.format("CREATE INDEX list_full_index ON %s.indexing (full(list_full));", this.keyspace);
        this.session().execute(createFullIndex);
        ColumnMetadata column = this.getColumn("list_full");
        IndexMetadata index = this.getIndex("list_full_index");
        Assertions.assertThat(index).hasName("list_full_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget("full(list_full)").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createFullIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.2.0")
    public void should_create_metadata_for_index_on_map_entries() {
        String createEntriesIndex = String.format("CREATE INDEX map_entries_index ON %s.indexing (entries(map_entries));", this.keyspace);
        this.session().execute(createEntriesIndex);
        ColumnMetadata column = this.getColumn("map_entries");
        IndexMetadata index = this.getIndex("map_entries_index");
        Assertions.assertThat(index).hasName("map_entries_index").hasParent((TableMetadata)column.getParent()).isNotCustomIndex().hasTarget("entries(map_entries)").hasKind(IndexMetadata.Kind.COMPOSITES).asCqlQuery(createEntriesIndex);
        Assertions.assertThat((TableMetadata)column.getParent()).hasIndex(index);
    }

    @Test(groups={"short"})
    @CassandraVersion(value="3.0")
    public void should_allow_multiple_indexes_on_map_column() {
        String createEntriesIndex = String.format("CREATE INDEX map_all_entries_index ON %s.indexing (entries(map_all));", this.keyspace);
        this.session().execute(createEntriesIndex);
        String createKeysIndex = String.format("CREATE INDEX map_all_keys_index ON %s.indexing (keys(map_all));", this.keyspace);
        this.session().execute(createKeysIndex);
        String createValuesIndex = String.format("CREATE INDEX map_all_values_index ON %s.indexing (values(map_all));", this.keyspace);
        this.session().execute(createValuesIndex);
        ColumnMetadata column = this.getColumn("map_all");
        TableMetadata table = (TableMetadata)column.getParent();
        Assertions.assertThat(this.getIndex("map_all_entries_index")).hasParent(table).asCqlQuery(createEntriesIndex);
        Assertions.assertThat(this.getIndex("map_all_keys_index")).hasParent(table).asCqlQuery(createKeysIndex);
        Assertions.assertThat(this.getIndex("map_all_values_index")).hasParent(table).asCqlQuery(createValuesIndex);
    }

    @Test(groups={"short"}, description="This test case builds a ColumnMetadata object programmatically to test custom indices with pre-3.0 layout,otherwise, it would require deploying an actual custom index class into the C* test cluster")
    public void should_parse_legacy_custom_index_options() {
        TableMetadata table = this.getTable("indexing");
        ImmutableList columnData = ImmutableList.of((Object)IndexMetadataTest.wrap("text_column"), (Object)IndexMetadataTest.wrap(0), (Object)IndexMetadataTest.wrap("regular"), (Object)IndexMetadataTest.wrap("custom_index"), (Object)IndexMetadataTest.wrap("CUSTOM"), (Object)IndexMetadataTest.wrap("org.apache.cassandra.db.marshal.UTF8Type"), (Object)IndexMetadataTest.wrap("{\"foo\" : \"bar\", \"class_name\" : \"dummy.DummyIndex\"}"));
        Row columnRow = ArrayBackedRow.fromData((ColumnDefinitions)legacyColumnDefs, (Token.Factory)Token.M3PToken.FACTORY, (ProtocolVersion)this.protocolVersion, (List)columnData);
        ColumnMetadata.Raw columnRaw = ColumnMetadata.Raw.fromRow((Row)columnRow, (VersionNumber)VersionNumber.parse((String)"2.1"));
        ColumnMetadata column = ColumnMetadata.fromRaw((AbstractTableMetadata)table, (ColumnMetadata.Raw)columnRaw, (DataType)DataType.varchar());
        IndexMetadata index = IndexMetadata.fromLegacy((ColumnMetadata)column, (ColumnMetadata.Raw)columnRaw);
        ((IndexMetadataAssert)Assertions.assertThat(index).isNotNull()).hasName("custom_index").isCustomIndex().hasOption("foo", "bar").hasKind(IndexMetadata.Kind.CUSTOM).asCqlQuery(String.format("CREATE CUSTOM INDEX custom_index ON %s.indexing (text_column) USING 'dummy.DummyIndex' WITH OPTIONS = {'foo' : 'bar'};", this.keyspace));
    }

    @Test(groups={"short"}, description="This test case builds a ColumnMetadata object programmatically to test custom indices with post-3.0 layout,otherwise, it would require deploying an actual custom index class into the C* test cluster")
    public void should_parse_custom_index_options() {
        TableMetadata table = this.getTable("indexing");
        ImmutableList indexData = ImmutableList.of((Object)IndexMetadataTest.wrap("custom_index"), (Object)IndexMetadataTest.wrap("CUSTOM"), (Object)MAP_CODEC.serialize((Object)ImmutableMap.of((Object)"foo", (Object)"bar", (Object)"class_name", (Object)"dummy.DummyIndex", (Object)"target", (Object)"a, b, keys(c)"), this.protocolVersion));
        Row indexRow = ArrayBackedRow.fromData((ColumnDefinitions)indexColumnDefs, (Token.Factory)Token.M3PToken.FACTORY, (ProtocolVersion)this.protocolVersion, (List)indexData);
        IndexMetadata index = IndexMetadata.fromRow((TableMetadata)table, (Row)indexRow);
        ((IndexMetadataAssert)Assertions.assertThat(index).isNotNull()).hasName("custom_index").isCustomIndex().hasOption("foo", "bar").hasTarget("a, b, keys(c)").hasKind(IndexMetadata.Kind.CUSTOM).asCqlQuery(String.format("CREATE CUSTOM INDEX custom_index ON %s.indexing (a, b, keys(c)) USING 'dummy.DummyIndex' WITH OPTIONS = {'foo' : 'bar'};", this.keyspace));
    }

    @Test(groups={"short"})
    public void should_parse_with_null_string_index_options() {
        TableMetadata table = this.getTable("indexing");
        ImmutableList data = ImmutableList.of((Object)IndexMetadataTest.wrap("b@706172656e745f70617468"), (Object)ByteBuffer.allocate(0), (Object)IndexMetadataTest.wrap("regular"), (Object)IndexMetadataTest.wrap("cfs_archive_parent_path"), (Object)IndexMetadataTest.wrap("KEYS"), (Object)IndexMetadataTest.wrap("org.apache.cassandra.db.marshal.BytesType"), (Object)IndexMetadataTest.wrap("null"));
        Row row = ArrayBackedRow.fromData((ColumnDefinitions)legacyColumnDefs, (Token.Factory)Token.M3PToken.FACTORY, (ProtocolVersion)this.cluster().getConfiguration().getProtocolOptions().getProtocolVersion(), (List)data);
        ColumnMetadata.Raw raw = ColumnMetadata.Raw.fromRow((Row)row, (VersionNumber)VersionNumber.parse((String)"2.1"));
        ColumnMetadata column = ColumnMetadata.fromRaw((AbstractTableMetadata)table, (ColumnMetadata.Raw)raw, (DataType)DataType.blob());
        IndexMetadata index = IndexMetadata.fromLegacy((ColumnMetadata)column, (ColumnMetadata.Raw)raw);
        ((IndexMetadataAssert)Assertions.assertThat(index).isNotNull()).hasName("cfs_archive_parent_path").isNotCustomIndex().hasTarget("\"b@706172656e745f70617468\"").hasKind(IndexMetadata.Kind.KEYS).asCqlQuery(String.format("CREATE INDEX cfs_archive_parent_path ON %s.indexing (\"b@706172656e745f70617468\");", this.keyspace));
        Assertions.assertThat((String)index.getOption("index_keys")).isNull();
    }

    private static ColumnDefinitions.Definition definition(String name, DataType type) {
        return new ColumnDefinitions.Definition("ks", "table", name, type);
    }

    private static ByteBuffer wrap(String value) {
        return ByteBuffer.wrap(value.getBytes());
    }

    private static ByteBuffer wrap(int number) {
        return ByteBuffer.wrap(Ints.toByteArray((int)number));
    }

    private ColumnMetadata getColumn(String name) {
        return this.getColumn(name, true);
    }

    private ColumnMetadata getColumn(String name, boolean fromTable) {
        TableMetadata target = fromTable ? this.getTable("indexing") : this.getMaterializedView("mv1");
        return target.getColumn(name);
    }

    private IndexMetadata getIndex(String name) {
        return this.getTable("indexing").getIndex(name);
    }

    private TableMetadata getTable(String name) {
        return this.cluster().getMetadata().getKeyspace(this.keyspace).getTable(name);
    }

    private MaterializedViewMetadata getMaterializedView(String name) {
        return this.cluster().getMetadata().getKeyspace(this.keyspace).getMaterializedView(name);
    }
}

