/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.UnavailableException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.HostFilterPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.base.Predicate;
import java.net.InetAddress;
import java.util.Map;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.scassandra.http.client.PrimingRequest;
import org.scassandra.http.client.Result;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HostTargetingTest {
    private ScassandraCluster sCluster;
    private Cluster cluster;
    private Session session;
    private LoadBalancingPolicy lbSpy = (LoadBalancingPolicy)Mockito.spy((Object)new HostFilterPolicy((LoadBalancingPolicy)DCAwareRoundRobinPolicy.builder().build(), (Predicate)new Predicate<Host>(){

        public boolean apply(Host host) {
            return !host.getAddress().getHostAddress().endsWith("4");
        }
    }));

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.sCluster = ScassandraCluster.builder().withNodes(4).build();
        this.sCluster.init();
        this.cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.sCluster.address(1).getAddress()}).withPort(this.sCluster.getBinaryPort()).withLoadBalancingPolicy(this.lbSpy).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        this.session = this.cluster.connect();
        Mockito.reset((Object[])new LoadBalancingPolicy[]{this.lbSpy});
    }

    @AfterMethod(groups={"short"})
    public void tearDown() {
        this.cluster.close();
        this.sCluster.stop();
    }

    private void verifyNoLbpInteractions() {
        ((LoadBalancingPolicy)Mockito.verify((Object)this.lbSpy, (VerificationMode)Mockito.times((int)0))).newQueryPlan((String)Mockito.any(String.class), (Statement)Mockito.any(Statement.class));
    }

    @Test(groups={"short"})
    public void should_use_host_on_statement() {
        for (int i = 0; i < 10; ++i) {
            int hostIndex = i % 3 + 1;
            Host host = TestUtils.findHost(this.cluster, hostIndex);
            Statement statement = new SimpleStatement("select * system.local").setHost(host);
            ResultSet result = this.session.execute(statement);
            Assertions.assertThat(result.getExecutionInfo().getQueriedHost()).isSameAs(host);
            this.verifyNoLbpInteractions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_fail_if_host_fails_query() {
        String query = "mock";
        this.sCluster.node(1).primingClient().prime(PrimingRequest.queryBuilder().withQuery(query).withThen(PrimingRequest.then().withResult(Result.unavailable)).build());
        Host host1 = TestUtils.findHost(this.cluster, 1);
        Statement statement = new SimpleStatement(query).setHost(host1);
        try {
            this.session.execute(statement);
            Assert.fail((String)"Query should have failed");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat((Map)e.getErrors()).hasSize(1);
            Assertions.assertThat((Throwable)((Throwable)e.getErrors().values().iterator().next())).isInstanceOf(UnavailableException.class);
        }
        finally {
            this.verifyNoLbpInteractions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_fail_if_host_is_not_connected() {
        Host host4 = TestUtils.findHost(this.cluster, 4);
        Statement statement = new SimpleStatement("select * system.local").setHost(host4);
        try {
            this.session.execute(statement);
            Assert.fail((String)"Query should have failed");
        }
        catch (NoHostAvailableException e) {
            Assertions.assertThat((Map)e.getErrors()).isEmpty();
        }
        finally {
            this.verifyNoLbpInteractions();
        }
    }
}

