/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.StateListenerBase;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractIterableAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class HostAssert
extends AbstractAssert<HostAssert, Host> {
    private final Cluster cluster;

    protected HostAssert(Host host) {
        this(host, null);
    }

    protected HostAssert(Host host, Cluster cluster) {
        super((Object)host, HostAssert.class);
        this.cluster = cluster;
    }

    public HostAssert hasState(Host.State expected) {
        Assertions.assertThat((Comparable)((Host)this.actual).state).isEqualTo((Object)expected);
        return this;
    }

    public HostAssert isUp() {
        Assertions.assertThat((boolean)((Host)this.actual).isUp()).isTrue();
        return this;
    }

    public HostAssert isDown() {
        Assertions.assertThat((boolean)((Host)this.actual).isUp()).isFalse();
        return this;
    }

    public HostAssert isAtDistance(HostDistance expected) {
        LoadBalancingPolicy loadBalancingPolicy = this.cluster.manager.loadBalancingPolicy();
        Assertions.assertThat((Comparable)loadBalancingPolicy.distance((Host)this.actual)).isEqualTo((Object)expected);
        return this;
    }

    public HostAssert isReconnectingFromDown() {
        Assertions.assertThat((((Host)this.actual).getReconnectionAttemptFuture() != null && !((Host)this.actual).getReconnectionAttemptFuture().isDone() ? 1 : 0) != 0).isTrue();
        return this;
    }

    public HostAssert isInDatacenter(String datacenter) {
        Assertions.assertThat((String)((Host)this.actual).getDatacenter()).isEqualTo((Object)datacenter);
        return this;
    }

    public HostAssert isNotReconnectingFromDown() {
        ConditionChecker.check().before(30L, TimeUnit.SECONDS).that(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((Host)HostAssert.this.actual).getReconnectionAttemptFuture() != null && !((Host)HostAssert.this.actual).getReconnectionAttemptFuture().isDone();
            }
        }).becomesFalse();
        return this.isDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAssert comesUpWithin(long duration, TimeUnit unit) {
        final CountDownLatch upSignal = new CountDownLatch(1);
        StateListenerBase upListener = new StateListenerBase(){

            @Override
            public void onUp(Host host) {
                upSignal.countDown();
            }

            @Override
            public void onAdd(Host host) {
                upSignal.countDown();
            }
        };
        this.cluster.register((Host.StateListener)upListener);
        try {
            if (((Host)this.actual).isUp() || upSignal.await(duration, unit)) {
                HostAssert hostAssert = this;
                return hostAssert;
            }
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Got interrupted while waiting for host to come up");
        }
        finally {
            this.cluster.unregister((Host.StateListener)upListener);
        }
        Assertions.fail((String)(this.actual + " did not come up within " + duration + " " + (Object)((Object)unit)));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HostAssert goesDownWithin(long duration, TimeUnit unit) {
        final CountDownLatch downSignal = new CountDownLatch(1);
        StateListenerBase upListener = new StateListenerBase(){

            @Override
            public void onDown(Host host) {
                downSignal.countDown();
            }
        };
        this.cluster.register((Host.StateListener)upListener);
        try {
            if (((Host)this.actual).state == Host.State.DOWN || downSignal.await(duration, unit)) {
                HostAssert hostAssert = this;
                return hostAssert;
            }
        }
        catch (InterruptedException e) {
            Assertions.fail((String)"Got interrupted while waiting for host to go down");
        }
        finally {
            this.cluster.unregister((Host.StateListener)upListener);
        }
        Assertions.fail((String)(this.actual + " did not go down within " + duration + " " + (Object)((Object)unit)));
        return this;
    }

    public HostAssert hasWorkload(String ... workloads) {
        ((AbstractIterableAssert)Assertions.assertThat((Iterable)((Host)this.actual).getDseWorkloads()).isNotNull()).containsAll(Arrays.asList(workloads));
        return this;
    }

    public HostAssert hasNoWorkload() {
        Assertions.assertThat((Iterable)((Host)this.actual).getDseWorkloads()).isEmpty();
        return this;
    }

    public HostAssert hasDseVersion(VersionNumber versionNumber) {
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)((Host)this.actual).getDseVersion()).isNotNull()).isEqualTo((Object)versionNumber);
        return this;
    }

    public HostAssert hasNoDseVersion() {
        Assertions.assertThat((Comparable)((Host)this.actual).getDseVersion()).isNull();
        return this;
    }

    public HostAssert hasDseGraph() {
        Assertions.assertThat((boolean)((Host)this.actual).isDseGraphEnabled()).isTrue();
        return this;
    }

    public HostAssert hasNoDseGraph() {
        Assertions.assertThat((boolean)((Host)this.actual).isDseGraphEnabled()).isFalse();
        return this;
    }

    public HostAssert hasSocketAddress(InetSocketAddress address) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)((Host)this.actual).getSocketAddress()).isNotNull()).isEqualTo((Object)address);
        return this;
    }

    public HostAssert hasListenAddress(InetAddress address) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)((Host)this.actual).getListenAddress()).isNotNull()).isEqualTo((Object)address);
        return this;
    }

    public HostAssert hasListenSocketAddress(InetSocketAddress address) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)((Host)this.actual).getListenSocketAddress()).isNotNull()).isEqualTo((Object)address);
        return this;
    }

    public HostAssert hasNoListenAddress() {
        Assertions.assertThat((Object)((Host)this.actual).getListenAddress()).isNull();
        return this;
    }

    public HostAssert hasNoListenSocketAddress() {
        Assertions.assertThat((Object)((Host)this.actual).getListenSocketAddress()).isNull();
        return this;
    }

    public HostAssert hasBroadcastAddress(InetAddress address) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)((Host)this.actual).getBroadcastAddress()).isNotNull()).isEqualTo((Object)address);
        return this;
    }

    public HostAssert hasBroadcastSocketAddress(InetSocketAddress address) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)((Host)this.actual).getBroadcastSocketAddress()).isNotNull()).isEqualTo((Object)address);
        return this;
    }

    public HostAssert hasNoBroadcastAddress() {
        Assertions.assertThat((Object)((Host)this.actual).getBroadcastAddress()).isNull();
        return this;
    }

    public HostAssert hasNoBroadcastSocketAddress() {
        Assertions.assertThat((Object)((Host)this.actual).getBroadcastSocketAddress()).isNull();
        return this;
    }

    public HostAssert hasHostId(UUID hostId) {
        Assertions.assertThat((Comparable)((Host)this.actual).getHostId()).isEqualTo((Object)hostId);
        return this;
    }

    public HostAssert hasSchemaVersion(UUID schemaVersion) {
        Assertions.assertThat((Comparable)((Host)this.actual).getSchemaVersion()).isEqualTo((Object)schemaVersion);
        return this;
    }

    public HostAssert hasServerId(String serverId) {
        Assertions.assertThat((String)((Host)this.actual).getDseServerId()).isEqualTo((Object)serverId);
        return this;
    }

    public HostAssert hasNativeTransportPort(int nativeTransportPort) {
        Assertions.assertThat((int)((Host)this.actual).getNativeTransportPort()).isEqualTo(nativeTransportPort);
        return this;
    }

    public HostAssert hasNativeTransportPortSsl(int nativeTransportPortSsl) {
        Assertions.assertThat((int)((Host)this.actual).getNativeTransportPortSsl()).isEqualTo(nativeTransportPortSsl);
        return this;
    }

    public HostAssert hasStoragePort(int storagePort) {
        Assertions.assertThat((int)((Host)this.actual).getStoragePort()).isEqualTo(storagePort);
        return this;
    }

    public HostAssert hasStoragePortSsl(int storagePortSsl) {
        Assertions.assertThat((int)((Host)this.actual).getStoragePortSsl()).isEqualTo(storagePortSsl);
        return this;
    }

    public HostAssert hasJmxPort(int jmxPort) {
        Assertions.assertThat((int)((Host)this.actual).getJmxPort()).isEqualTo(jmxPort);
        return this;
    }
}

