/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.FrameTooLongException;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@CCMConfig(numberOfNodes={2})
public class FrameLengthTest
extends CCMTestsSupport {
    Logger logger = LoggerFactory.getLogger(FrameLengthTest.class);
    private static final String tableName = "blob_table";
    private static final int colCount = 256;
    private static final int rowsPerPartitionCount = 4;
    private static final int partitionCount = 1;
    private static final int bytesPerCol = 1024;

    @Override
    @BeforeClass(groups={"isolated"})
    public void beforeTestClass() throws Exception {
        System.setProperty("com.datastax.driver.NATIVE_TRANSPORT_MAX_FRAME_SIZE_IN_MB", "1");
        super.beforeTestClass();
    }

    @Override
    public void onTestContextInitialized() {
        this.logger.info("Creating table {} with {} {}-byte blob columns", new Object[]{tableName, 256, 1024});
        Random random = new Random();
        Create create = SchemaBuilder.createTable((String)tableName).addPartitionKey("k", DataType.cint()).addClusteringColumn("c", DataType.cint());
        for (int i = 0; i < 256; ++i) {
            create.addColumn("col" + i, DataType.blob());
        }
        this.execute(create.getQueryString());
        Insert insert = QueryBuilder.insertInto((String)tableName).value("k", (Object)QueryBuilder.bindMarker()).value("c", (Object)QueryBuilder.bindMarker());
        for (int i = 0; i < 256; ++i) {
            insert = insert.value("col" + i, (Object)QueryBuilder.bindMarker());
        }
        PreparedStatement prepared = this.session().prepare((RegularStatement)insert);
        this.logger.info("Inserting data for {} partitions.", (Object)1);
        for (int i = 0; i < 1; ++i) {
            this.logger.info("Inserting {} rows in partition {}", (Object)4, (Object)i);
            for (int r = 0; r < 4; ++r) {
                BoundStatement stmt = prepared.bind();
                stmt.setInt("k", i);
                stmt.setInt("c", r);
                for (int c = 0; c < 256; ++c) {
                    byte[] b = new byte[1024];
                    random.nextBytes(b);
                    ByteBuffer in = ByteBuffer.wrap(b);
                    stmt.setBytes("col" + c, in);
                }
                this.session().execute((Statement)stmt);
            }
        }
        this.logger.info("Done loading {}", (Object)tableName);
    }

    @Test(groups={"isolated"})
    public void should_throw_exception_when_frame_exceeds_configured_max() {
        try {
            this.session().execute((Statement)QueryBuilder.select().from(tableName).where(QueryBuilder.eq((String)"k", (Object)0)));
            Fail.fail((String)"Exception expected");
        }
        catch (FrameTooLongException frameTooLongException) {
            // empty catch block
        }
        Collection hosts = this.session().getState().getConnectedHosts();
        Assertions.assertThat((Iterable)hosts).hasSize(2).extractingResultOf("isUp").containsOnly(new Object[]{true});
        for (int i = 0; i < 10; ++i) {
            ResultSet result = this.session().execute((Statement)QueryBuilder.select().from(tableName).where(QueryBuilder.eq((String)"k", (Object)0)).and(QueryBuilder.eq((String)"c", (Object)0)));
            Assertions.assertThat((int)result.getAvailableWithoutFetching()).isEqualTo(1);
        }
    }
}

