/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Duration;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class DurationCodecTest {
    @Test(groups={"unit"})
    public void testFromStringWithStandardPattern() {
        this.assertCodec("1y2mo", Duration.newInstance((int)14, (int)0, (long)0L));
        this.assertCodec("-1y2mo", Duration.newInstance((int)-14, (int)0, (long)0L));
        this.assertCodec("1Y2MO", Duration.newInstance((int)14, (int)0, (long)0L));
        this.assertCodec("2w", Duration.newInstance((int)0, (int)14, (long)0L));
        this.assertCodec("2d10h", Duration.newInstance((int)0, (int)2, (long)36000000000000L));
        this.assertCodec("2d", Duration.newInstance((int)0, (int)2, (long)0L));
        this.assertCodec("30h", Duration.newInstance((int)0, (int)0, (long)108000000000000L));
        this.assertCodec("30h20m", Duration.newInstance((int)0, (int)0, (long)109200000000000L));
        this.assertCodec("20m", Duration.newInstance((int)0, (int)0, (long)1200000000000L));
        this.assertCodec("56s", Duration.newInstance((int)0, (int)0, (long)56000000000L));
        this.assertCodec("567ms", Duration.newInstance((int)0, (int)0, (long)567000000L));
        this.assertCodec("1950us", Duration.newInstance((int)0, (int)0, (long)1950000L));
        this.assertCodec("1950\u00b5s", Duration.newInstance((int)0, (int)0, (long)1950000L));
        this.assertCodec("1950000ns", Duration.newInstance((int)0, (int)0, (long)1950000L));
        this.assertCodec("1950000NS", Duration.newInstance((int)0, (int)0, (long)1950000L));
        this.assertCodec("-1950000ns", Duration.newInstance((int)0, (int)0, (long)-1950000L));
        this.assertCodec("1y3mo2h10m", Duration.newInstance((int)15, (int)0, (long)7800000000000L));
    }

    @Test(groups={"unit"})
    public void testFromStringWithIso8601Pattern() {
        this.assertCodec("P1Y2D", Duration.newInstance((int)12, (int)2, (long)0L));
        this.assertCodec("P1Y2M", Duration.newInstance((int)14, (int)0, (long)0L));
        this.assertCodec("P2W", Duration.newInstance((int)0, (int)14, (long)0L));
        this.assertCodec("P1YT2H", Duration.newInstance((int)12, (int)0, (long)7200000000000L));
        this.assertCodec("-P1Y2M", Duration.newInstance((int)-14, (int)0, (long)0L));
        this.assertCodec("P2D", Duration.newInstance((int)0, (int)2, (long)0L));
        this.assertCodec("PT30H", Duration.newInstance((int)0, (int)0, (long)108000000000000L));
        this.assertCodec("PT30H20M", Duration.newInstance((int)0, (int)0, (long)109200000000000L));
        this.assertCodec("PT20M", Duration.newInstance((int)0, (int)0, (long)1200000000000L));
        this.assertCodec("PT56S", Duration.newInstance((int)0, (int)0, (long)56000000000L));
        this.assertCodec("P1Y3MT2H10M", Duration.newInstance((int)15, (int)0, (long)7800000000000L));
    }

    @Test(groups={"unit"})
    public void testFromStringWithIso8601AlternativePattern() {
        this.assertCodec("P0001-00-02T00:00:00", Duration.newInstance((int)12, (int)2, (long)0L));
        this.assertCodec("P0001-02-00T00:00:00", Duration.newInstance((int)14, (int)0, (long)0L));
        this.assertCodec("P0001-00-00T02:00:00", Duration.newInstance((int)12, (int)0, (long)7200000000000L));
        this.assertCodec("-P0001-02-00T00:00:00", Duration.newInstance((int)-14, (int)0, (long)0L));
        this.assertCodec("P0000-00-02T00:00:00", Duration.newInstance((int)0, (int)2, (long)0L));
        this.assertCodec("P0000-00-00T30:00:00", Duration.newInstance((int)0, (int)0, (long)108000000000000L));
        this.assertCodec("P0000-00-00T30:20:00", Duration.newInstance((int)0, (int)0, (long)109200000000000L));
        this.assertCodec("P0000-00-00T00:20:00", Duration.newInstance((int)0, (int)0, (long)1200000000000L));
        this.assertCodec("P0000-00-00T00:00:56", Duration.newInstance((int)0, (int)0, (long)56000000000L));
        this.assertCodec("P0001-03-00T02:10:00", Duration.newInstance((int)15, (int)0, (long)7800000000000L));
    }

    private void assertCodec(String input, Duration expected) {
        ByteBuffer bytes = TypeCodec.duration().serialize((Object)Duration.from((String)input), ProtocolVersion.V4);
        Duration actual = (Duration)TypeCodec.duration().deserialize(bytes, ProtocolVersion.V4);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        String format = TypeCodec.duration().format((Object)Duration.from((String)input));
        actual = (Duration)TypeCodec.duration().parse(format);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
        actual = (Duration)TypeCodec.duration().parse(input);
        Assertions.assertThat((Object)actual).isEqualTo((Object)expected);
    }
}

