/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.DataTypeCqlNameParser;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import java.util.Map;
import org.testng.annotations.Test;

@CassandraVersion(value="3.0")
public class DataTypeCqlNameParserTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void should_parse_native_types() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"ascii", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.ascii());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"bigint", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.bigint());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"blob", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.blob());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"boolean", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.cboolean());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"counter", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.counter());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"decimal", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.decimal());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"double", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.cdouble());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"float", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.cfloat());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"inet", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.inet());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"int", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.cint());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"text", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.text());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"varchar", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.varchar());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"timestamp", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.timestamp());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"date", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.date());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"time", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.time());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"uuid", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.uuid());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"varint", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.varint());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"timeuuid", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.timeuuid());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"tinyint", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.tinyint());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"smallint", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.smallint());
    }

    @Test(groups={"short"})
    public void should_ignore_whitespace() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"  int  ", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.cint());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"  set < bigint > ", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.set((DataType)DataType.bigint()));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"  map  <  date  ,  timeuuid  >  ", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.map((DataType)DataType.date(), (DataType)DataType.timeuuid()));
    }

    @Test(groups={"short"})
    public void should_ignore_case() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"INT", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.cint());
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"SET<BIGint>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.set((DataType)DataType.bigint()));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"FROZEN<mAp<Date,Tuple<timeUUID>>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.map((DataType)DataType.date(), (DataType)this.cluster().getMetadata().newTupleType(new DataType[]{DataType.timeuuid()}), (boolean)true));
    }

    @Test(groups={"short"})
    public void should_parse_collection_types() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"list<int>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.list((DataType)DataType.cint()));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"set<bigint>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.set((DataType)DataType.bigint()));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"map<date,timeuuid>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.map((DataType)DataType.date(), (DataType)DataType.timeuuid()));
    }

    @Test(groups={"short"})
    public void should_parse_frozen_collection_types() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"frozen<list<int>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.list((DataType)DataType.cint(), (boolean)true));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"frozen<set<bigint>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.set((DataType)DataType.bigint(), (boolean)true));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"frozen<map<date,timeuuid>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.map((DataType)DataType.date(), (DataType)DataType.timeuuid(), (boolean)true));
    }

    @Test(groups={"short"})
    public void should_parse_nested_collection_types() {
        Metadata metadata = this.cluster().getMetadata();
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace(this.keyspace);
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"list<list<int>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.list((DataType)DataType.list((DataType)DataType.cint())));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"set<list<frozen<map<bigint,varchar>>>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(DataType.set((DataType)DataType.list((DataType)DataType.map((DataType)DataType.bigint(), (DataType)DataType.varchar(), (boolean)true))));
        UserType keyType = keyspaceMetadata.getUserType(Metadata.quote((String)"Incr,edibly\" EvilTy<>><<><p\"e"));
        UserType valueType = keyspaceMetadata.getUserType(Metadata.quote((String)"A"));
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"map<frozen<\"Incr,edibly\"\" EvilTy<>><<><p\"\"e\">,frozen<\"A\">>", (Cluster)this.cluster(), (String)this.keyspace, (Map)keyspaceMetadata.userTypes, null, (boolean)false, (boolean)false)).isEqualTo(DataType.map((DataType)keyType, (DataType)valueType, (boolean)false));
    }

    @Test(groups={"short"})
    public void should_parse_tuple_types() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"tuple<int,list<text>>", (Cluster)this.cluster(), null, null, null, (boolean)false, (boolean)false)).isEqualTo(this.cluster().getMetadata().newTupleType(new DataType[]{DataType.cint(), DataType.list((DataType)DataType.text())}));
    }

    @Test(groups={"short"})
    public void should_parse_user_defined_type_when_definition_in_current_user_types() {
        Metadata metadata = this.cluster().getMetadata();
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace(this.keyspace);
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"frozen<\"A\">", (Cluster)this.cluster(), (String)this.keyspace, (Map)keyspaceMetadata.userTypes, null, (boolean)false, (boolean)false)).isUserType(this.keyspace, "A");
    }

    @Test(groups={"short"})
    public void should_parse_user_defined_type_when_definition_in_old_user_types() {
        Metadata metadata = this.cluster().getMetadata();
        KeyspaceMetadata keyspaceMetadata = metadata.getKeyspace(this.keyspace);
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"\"A\"", (Cluster)this.cluster(), (String)this.keyspace, null, (Map)keyspaceMetadata.userTypes, (boolean)false, (boolean)false)).isUserType(this.keyspace, "A");
    }

    @Test(groups={"short"})
    public void should_parse_user_defined_type_to_shallow_type_if_requested() {
        Assertions.assertThat(DataTypeCqlNameParser.parse((String)"\"A\"", (Cluster)this.cluster(), (String)this.keyspace, null, null, (boolean)false, (boolean)true)).isShallowUserType(this.keyspace, "A");
    }

    @Override
    public void onTestContextInitialized() {
        this.execute(String.format("CREATE TYPE %s.\"A\" (f1 int)", this.keyspace), String.format("CREATE TYPE %s.\"Incr,edibly\"\" EvilTy<>><<><p\"\"e\" (a frozen<\"A\">)", this.keyspace));
    }
}

