/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.UserType;
import java.util.List;
import org.assertj.core.api.AbstractAssert;

public class DataTypeAssert
extends AbstractAssert<DataTypeAssert, DataType> {
    public DataTypeAssert(DataType actual) {
        super((Object)actual, DataTypeAssert.class);
    }

    public DataTypeAssert hasName(DataType.Name name) {
        Assertions.assertThat((Comparable)((DataType)this.actual).name).isEqualTo((Object)name);
        return this;
    }

    public DataTypeAssert isUserType(String keyspaceName, String userTypeName) {
        Assertions.assertThat((DataType)this.actual).isInstanceOf(UserType.class);
        UserType userType = (UserType)this.actual;
        Assertions.assertThat((String)userType.getKeyspace()).isEqualTo((Object)keyspaceName);
        Assertions.assertThat((String)userType.getTypeName()).isEqualTo((Object)userTypeName);
        return this;
    }

    public DataTypeAssert isShallowUserType(String keyspaceName, String userTypeName) {
        Assertions.assertThat((DataType)this.actual).isInstanceOf(UserType.Shallow.class);
        UserType.Shallow shallow = (UserType.Shallow)this.actual;
        Assertions.assertThat((String)shallow.keyspaceName).isEqualTo((Object)keyspaceName);
        Assertions.assertThat((String)shallow.typeName).isEqualTo((Object)userTypeName);
        return this;
    }

    public DataTypeAssert isFrozen() {
        Assertions.assertThat((boolean)((DataType)this.actual).isFrozen()).isTrue();
        return this;
    }

    public DataTypeAssert isNotFrozen() {
        Assertions.assertThat((boolean)((DataType)this.actual).isFrozen()).isFalse();
        return this;
    }

    public DataTypeAssert hasTypeArgument(int position, DataType expected) {
        Assertions.assertThat((DataType)((DataType)this.actual).getTypeArguments().get(position)).isEqualTo(expected);
        return this;
    }

    public DataTypeAssert hasTypeArguments(DataType ... expected) {
        Assertions.assertThat((List)((DataType)this.actual).getTypeArguments()).containsExactly((Object[])expected);
        return this;
    }

    public DataTypeAssert hasField(String name, DataType expected) {
        Assertions.assertThat((DataType)this.actual).isInstanceOf(UserType.class);
        UserType userType = (UserType)this.actual;
        Assertions.assertThat(userType.getFieldType(name)).isEqualTo(expected);
        return this;
    }
}

