/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Iterator;
import org.testng.annotations.DataProvider;

public class DataProviders {
    @DataProvider(name="consistencyLevels")
    public static Iterator<Object[]> consistencyLevels() {
        final Iterator consistencyLevels = Iterables.filter(Arrays.asList(ConsistencyLevel.values()), (Predicate)new Predicate<ConsistencyLevel>(){

            public boolean apply(ConsistencyLevel input) {
                return !input.isSerial();
            }
        }).iterator();
        return new Iterator<Object[]>(){

            @Override
            public boolean hasNext() {
                return consistencyLevels.hasNext();
            }

            @Override
            public Object[] next() {
                return new Object[]{consistencyLevels.next()};
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("This shouldn't happen..");
            }
        };
    }

    @DataProvider(name="serialConsistencyLevels")
    public static Object[][] serialConsistencyLevels() {
        return new Object[][]{{ConsistencyLevel.SERIAL}, {ConsistencyLevel.LOCAL_SERIAL}};
    }

    @DataProvider(name="bool")
    public static Object[][] bool() {
        return new Object[][]{{true}, {false}};
    }
}

