/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.DataCentersFinder;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.Policies;
import com.google.common.collect.Sets;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DataCentersFinderTest {
    @Test(groups={"unit"}, dataProvider="hosts-provider")
    public void should_detect_data_centers(int numberOfRemoteHosts, String dc1, HostDistance h1Distance, String dc2, HostDistance h2Distance, Set<String> expected) {
        Cluster cluster = this.mockCluster(numberOfRemoteHosts, dc1, h1Distance, dc2, h2Distance);
        Set dataCenters = new DataCentersFinder().getDataCenters(cluster);
        Assertions.assertThat((Iterable)dataCenters).isEqualTo((Object)Sets.newHashSet(expected));
    }

    @Test(groups={"unit"}, dataProvider="local-dc-provider")
    public void should_find_local_data_center(int numberOfRemoteHosts, String dc1, HostDistance h1Distance, String dc2, HostDistance h2Distance, String expected) {
        Cluster cluster = this.mockCluster(numberOfRemoteHosts, dc1, h1Distance, dc2, h2Distance);
        String localDataCenter = new DataCentersFinder().getLocalDataCenter(cluster);
        Assertions.assertThat((String)localDataCenter).isEqualTo((Object)expected);
    }

    @DataProvider(name="local-dc-provider")
    public static Object[][] localDcProvider() {
        return new Object[][]{{0, "dc1", HostDistance.LOCAL, "dc2", HostDistance.REMOTE, "dc1"}, {0, "dc1", HostDistance.REMOTE, "dc2", HostDistance.LOCAL, "dc2"}, {0, "dc1", HostDistance.REMOTE, "dc2", HostDistance.REMOTE, null}};
    }

    @DataProvider(name="hosts-provider")
    public static Object[][] hostProvider() {
        return new Object[][]{{1, "dc1", HostDistance.LOCAL, "dc2", HostDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc1", "dc2"})}, {1, "dc1", HostDistance.LOCAL, "dc1", HostDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc1"})}, {0, "dc1", HostDistance.LOCAL, "dc2", HostDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc1"})}, {0, "dc1", HostDistance.IGNORED, "dc2", HostDistance.REMOTE, Sets.newHashSet()}, {1, "dc1", HostDistance.IGNORED, "dc2", HostDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc2"})}, {1, "dc1", HostDistance.LOCAL, "dc2", HostDistance.IGNORED, Sets.newHashSet((Object[])new String[]{"dc1"})}, {0, "dc1", HostDistance.IGNORED, "dc2", HostDistance.REMOTE, Sets.newHashSet()}, {0, "dc1", HostDistance.LOCAL, "dc2", HostDistance.IGNORED, Sets.newHashSet((Object[])new String[]{"dc1"})}};
    }

    private Cluster mockCluster(int numberOfRemoteHosts, String dc1, HostDistance h1Distance, String dc2, HostDistance h2Distance) {
        Cluster cluster = (Cluster)Mockito.mock(Cluster.class);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        PoolingOptions poolingOptions = (PoolingOptions)Mockito.mock(PoolingOptions.class);
        Mockito.when((Object)poolingOptions.getCoreConnectionsPerHost(HostDistance.REMOTE)).thenReturn((Object)numberOfRemoteHosts);
        LoadBalancingPolicy loadBalancingPolicy = (LoadBalancingPolicy)Mockito.mock(LoadBalancingPolicy.class);
        Configuration configuration = Configuration.builder().withPolicies(Policies.builder().withLoadBalancingPolicy(loadBalancingPolicy).build()).withPoolingOptions(poolingOptions).build();
        Mockito.when((Object)cluster.getConfiguration()).thenReturn((Object)configuration);
        Mockito.when((Object)cluster.getMetadata()).thenReturn((Object)metadata);
        Host localHost = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)localHost.getDatacenter()).thenReturn((Object)dc1);
        Host remoteHost = (Host)Mockito.mock(Host.class);
        Mockito.when((Object)remoteHost.getDatacenter()).thenReturn((Object)dc2);
        Mockito.when((Object)cluster.getMetadata().getAllHosts()).thenReturn((Object)Sets.newHashSet((Object[])new Host[]{localHost, remoteHost}));
        Mockito.when((Object)loadBalancingPolicy.distance(localHost)).thenReturn((Object)h1Distance);
        Mockito.when((Object)loadBalancingPolicy.distance(remoteHost)).thenReturn((Object)h2Distance);
        return cluster;
    }
}

