/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ContinuousPagingOptions;
import com.datastax.driver.core.ContinuousPagingResult;
import com.datastax.driver.core.ContinuousPagingSession;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.MultiResponseRequestHandler;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.QueryOptions;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.CCMDseTestsSupport;
import com.datastax.driver.dse.DseCluster;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@DseVersion(value="5.1.0")
@CCMConfig(numberOfNodes={2})
public class ContinuousPagingUnpreparedTest
extends CCMDseTestsSupport {
    public static final String KEY = "k";

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE test (k text, v int, PRIMARY KEY (k, v))");
        for (int i = 0; i < 100; ++i) {
            this.execute(String.format("INSERT INTO test (k, v) VALUES ('%s', %d)", KEY, i));
        }
    }

    @Override
    public DseCluster.Builder createClusterBuilder() {
        return super.createClusterBuilder().withQueryOptions(new QueryOptions().setPrepareOnAllHosts(false)).withLoadBalancingPolicy((LoadBalancingPolicy)new StatementTypeRoutingLoadBalancingPolicy());
    }

    private ContinuousPagingSession cSession() {
        return (ContinuousPagingSession)super.session();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"long"})
    public void should_reprepare_query_on_unprepared_response() {
        Logger logger = Logger.getLogger(MultiResponseRequestHandler.class);
        Level originalLevel = logger.getLevel();
        MemoryAppender logs = new MemoryAppender();
        try {
            logger.addAppender((Appender)logs);
            logger.setLevel(Level.INFO);
            PreparedStatement prepared = this.cSession().prepare("select * from test where k = ?");
            ContinuousPagingOptions options = ContinuousPagingOptions.builder().withPageSize(10, ContinuousPagingOptions.PageUnit.ROWS).build();
            ContinuousPagingResult result = this.cSession().executeContinuously((Statement)prepared.bind(new Object[]{KEY}), options);
            Assertions.assertThat((Iterable)result).hasSize(100);
            Assertions.assertThat((String)logs.get()).contains(new CharSequence[]{"Query select * from test where k = ? is not prepared"}).contains(new CharSequence[]{"preparing before retrying executing"});
        }
        finally {
            logger.removeAppender((Appender)logs);
            logger.setLevel(originalLevel);
        }
    }

    static class StatementTypeRoutingLoadBalancingPolicy
    implements LoadBalancingPolicy {
        private Host host0;
        private Host host1;

        StatementTypeRoutingLoadBalancingPolicy() {
        }

        public void init(Cluster cluster, Collection<Host> hosts) {
            Iterator<Host> it = hosts.iterator();
            this.host0 = it.next();
            this.host1 = it.next();
        }

        public HostDistance distance(Host host) {
            return HostDistance.LOCAL;
        }

        public Iterator<Host> newQueryPlan(String loggedKeyspace, Statement statement) {
            Host host = statement instanceof BoundStatement ? this.host1 : this.host0;
            return Lists.newArrayList((Object[])new Host[]{host}).iterator();
        }

        public void onAdd(Host host) {
        }

        public void onUp(Host host) {
        }

        public void onDown(Host host) {
        }

        public void onRemove(Host host) {
        }

        public void close() {
        }
    }
}

