/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.GuavaCompatibility;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.ScassandraTestBase;
import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.AsyncFunction;
import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.assertj.core.api.Assertions;
import org.scassandra.http.client.PrimingRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ConnectionReleaseTest
extends ScassandraTestBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_release_connection_before_completing_future() throws Exception {
        Cluster cluster = null;
        ArrayList mockFutures = Lists.newArrayList();
        try {
            this.primingClient.prime(PrimingRequest.queryBuilder().withQuery("mock query").withThen(PrimingRequest.then().withRows(new Map[]{ImmutableMap.of((Object)"key", (Object)1)}).withFixedDelay(Long.valueOf(10000L))).build());
            this.primingClient.prime(PrimingRequest.queryBuilder().withQuery("select c from test1 where k=1").withThen(PrimingRequest.then().withRows(new Map[]{ImmutableMap.of((Object)"c", (Object)"hello")})).build());
            this.primingClient.prime(PrimingRequest.queryBuilder().withQuery("select n from test2 where c='hello'").withThen(PrimingRequest.then().withRows(new Map[]{ImmutableMap.of((Object)"n", (Object)"world")})).build());
            cluster = Cluster.builder().addContactPoints(new InetAddress[]{this.hostAddress.getAddress()}).withPort(this.scassandra.getBinaryPort()).withPoolingOptions(new PoolingOptions().setCoreConnectionsPerHost(HostDistance.LOCAL, 1).setMaxConnectionsPerHost(HostDistance.LOCAL, 1)).build();
            final Session session = cluster.connect("ks");
            for (int i = 0; i < 127; ++i) {
                mockFutures.add(session.executeAsync("mock query"));
            }
            ListenableFuture future = GuavaCompatibility.INSTANCE.transformAsync((ListenableFuture)session.executeAsync("select c from test1 where k=1"), (AsyncFunction)new AsyncFunction<ResultSet, ResultSet>(){

                public ListenableFuture<ResultSet> apply(ResultSet result) {
                    Row row = result.one();
                    String c = row.getString("c");
                    return session.executeAsync("select n from test2 where c='" + c + "'");
                }
            });
            long waitTimeInMs = 2000L;
            try {
                ResultSet result = (ResultSet)future.get(waitTimeInMs, TimeUnit.MILLISECONDS);
                Assertions.assertThat((String)result.one().getString("n")).isEqualTo((Object)"world");
            }
            catch (TimeoutException e) {
                Assert.fail((String)("Future timed out after " + waitTimeInMs + "ms.  There is a strong possibility connection is not being released."));
            }
        }
        finally {
            for (ListenableFuture future : mockFutures) {
                future.cancel(true);
            }
            if (cluster != null) {
                cluster.close();
            }
        }
    }
}

