/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConfigAntiPatternsFinder;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.DelegatingLoadBalancingPolicy;
import com.datastax.driver.core.policies.DowngradingConsistencyRetryPolicy;
import com.datastax.driver.core.policies.FallthroughRetryPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.testng.annotations.Test;

public class ConfigAntiPatternsFinderTest {
    @Test(groups={"unit"})
    public void should_find_anti_patterns_for_DC_aware_policy() {
        DCAwareRoundRobinPolicy dc1 = DCAwareRoundRobinPolicy.builder().withLocalDc("dc1").allowRemoteDCsForLocalConsistencyLevel().build();
        Cluster cluster = Cluster.builder().addContactPoints(new String[]{"127.0.0.1"}).withLoadBalancingPolicy((LoadBalancingPolicy)dc1).build();
        Map antiPatterns = new ConfigAntiPatternsFinder().findAntiPatterns(cluster);
        Assertions.assertThat((Map)antiPatterns).isEqualTo((Object)ImmutableMap.of((Object)"useRemoteHosts", (Object)"Using remote hosts for failover"));
    }

    @Test(groups={"unit"})
    public void should_find_anti_patterns_retry_policy() {
        Cluster cluster = Cluster.builder().addContactPoints(new String[]{"127.0.0.1"}).withRetryPolicy((RetryPolicy)DowngradingConsistencyRetryPolicy.INSTANCE).build();
        Map antiPatterns = new ConfigAntiPatternsFinder().findAntiPatterns(cluster);
        Assertions.assertThat((Map)antiPatterns).isEqualTo((Object)ImmutableMap.of((Object)"downgradingConsistency", (Object)"Downgrading consistency retry policy in use"));
    }

    @Test(groups={"unit"})
    public void should_not_find_anti_patterns() {
        DCAwareRoundRobinPolicy dc1 = DCAwareRoundRobinPolicy.builder().withLocalDc("dc1").build();
        Cluster cluster = Cluster.builder().addContactPoints(new String[]{"127.0.0.1"}).withLoadBalancingPolicy((LoadBalancingPolicy)dc1).withRetryPolicy((RetryPolicy)FallthroughRetryPolicy.INSTANCE).build();
        Map antiPatterns = new ConfigAntiPatternsFinder().findAntiPatterns(cluster);
        Assertions.assertThat((Map)antiPatterns).isEqualTo(Collections.emptyMap());
    }

    @Test(groups={"unit"})
    public void should_find_contact_points_multiple_DCs_anti_patterns_for_DC_aware_policy() {
        DCAwareRoundRobinPolicy loadBalancingPolicy = (DCAwareRoundRobinPolicy)Mockito.mock(DCAwareRoundRobinPolicy.class);
        Mockito.when((Object)loadBalancingPolicy.isContactPointsMultipleDCs()).thenReturn((Object)true);
        HashMap antiPatterns = new HashMap();
        new ConfigAntiPatternsFinder().findLoadBalancingPolicyAntiPatterns(antiPatterns, (LoadBalancingPolicy)loadBalancingPolicy);
        Assertions.assertThat(antiPatterns).isEqualTo((Object)ImmutableMap.of((Object)"contactPointsMultipleDCs", (Object)"Contact points contain hosts from multiple data centers"));
    }

    @Test(groups={"unit"})
    public void should_find_contact_points_multiple_DCs_anti_patterns_for_wrapped_DC_aware_policy() {
        DCAwareRoundRobinPolicy loadBalancingPolicy = (DCAwareRoundRobinPolicy)Mockito.mock(DCAwareRoundRobinPolicy.class);
        Mockito.when((Object)loadBalancingPolicy.isContactPointsMultipleDCs()).thenReturn((Object)true);
        DCAwareWrappedPolicy chainableLoadBalancingPolicy = new DCAwareWrappedPolicy(loadBalancingPolicy);
        HashMap antiPatterns = new HashMap();
        new ConfigAntiPatternsFinder().findLoadBalancingPolicyAntiPatterns(antiPatterns, (LoadBalancingPolicy)chainableLoadBalancingPolicy);
        Assertions.assertThat(antiPatterns).isEqualTo((Object)ImmutableMap.of((Object)"contactPointsMultipleDCs", (Object)"Contact points contain hosts from multiple data centers"));
    }

    static class DCAwareWrappedPolicy
    extends DelegatingLoadBalancingPolicy {
        DCAwareWrappedPolicy(DCAwareRoundRobinPolicy dcAwareRoundRobinPolicy) {
            super((LoadBalancingPolicy)dcAwareRoundRobinPolicy);
        }
    }
}

