/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostAssert;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.TokenRange;
import com.google.common.collect.Iterators;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractBooleanAssert;

public class ClusterAssert
extends AbstractAssert<ClusterAssert, Cluster> {
    protected ClusterAssert(Cluster actual) {
        super((Object)actual, ClusterAssert.class);
    }

    public ClusterAssert usesControlHost(int node) {
        String expectedAddress = TestUtils.ipOfNode(node);
        Host controlHost = ((Cluster)this.actual).manager.controlConnection.connectedHost();
        org.assertj.core.api.Assertions.assertThat((String)controlHost.getAddress().getHostAddress()).isEqualTo((Object)expectedAddress);
        return this;
    }

    public ClusterAssert hasClosedControlConnection() {
        org.assertj.core.api.Assertions.assertThat((boolean)((Cluster)this.actual).manager.controlConnection.isOpen()).isFalse();
        return this;
    }

    public ClusterAssert hasOpenControlConnection() {
        org.assertj.core.api.Assertions.assertThat((boolean)((Cluster)this.actual).manager.controlConnection.isOpen()).isTrue();
        return this;
    }

    public HostAssert controlHost() {
        Host host = TestUtils.findOrWaitForControlConnection((Cluster)this.actual, 10L, TimeUnit.SECONDS);
        return new HostAssert(host, (Cluster)this.actual);
    }

    public HostAssert host(int hostNumber) {
        Host host = TestUtils.findOrWaitForHost((Cluster)this.actual, hostNumber, (long)(60 + Cluster.NEW_NODE_DELAY_SECONDS), TimeUnit.SECONDS);
        return new HostAssert(host, (Cluster)this.actual);
    }

    public HostAssert host(String hostAddress) {
        Host host = TestUtils.findOrWaitForHost((Cluster)this.actual, hostAddress, (long)(60 + Cluster.NEW_NODE_DELAY_SECONDS), TimeUnit.SECONDS);
        return new HostAssert(host, (Cluster)this.actual);
    }

    public HostAssert host(InetAddress hostAddress) {
        return this.host(hostAddress.getHostAddress());
    }

    public ClusterAssert hasValidTokenRanges(String keyspace) {
        TreeSet<TokenRange> ranges = new TreeSet<TokenRange>();
        for (Host host : ((Cluster)this.actual).getMetadata().getAllHosts()) {
            ranges.addAll(((Cluster)this.actual).getMetadata().getTokenRanges(keyspace, host));
        }
        return this.hasValidTokenRanges(ranges);
    }

    public ClusterAssert hasValidTokenRanges() {
        TreeSet<TokenRange> ranges = new TreeSet<TokenRange>(((Cluster)this.actual).getMetadata().getTokenRanges());
        return this.hasValidTokenRanges(ranges);
    }

    private ClusterAssert hasValidTokenRanges(Set<TokenRange> ranges) {
        Iterator<TokenRange> it = ranges.iterator();
        while (it.hasNext()) {
            TokenRange range = it.next();
            Assertions.assertThat(range).doesNotIntersect((TokenRange[])Iterators.toArray(it, TokenRange.class));
        }
        it = ranges.iterator();
        TokenRange mergedRange = it.next();
        while (it.hasNext()) {
            TokenRange next = it.next();
            mergedRange = mergedRange.mergeWith(next);
        }
        boolean isFullRing = mergedRange.getStart().equals(mergedRange.getEnd()) && !mergedRange.isEmpty();
        ((AbstractBooleanAssert)org.assertj.core.api.Assertions.assertThat((boolean)isFullRing).as("Ring is not fully defined for Cluster.", new Object[0])).isTrue();
        return this;
    }
}

