/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import org.testng.Assert;
import org.testng.annotations.Test;

@CCMConfig(clusterProvider="createClusterBuilderNoDebouncing")
public class CaseSensitivityTest
extends CCMTestsSupport {
    @Test(groups={"short"})
    public void testCaseInsensitiveKeyspace() throws Throwable {
        String ksName = "MyKeyspace1";
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", ksName, 1));
        this.assertExists(ksName, "mykeyspace1");
        this.assertExists("mykeyspace1", "mykeyspace1");
        this.assertExists("MYKEYSPACE1", "mykeyspace1");
    }

    @Test(groups={"short"})
    public void testCaseSensitiveKeyspace() throws Throwable {
        String ksName = "\"MyKeyspace2\"";
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", ksName, 1));
        this.assertExists(ksName, "MyKeyspace2");
        this.assertExists(Metadata.quote((String)"MyKeyspace2"), "MyKeyspace2");
        this.assertNotExists("mykeyspace2");
        this.assertNotExists("MyKeyspace2");
        this.assertNotExists("MYKEYSPACE2");
    }

    private void assertExists(String fetchName, String realName) {
        KeyspaceMetadata km = this.cluster().getMetadata().getKeyspace(fetchName);
        Assert.assertNotNull((Object)km);
        Assert.assertEquals((String)realName, (String)km.getName());
    }

    private void assertNotExists(String name) {
        Assert.assertNull((Object)this.cluster().getMetadata().getKeyspace(name));
    }
}

