/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMAccess;
import com.datastax.driver.core.CCMException;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ExecuteWatchdog;
import org.apache.commons.exec.LogOutputStream;
import org.apache.commons.exec.PumpStreamHandler;
import org.assertj.core.util.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CCMBridge
implements CCMAccess {
    private static final Logger logger = LoggerFactory.getLogger(CCMBridge.class);
    private static final VersionNumber GLOBAL_CASSANDRA_VERSION_NUMBER;
    private static final VersionNumber GLOBAL_DSE_VERSION_NUMBER;
    private static final Set<String> CASSANDRA_INSTALL_ARGS;
    public static final String DEFAULT_CLIENT_TRUSTSTORE_PASSWORD = "cassandra1sfun";
    public static final String DEFAULT_CLIENT_TRUSTSTORE_PATH = "/client.truststore";
    public static final File DEFAULT_CLIENT_TRUSTSTORE_FILE;
    public static final String DEFAULT_CLIENT_KEYSTORE_PASSWORD = "cassandra1sfun";
    public static final String DEFAULT_CLIENT_KEYSTORE_PATH = "/client.keystore";
    public static final File DEFAULT_CLIENT_KEYSTORE_FILE;
    public static final File DEFAULT_CLIENT_PRIVATE_KEY_FILE;
    public static final File DEFAULT_CLIENT_CERT_CHAIN_FILE;
    public static final String DEFAULT_SERVER_TRUSTSTORE_PASSWORD = "cassandra1sfun";
    public static final String DEFAULT_SERVER_TRUSTSTORE_PATH = "/server.truststore";
    private static final File DEFAULT_SERVER_TRUSTSTORE_FILE;
    public static final String DEFAULT_SERVER_KEYSTORE_PASSWORD = "cassandra1sfun";
    public static final String DEFAULT_SERVER_KEYSTORE_PATH = "/server.keystore";
    private static final File DEFAULT_SERVER_KEYSTORE_FILE;
    private static final Map<String, String> ENVIRONMENT_MAP;
    private static final Map<String, String> dseToCassandraVersions;
    private static final String CCM_COMMAND;
    private final String clusterName;
    private final VersionNumber cassandraVersion;
    private final VersionNumber dseVersion;
    private final int storagePort;
    private final int thriftPort;
    private final int binaryPort;
    private final String ipPrefix;
    private final File ccmDir;
    private final boolean isDSE;
    private final String jvmArgs;
    private boolean keepLogs = false;
    private boolean started = false;
    private boolean closed = false;
    private final int[] nodes;
    private final int[] jmxPorts;

    public static VersionNumber getGlobalCassandraVersion() {
        return GLOBAL_CASSANDRA_VERSION_NUMBER;
    }

    public static VersionNumber getGlobalDSEVersion() {
        return GLOBAL_DSE_VERSION_NUMBER;
    }

    public static VersionNumber getCassandraVersion(VersionNumber dseVersion) {
        String cassandraVersion = dseToCassandraVersions.get(dseVersion.toString());
        if (cassandraVersion != null) {
            return VersionNumber.parse((String)cassandraVersion);
        }
        if (dseVersion.getMajor() <= 3) {
            return VersionNumber.parse((String)"1.2");
        }
        if (dseVersion.getMajor() == 4) {
            if (dseVersion.getMinor() >= 7) {
                return VersionNumber.parse((String)"2.1");
            }
            return VersionNumber.parse((String)"2.0");
        }
        if (dseVersion.getMajor() == 5) {
            if (dseVersion.getMinor() == 0) {
                return VersionNumber.parse((String)"3.0");
            }
            return VersionNumber.parse((String)"3.11");
        }
        return VersionNumber.parse((String)"4.0");
    }

    public static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.startsWith("Windows");
    }

    protected CCMBridge(String clusterName, VersionNumber cassandraVersion, VersionNumber dseVersion, String ipPrefix, int storagePort, int thriftPort, int binaryPort, int[] jmxPorts, String jvmArgs, int[] nodes) {
        this.clusterName = clusterName;
        this.cassandraVersion = cassandraVersion;
        this.dseVersion = dseVersion;
        this.ipPrefix = ipPrefix;
        this.storagePort = storagePort;
        this.thriftPort = thriftPort;
        this.binaryPort = binaryPort;
        this.isDSE = dseVersion != null;
        this.jvmArgs = jvmArgs;
        this.nodes = nodes;
        this.ccmDir = com.google.common.io.Files.createTempDir();
        this.jmxPorts = jmxPorts;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public String getClusterName() {
        return this.clusterName;
    }

    @Override
    public int[] getNodeCount() {
        return Arrays.copyOf(this.nodes, this.nodes.length);
    }

    protected String ipOfNode(int n) {
        return this.ipPrefix + n;
    }

    @Override
    public InetSocketAddress addressOfNode(int n) {
        return new InetSocketAddress(this.ipOfNode(n), this.binaryPort);
    }

    @Override
    public InetSocketAddress jmxAddressOfNode(int n) {
        return new InetSocketAddress("localhost", this.jmxPorts[n - 1]);
    }

    @Override
    public VersionNumber getCassandraVersion() {
        return this.cassandraVersion;
    }

    @Override
    public VersionNumber getDSEVersion() {
        return this.dseVersion;
    }

    @Override
    public File getCcmDir() {
        return this.ccmDir;
    }

    @Override
    public File getClusterDir() {
        return new File(this.ccmDir, this.clusterName);
    }

    @Override
    public File getNodeDir(int n) {
        return new File(this.getClusterDir(), "node" + n);
    }

    @Override
    public File getNodeConfDir(int n) {
        return new File(this.getNodeDir(n), "conf");
    }

    @Override
    public int getStoragePort() {
        return this.storagePort;
    }

    @Override
    public int getThriftPort() {
        return this.thriftPort;
    }

    @Override
    public int getBinaryPort() {
        return this.binaryPort;
    }

    @Override
    public void setKeepLogs(boolean keepLogs) {
        this.keepLogs = keepLogs;
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        logger.debug("Closing: {}", (Object)this);
        if (this.keepLogs) {
            TestUtils.executeNoFail(new Runnable(){

                @Override
                public void run() {
                    CCMBridge.this.stop();
                }
            }, false);
            logger.info("Error during tests, kept C* logs in " + this.getCcmDir());
        } else {
            TestUtils.executeNoFail(new Runnable(){

                @Override
                public void run() {
                    CCMBridge.this.remove();
                }
            }, false);
            TestUtils.executeNoFail(new Runnable(){

                @Override
                public void run() {
                    Files.delete((File)CCMBridge.this.getCcmDir());
                }
            }, false);
        }
        this.closed = true;
        logger.debug("Closed: {}", (Object)this);
    }

    private String getStartWaitArguments() {
        if (this.cassandraVersion.getMajor() == 1) {
            return " --wait-other-notice";
        }
        return "";
    }

    @Override
    public synchronized void start() {
        if (this.started) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Starting: {} - free memory: {} MB", (Object)this, (Object)TestUtils.getFreeMemoryMB());
        }
        try {
            String cmd = CCM_COMMAND + " start " + this.jvmArgs + this.getStartWaitArguments();
            if (CCMBridge.isWindows() && this.cassandraVersion.compareTo(VersionNumber.parse((String)"2.2.4")) >= 0) {
                cmd = cmd + " --quiet-windows";
            }
            logger.debug("cmd to start: {}", (Object)cmd);
            this.execute(cmd, new Object[0]);
            int n = 1;
            for (int dc = 1; dc <= this.nodes.length; ++dc) {
                int nodesInDc = this.nodes[dc - 1];
                for (int i = 0; i < nodesInDc; ++i) {
                    InetSocketAddress addr = this.addressOfNode(n);
                    logger.debug("Waiting for binary protocol to show up for {}", (Object)addr);
                    TestUtils.waitUntilPortIsUp(addr);
                    ++n;
                }
            }
        }
        catch (CCMException e) {
            logger.error("Could not start " + this, (Throwable)e);
            logger.error("CCM output:\n{}", (Object)e.getOut());
            this.setKeepLogs(true);
            String errors = this.checkForErrors();
            if (errors != null) {
                logger.error("CCM check errors:\n{}", (Object)errors);
            }
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Started: {} - Free memory: {} MB", (Object)this, (Object)TestUtils.getFreeMemoryMB());
        }
        this.started = true;
        logger.debug("ccmDirectory: {}", (Object)this.ccmDir.getAbsolutePath());
    }

    @Override
    public synchronized void stop() {
        if (this.closed) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping: {} - free memory: {} MB", (Object)this, (Object)TestUtils.getFreeMemoryMB());
        }
        this.execute(CCM_COMMAND + " stop", new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("Stopped: {} - free memory: {} MB", (Object)this, (Object)TestUtils.getFreeMemoryMB());
        }
        this.closed = true;
    }

    @Override
    public synchronized void forceStop() {
        if (this.closed) {
            return;
        }
        logger.debug("Force stopping: {}", (Object)this);
        this.execute(CCM_COMMAND + " stop --not-gently", new Object[0]);
        this.closed = true;
    }

    @Override
    public synchronized void remove() {
        this.stop();
        logger.debug("Removing: {}", (Object)this);
        this.execute(CCM_COMMAND + " remove", new Object[0]);
    }

    @Override
    public String checkForErrors() {
        logger.debug("Checking for errors in: {}", (Object)this);
        try {
            return this.execute(CCM_COMMAND + " checklogerror", new Object[0]);
        }
        catch (CCMException e) {
            logger.warn("Check for errors failed");
            return null;
        }
    }

    @Override
    public void start(int n) {
        logger.debug(String.format("Starting: node %s (%s%s:%s) in %s", n, this.ipPrefix, n, this.binaryPort, this));
        try {
            String cmd = CCM_COMMAND + " node%d start " + this.jvmArgs + this.getStartWaitArguments();
            if (CCMBridge.isWindows() && this.cassandraVersion.compareTo(VersionNumber.parse((String)"2.2.4")) >= 0) {
                cmd = cmd + " --quiet-windows";
            }
            this.execute(cmd, n);
            InetSocketAddress addr = new InetSocketAddress(this.ipOfNode(n), this.binaryPort);
            logger.debug("Waiting for binary protocol to show up for {}", (Object)addr);
            TestUtils.waitUntilPortIsUp(addr);
        }
        catch (CCMException e) {
            logger.error(String.format("Could not start node %s in %s", n, this), (Throwable)e);
            logger.error("CCM output:\n{}", (Object)e.getOut());
            this.setKeepLogs(true);
            String errors = this.checkForErrors();
            if (errors != null) {
                logger.error("CCM check errors:\n{}", (Object)errors);
            }
            throw e;
        }
    }

    @Override
    public void stop(int n) {
        logger.debug(String.format("Stopping: node %s (%s%s:%s) in %s", n, this.ipPrefix, n, this.binaryPort, this));
        this.execute(CCM_COMMAND + " node%d stop", n);
    }

    @Override
    public void forceStop(int n) {
        logger.debug(String.format("Force stopping: node %s (%s%s:%s) in %s", n, this.ipPrefix, n, this.binaryPort, this));
        this.execute(CCM_COMMAND + " node%d stop --not-gently", n);
    }

    @Override
    public void pause(int n) {
        logger.debug(String.format("Pausing: node %s (%s%s:%s) in %s", n, this.ipPrefix, n, this.binaryPort, this));
        this.execute(CCM_COMMAND + " node%d pause", n);
    }

    @Override
    public void resume(int n) {
        logger.debug(String.format("Resuming: node %s (%s%s:%s) in %s", n, this.ipPrefix, n, this.binaryPort, this));
        this.execute(CCM_COMMAND + " node%d resume", n);
    }

    @Override
    public void remove(int n) {
        logger.debug(String.format("Removing: node %s (%s%s:%s) from %s", n, this.ipPrefix, n, this.binaryPort, this));
        this.execute(CCM_COMMAND + " node%d remove", n);
    }

    @Override
    public void add(int n) {
        this.add(1, n);
    }

    @Override
    public void add(int dc, int n) {
        logger.debug(String.format("Adding: node %s (%s%s:%s) to %s", n, this.ipPrefix, n, this.binaryPort, this));
        String thriftItf = this.ipOfNode(n) + ":" + this.thriftPort;
        String storageItf = this.ipOfNode(n) + ":" + this.storagePort;
        String binaryItf = this.ipOfNode(n) + ":" + this.binaryPort;
        String remoteLogItf = this.ipOfNode(n) + ":" + TestUtils.findAvailablePort();
        this.execute(CCM_COMMAND + " add node%d -d dc%s -i %s%d -t %s -l %s --binary-itf %s -j %d -r %s -s -b" + (this.isDSE ? " --dse" : ""), n, dc, this.ipPrefix, n, thriftItf, storageItf, binaryItf, TestUtils.findAvailablePort(), remoteLogItf);
    }

    @Override
    public void decommission(int n) {
        logger.debug(String.format("Decommissioning: node %s (%s%s:%s) from %s", n, this.ipPrefix, n, this.binaryPort, this));
        String cmd = CCM_COMMAND + " node%d decommission";
        if (this.cassandraVersion.compareTo(VersionNumber.parse((String)"3.12")) >= 0 || this.dseVersion != null && this.dseVersion.compareTo(VersionNumber.parse((String)"5.1.0")) >= 0) {
            cmd = cmd + " --force";
        }
        this.execute(cmd, n);
    }

    @Override
    public void updateConfig(Map<String, Object> configs) {
        StringBuilder confStr = new StringBuilder();
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            confStr.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        this.execute(CCM_COMMAND + " updateconf " + confStr, new Object[0]);
    }

    @Override
    public void updateDSEConfig(Map<String, Object> configs) {
        StringBuilder confStr = new StringBuilder();
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            confStr.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        this.execute(CCM_COMMAND + " updatedseconf " + confStr, new Object[0]);
    }

    public void updateDSEConfig(String yaml) {
        this.executeUnsanitized("updatedseconf", "-y", yaml);
    }

    @Override
    public void updateNodeConfig(int n, String key, Object value) {
        this.updateNodeConfig(n, (Map<String, Object>)ImmutableMap.builder().put((Object)key, value).build());
    }

    @Override
    public void updateNodeConfig(int n, Map<String, Object> configs) {
        StringBuilder confStr = new StringBuilder();
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            confStr.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        this.execute(CCM_COMMAND + " node%s updateconf %s", n, confStr);
    }

    @Override
    public void updateDSENodeConfig(int n, String key, Object value) {
        this.updateDSENodeConfig(n, (Map<String, Object>)ImmutableMap.builder().put((Object)key, value).build());
    }

    @Override
    public void updateDSENodeConfig(int n, Map<String, Object> configs) {
        StringBuilder confStr = new StringBuilder();
        for (Map.Entry<String, Object> entry : configs.entrySet()) {
            confStr.append(entry.getKey()).append(":").append(entry.getValue()).append(" ");
        }
        this.execute(CCM_COMMAND + " node%s updatedseconf %s", n, confStr);
    }

    @Override
    public void setWorkload(int node, String ... workload) {
        String workloadStr = Joiner.on((String)",").join((Object[])workload);
        this.execute(CCM_COMMAND + " node%d setworkload %s", node, workloadStr);
    }

    private String executeCommand(CommandLine cli) {
        logger.trace("Executing: {}", (Object)cli);
        Closer closer = Closer.create();
        ExecuteWatchdog watchDog = new ExecuteWatchdog(TimeUnit.MINUTES.toMillis(10L));
        StringWriter sw = new StringWriter();
        final PrintWriter pw = new PrintWriter(sw);
        closer.register((Closeable)pw);
        try {
            DefaultExecutor executor = new DefaultExecutor();
            LogOutputStream outStream = new LogOutputStream(){

                protected void processLine(String line, int logLevel) {
                    String out = "ccmout> " + line;
                    logger.debug(out);
                    pw.println(out);
                }
            };
            LogOutputStream errStream = new LogOutputStream(){

                protected void processLine(String line, int logLevel) {
                    String err = "ccmerr> " + line;
                    logger.error(err);
                    pw.println(err);
                }
            };
            closer.register((Closeable)outStream);
            closer.register((Closeable)errStream);
            PumpStreamHandler streamHandler = new PumpStreamHandler((OutputStream)outStream, (OutputStream)errStream);
            executor.setStreamHandler((ExecuteStreamHandler)streamHandler);
            executor.setWatchdog(watchDog);
            int retValue = executor.execute(cli, ENVIRONMENT_MAP);
            if (retValue != 0) {
                logger.error("Non-zero exit code ({}) returned from executing ccm command: {}", (Object)retValue, (Object)cli);
                pw.flush();
                throw new CCMException(String.format("Non-zero exit code (%s) returned from executing ccm command: %s", retValue, cli), sw.toString());
            }
        }
        catch (IOException e) {
            if (watchDog.killedProcess()) {
                logger.error("The command {} was killed after 10 minutes", (Object)cli);
            }
            pw.flush();
            throw new CCMException(String.format("The command %s failed to execute", cli), sw.toString(), e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return sw.toString();
    }

    private String executeUnsanitized(String ... args) {
        CommandLine cli = CommandLine.parse((String)CCM_COMMAND);
        for (String arg : args) {
            cli.addArgument(arg, false);
        }
        cli.addArgument("--config-dir=" + this.ccmDir);
        return this.executeCommand(cli);
    }

    private String execute(String command, Object ... args) {
        String fullCommand = String.format(command, args) + " --config-dir=" + this.ccmDir;
        CommandLine cli = CommandLine.parse((String)fullCommand);
        return this.executeCommand(cli);
    }

    @Override
    public void waitForUp(int node) {
        TestUtils.waitUntilPortIsUp(this.addressOfNode(node));
    }

    @Override
    public void waitForDown(int node) {
        TestUtils.waitUntilPortIsDown(this.addressOfNode(node));
    }

    @Override
    public void dsetool(int node, String ... args) {
        this.execute(CCM_COMMAND + " node%d dsetool %s", node, Joiner.on((String)" ").join((Object[])args));
    }

    @Override
    public void reloadCore(int node, String keyspace, String table, boolean reindex) {
        this.dsetool(node, "reload_core", keyspace + "." + table, "reindex=" + reindex);
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        VersionNumber dseVersion = this.getDSEVersion();
        if (dseVersion != null && dseVersion.compareTo(VersionNumber.parse((String)"6.0")) >= 0) {
            return ProtocolVersion.DSE_V2;
        }
        if (dseVersion != null && dseVersion.compareTo(VersionNumber.parse((String)"5.1.0")) >= 0) {
            return ProtocolVersion.DSE_V1;
        }
        VersionNumber cassandraVersion = this.getCassandraVersion();
        if (cassandraVersion.compareTo(VersionNumber.parse((String)"2.0")) < 0) {
            return ProtocolVersion.V1;
        }
        if (cassandraVersion.compareTo(VersionNumber.parse((String)"2.1")) < 0) {
            return ProtocolVersion.V2;
        }
        if (cassandraVersion.compareTo(VersionNumber.parse((String)"2.2")) < 0) {
            return ProtocolVersion.V3;
        }
        return ProtocolVersion.V4;
    }

    @Override
    public ProtocolVersion getProtocolVersion(ProtocolVersion maximumAllowed) {
        ProtocolVersion versionToUse = this.getProtocolVersion();
        return versionToUse.compareTo((Enum)maximumAllowed) > 0 ? maximumAllowed : versionToUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempStore(String storePath) {
        File f = null;
        Closer closer = Closer.create();
        try {
            InputStream trustStoreIs = CCMBridge.class.getResourceAsStream(storePath);
            closer.register((Closeable)trustStoreIs);
            f = File.createTempFile("server", ".store");
            logger.debug("Created store file {} for {}.", (Object)f, (Object)storePath);
            FileOutputStream trustStoreOs = new FileOutputStream(f);
            closer.register((Closeable)trustStoreOs);
            ByteStreams.copy((InputStream)trustStoreIs, (OutputStream)trustStoreOs);
        }
        catch (IOException e) {
            logger.warn("Failure to write keystore, SSL-enabled servers may fail to start.", (Throwable)e);
        }
        finally {
            try {
                closer.close();
            }
            catch (IOException e) {
                logger.warn("Failure closing streams.", (Throwable)e);
            }
        }
        return f;
    }

    public String toString() {
        return "CCM cluster " + this.clusterName;
    }

    protected void finalize() throws Throwable {
        logger.debug("GC'ing {}", (Object)this);
        this.close();
        super.finalize();
    }

    static {
        DEFAULT_CLIENT_TRUSTSTORE_FILE = CCMBridge.createTempStore(DEFAULT_CLIENT_TRUSTSTORE_PATH);
        DEFAULT_CLIENT_KEYSTORE_FILE = CCMBridge.createTempStore(DEFAULT_CLIENT_KEYSTORE_PATH);
        DEFAULT_CLIENT_PRIVATE_KEY_FILE = CCMBridge.createTempStore("/client.key");
        DEFAULT_CLIENT_CERT_CHAIN_FILE = CCMBridge.createTempStore("/client.crt");
        DEFAULT_SERVER_TRUSTSTORE_FILE = CCMBridge.createTempStore(DEFAULT_SERVER_TRUSTSTORE_PATH);
        DEFAULT_SERVER_KEYSTORE_FILE = CCMBridge.createTempStore(DEFAULT_SERVER_KEYSTORE_PATH);
        dseToCassandraVersions = ImmutableMap.builder().put((Object)"6.0", (Object)"4.0").put((Object)"5.1", (Object)"3.11").put((Object)"5.0.4", (Object)"3.0.10").put((Object)"5.0.3", (Object)"3.0.9").put((Object)"5.0.2", (Object)"3.0.8").put((Object)"5.0.1", (Object)"3.0.7").put((Object)"5.0", (Object)"3.0.7").put((Object)"4.8.11", (Object)"2.1.17").put((Object)"4.8.10", (Object)"2.1.15").put((Object)"4.8.9", (Object)"2.1.15").put((Object)"4.8.8", (Object)"2.1.14").put((Object)"4.8.7", (Object)"2.1.14").put((Object)"4.8.6", (Object)"2.1.13").put((Object)"4.8.5", (Object)"2.1.13").put((Object)"4.8.4", (Object)"2.1.12").put((Object)"4.8.3", (Object)"2.1.11").put((Object)"4.8.2", (Object)"2.1.11").put((Object)"4.8.1", (Object)"2.1.11").put((Object)"4.8", (Object)"2.1.9").put((Object)"4.7.9", (Object)"2.1.15").put((Object)"4.7.8", (Object)"2.1.13").put((Object)"4.7.7", (Object)"2.1.12").put((Object)"4.7.6", (Object)"2.1.11").put((Object)"4.7.5", (Object)"2.1.11").put((Object)"4.7.4", (Object)"2.1.11").put((Object)"4.7.3", (Object)"2.1.8").put((Object)"4.7.2", (Object)"2.1.8").put((Object)"4.7.1", (Object)"2.1.5").put((Object)"4.6.11", (Object)"2.0.16").put((Object)"4.6.10", (Object)"2.0.16").put((Object)"4.6.9", (Object)"2.0.16").put((Object)"4.6.8", (Object)"2.0.16").put((Object)"4.6.7", (Object)"2.0.14").put((Object)"4.6.6", (Object)"2.0.14").put((Object)"4.6.5", (Object)"2.0.14").put((Object)"4.6.4", (Object)"2.0.14").put((Object)"4.6.3", (Object)"2.0.12").put((Object)"4.6.2", (Object)"2.0.12").put((Object)"4.6.1", (Object)"2.0.12").put((Object)"4.6", (Object)"2.0.11").put((Object)"4.5.9", (Object)"2.0.16").put((Object)"4.5.8", (Object)"2.0.14").put((Object)"4.5.7", (Object)"2.0.12").put((Object)"4.5.6", (Object)"2.0.12").put((Object)"4.5.5", (Object)"2.0.12").put((Object)"4.5.4", (Object)"2.0.11").put((Object)"4.5.3", (Object)"2.0.11").put((Object)"4.5.2", (Object)"2.0.10").put((Object)"4.5.1", (Object)"2.0.8").put((Object)"4.5", (Object)"2.0.8").put((Object)"4.0", (Object)"2.0").put((Object)"3.2", (Object)"1.2").put((Object)"3.1", (Object)"1.2").build();
        String inputCassandraVersion = System.getProperty("cassandra.version");
        String installDirectory = System.getProperty("cassandra.directory");
        String branch = System.getProperty("cassandra.branch");
        String dseProperty = System.getProperty("dse");
        boolean isDse = dseProperty != null && (dseProperty.isEmpty() || Boolean.parseBoolean(dseProperty));
        ImmutableSet.Builder installArgs = ImmutableSet.builder();
        if (installDirectory != null && !installDirectory.trim().isEmpty()) {
            installArgs.add((Object)("--install-dir=" + new File(installDirectory).getAbsolutePath()));
        } else if (branch != null && !branch.trim().isEmpty()) {
            installArgs.add((Object)("-v git:" + branch.trim().replaceAll("\"", "")));
        } else {
            installArgs.add((Object)("-v " + inputCassandraVersion));
        }
        if (isDse) {
            installArgs.add((Object)"--dse");
        }
        CASSANDRA_INSTALL_ARGS = installArgs.build();
        HashMap envMap = Maps.newHashMap(new ProcessBuilder(new String[0]).environment());
        String ccmPath = System.getProperty("ccm.path");
        if (ccmPath != null) {
            String existingPath = (String)envMap.get("PATH");
            if (existingPath == null) {
                existingPath = "";
            }
            envMap.put("PATH", ccmPath + File.pathSeparator + existingPath);
        }
        CCM_COMMAND = CCMBridge.isWindows() ? "powershell.exe -ExecutionPolicy Unrestricted ccm.py" : "ccm";
        String ccmJavaHome = System.getProperty("ccm.java.home");
        if (ccmJavaHome != null) {
            envMap.put("JAVA_HOME", ccmJavaHome);
        }
        ENVIRONMENT_MAP = ImmutableMap.copyOf((Map)envMap);
        if (isDse) {
            GLOBAL_DSE_VERSION_NUMBER = VersionNumber.parse((String)inputCassandraVersion);
            GLOBAL_CASSANDRA_VERSION_NUMBER = CCMBridge.getCassandraVersion(GLOBAL_DSE_VERSION_NUMBER);
            logger.info("Tests requiring CCM will by default use DSE version {} (C* {}, install arguments: {})", new Object[]{GLOBAL_DSE_VERSION_NUMBER, GLOBAL_CASSANDRA_VERSION_NUMBER, CASSANDRA_INSTALL_ARGS});
        } else {
            GLOBAL_CASSANDRA_VERSION_NUMBER = VersionNumber.parse((String)inputCassandraVersion);
            GLOBAL_DSE_VERSION_NUMBER = null;
            logger.info("Tests requiring CCM will by default use Cassandra version {} (install arguments: {})", (Object)GLOBAL_CASSANDRA_VERSION_NUMBER, CASSANDRA_INSTALL_ARGS);
        }
    }

    public static class Builder {
        public static final String RANDOM_PORT = "__RANDOM_PORT__";
        private static final Pattern RANDOM_PORT_PATTERN = Pattern.compile("__RANDOM_PORT__");
        private String ipPrefix = TestUtils.IP_PREFIX;
        int[] nodes = new int[]{1};
        private int[] jmxPorts = new int[0];
        private boolean start = true;
        private boolean dse = false;
        private VersionNumber version = null;
        private Set<String> createOptions = new LinkedHashSet<String>();
        private Set<String> jvmArgs = new LinkedHashSet<String>();
        private final Map<String, Object> cassandraConfiguration = Maps.newLinkedHashMap();
        private final Map<String, Object> dseConfiguration = Maps.newLinkedHashMap();
        private final List<String> rawDseYaml = Lists.newArrayList();
        private final Map<Integer, String[]> workloads = new HashMap<Integer, String[]>();

        private Builder() {
            this.cassandraConfiguration.put("start_rpc", false);
            this.cassandraConfiguration.put("storage_port", RANDOM_PORT);
            this.cassandraConfiguration.put("rpc_port", RANDOM_PORT);
            this.cassandraConfiguration.put("native_transport_port", RANDOM_PORT);
        }

        public Builder withIpPrefix(String ipPrefix) {
            this.ipPrefix = ipPrefix;
            return this;
        }

        public Builder withNodes(int ... nodes) {
            this.nodes = nodes;
            return this;
        }

        public Builder withoutNodes() {
            return this.withNodes(new int[0]);
        }

        public Builder withSSL() {
            this.cassandraConfiguration.put("client_encryption_options.enabled", "true");
            this.cassandraConfiguration.put("client_encryption_options.keystore", DEFAULT_SERVER_KEYSTORE_FILE.getAbsolutePath());
            this.cassandraConfiguration.put("client_encryption_options.keystore_password", "cassandra1sfun");
            return this;
        }

        public Builder withAuth() {
            this.withSSL();
            this.cassandraConfiguration.put("client_encryption_options.require_client_auth", "true");
            this.cassandraConfiguration.put("client_encryption_options.truststore", DEFAULT_SERVER_TRUSTSTORE_FILE.getAbsolutePath());
            this.cassandraConfiguration.put("client_encryption_options.truststore_password", "cassandra1sfun");
            return this;
        }

        public Builder notStarted() {
            this.start = false;
            return this;
        }

        public Builder withVersion(VersionNumber version) {
            this.version = version;
            return this;
        }

        public Builder withDSE(boolean dse) {
            this.dse = dse;
            return this;
        }

        public Builder withCreateOptions(String ... createOptions) {
            Collections.addAll(this.createOptions, createOptions);
            return this;
        }

        public Builder withCassandraConfiguration(String key, Object value) {
            this.cassandraConfiguration.put(key, value);
            return this;
        }

        public Builder withDSEConfiguration(String key, Object value) {
            this.dseConfiguration.put(key, value);
            return this;
        }

        public Builder withDSEConfiguration(String yaml) {
            this.rawDseYaml.add(yaml);
            return this;
        }

        public Builder withJvmArgs(String ... jvmArgs) {
            Collections.addAll(this.jvmArgs, jvmArgs);
            return this;
        }

        public Builder withStoragePort(int port) {
            this.cassandraConfiguration.put("storage_port", port);
            return this;
        }

        public Builder withThriftPort(int port) {
            this.cassandraConfiguration.put("rpc_port", port);
            return this;
        }

        public Builder withBinaryPort(int port) {
            this.cassandraConfiguration.put("native_transport_port", port);
            return this;
        }

        public Builder withJmxPorts(int ... ports) {
            this.jmxPorts = ports;
            return this;
        }

        public Builder withWorkload(int node, String ... workload) {
            this.workloads.put(node, workload);
            return this;
        }

        public CCMBridge build() {
            VersionNumber cassandraVersion;
            VersionNumber dseVersion;
            boolean versionConfigured;
            String clusterName = TestUtils.generateIdentifier("ccm_");
            boolean bl = versionConfigured = this.version != null;
            if (!versionConfigured) {
                dseVersion = GLOBAL_DSE_VERSION_NUMBER;
                cassandraVersion = GLOBAL_CASSANDRA_VERSION_NUMBER;
            } else if (this.dse) {
                dseVersion = this.version;
                cassandraVersion = CCMBridge.getCassandraVersion(dseVersion);
            } else {
                dseVersion = null;
                cassandraVersion = this.version;
            }
            Map<String, Object> cassandraConfiguration = this.randomizePorts(this.cassandraConfiguration);
            int storagePort = Integer.parseInt(cassandraConfiguration.get("storage_port").toString());
            int thriftPort = Integer.parseInt(cassandraConfiguration.get("rpc_port").toString());
            int binaryPort = Integer.parseInt(cassandraConfiguration.get("native_transport_port").toString());
            int numNodes = 0;
            for (int i : this.nodes) {
                numNodes += i;
            }
            int[] generatedJmxPorts = new int[numNodes];
            for (int i = 0; i < numNodes; ++i) {
                generatedJmxPorts[i] = i >= this.jmxPorts.length ? TestUtils.findAvailablePort() : this.jmxPorts[i];
            }
            if (!Builder.isThriftSupported(cassandraVersion)) {
                cassandraConfiguration.remove("start_rpc");
                cassandraConfiguration.remove("rpc_port");
                cassandraConfiguration.remove("thrift_prepared_statements_cache_size_mb");
            }
            final CCMBridge ccm = new CCMBridge(clusterName, cassandraVersion, dseVersion, this.ipPrefix, storagePort, thriftPort, binaryPort, generatedJmxPorts, this.joinJvmArgs(), this.nodes);
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    ccm.close();
                }
            });
            ccm.execute(this.buildCreateCommand(clusterName, versionConfigured, cassandraVersion, dseVersion), new Object[0]);
            this.updateNodeConf(ccm);
            ccm.updateConfig(cassandraConfiguration);
            if (dseVersion != null) {
                Map<Object, Object> dseConfiguration = Maps.newLinkedHashMap(this.dseConfiguration);
                if (dseVersion.getMajor() >= 5) {
                    dseConfiguration.put("lease_netty_server_port", RANDOM_PORT);
                    dseConfiguration.put("internode_messaging_options.port", RANDOM_PORT);
                }
                if (!(dseConfiguration = this.randomizePorts((Map<String, Object>)dseConfiguration)).isEmpty()) {
                    ccm.updateDSEConfig(dseConfiguration);
                }
                for (String yaml : this.rawDseYaml) {
                    ccm.updateDSEConfig(yaml);
                }
            }
            for (Map.Entry<Integer, String[]> entry : this.workloads.entrySet()) {
                ccm.setWorkload(entry.getKey(), entry.getValue());
            }
            if (this.start) {
                ccm.start();
            }
            return ccm;
        }

        private static boolean isThriftSupported(VersionNumber cassandraVersion) {
            return cassandraVersion.compareTo(VersionNumber.parse((String)"4.0")) < 0;
        }

        public int weight() {
            int totalNodes = 0;
            for (int nodesPerDc : this.nodes) {
                totalNodes += nodesPerDc;
            }
            return totalNodes;
        }

        private String joinJvmArgs() {
            StringBuilder allJvmArgs = new StringBuilder("");
            String quote = CCMBridge.isWindows() ? "\"" : "";
            for (String jvmArg : this.jvmArgs) {
                allJvmArgs.append(" ");
                allJvmArgs.append(quote);
                allJvmArgs.append("--jvm_arg=");
                allJvmArgs.append(this.randomizePorts(jvmArg));
                allJvmArgs.append(quote);
            }
            return allJvmArgs.toString();
        }

        private String buildCreateCommand(String clusterName, boolean versionConfigured, VersionNumber cassandraVersion, VersionNumber dseVersion) {
            StringBuilder result = new StringBuilder(CCM_COMMAND + " create");
            result.append(" ").append(clusterName);
            result.append(" -i ").append(this.ipPrefix);
            result.append(" ");
            if (this.nodes.length > 0) {
                result.append(" -n ");
                for (int i = 0; i < this.nodes.length; ++i) {
                    int node = this.nodes[i];
                    if (i > 0) {
                        result.append(':');
                    }
                    result.append(node);
                }
            }
            LinkedHashSet<String> lCreateOptions = new LinkedHashSet<String>(this.createOptions);
            if (!versionConfigured) {
                lCreateOptions.addAll(CASSANDRA_INSTALL_ARGS);
            } else if (dseVersion != null) {
                lCreateOptions.add("--dse");
                lCreateOptions.add("-v");
                lCreateOptions.add(dseVersion.toString());
            } else {
                lCreateOptions.add("-v");
                lCreateOptions.add(cassandraVersion.toString());
            }
            result.append(" ").append(Joiner.on((String)" ").join(this.randomizePorts(lCreateOptions)));
            return result.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateNodeConf(CCMBridge ccm) {
            int n = 1;
            Closer closer = Closer.create();
            try {
                for (int dc = 1; dc <= this.nodes.length; ++dc) {
                    int nodesInDc = this.nodes[dc - 1];
                    for (int i = 0; i < nodesInDc; ++i) {
                        String line;
                        int jmxPort = ccm.jmxAddressOfNode(n).getPort();
                        int debugPort = TestUtils.findAvailablePort();
                        logger.trace("Node {} in cluster {} using JMX port {} and debug port {}", new Object[]{n, ccm.getClusterName(), jmxPort, debugPort});
                        File nodeConf = new File(ccm.getNodeDir(n), "node.conf");
                        File nodeConf2 = new File(ccm.getNodeDir(n), "node.conf.tmp");
                        BufferedReader br = (BufferedReader)closer.register((Closeable)new BufferedReader(new FileReader(nodeConf)));
                        PrintWriter pw = (PrintWriter)closer.register((Closeable)new PrintWriter(new FileWriter(nodeConf2)));
                        while ((line = br.readLine()) != null) {
                            if ((line = line.replace("9042", Integer.toString(ccm.binaryPort)).replace("9160", Integer.toString(ccm.thriftPort)).replace("7000", Integer.toString(ccm.storagePort))).startsWith("jmx_port")) {
                                line = String.format("jmx_port: '%s'", jmxPort);
                            } else if (line.startsWith("remote_debug_port")) {
                                line = String.format("remote_debug_port: %s:%s", this.ipPrefix + n, debugPort);
                            }
                            pw.println(line);
                        }
                        pw.flush();
                        pw.close();
                        com.google.common.io.Files.move((File)nodeConf2, (File)nodeConf);
                        ++n;
                    }
                }
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
            finally {
                try {
                    closer.close();
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
            }
        }

        private Set<String> randomizePorts(Set<String> set) {
            LinkedHashSet<String> randomized = new LinkedHashSet<String>();
            for (String value : set) {
                randomized.add(this.randomizePorts(value));
            }
            return randomized;
        }

        private Map<String, Object> randomizePorts(Map<String, Object> map) {
            HashMap<String, Object> randomized = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof CharSequence) {
                    value = this.randomizePorts((CharSequence)value);
                }
                randomized.put(entry.getKey(), value);
            }
            return randomized;
        }

        private String randomizePorts(CharSequence str) {
            Matcher matcher = RANDOM_PORT_PATTERN.matcher(str);
            StringBuffer sb = new StringBuffer();
            while (matcher.find()) {
                matcher.appendReplacement(sb, Integer.toString(TestUtils.findAvailablePort()));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            if (this.ipPrefix != builder.ipPrefix) {
                return false;
            }
            if (this.dse != builder.dse) {
                return false;
            }
            if (!Arrays.equals(this.nodes, builder.nodes)) {
                return false;
            }
            if (this.version != null ? !this.version.equals((Object)builder.version) : builder.version != null) {
                return false;
            }
            if (!this.createOptions.equals(builder.createOptions)) {
                return false;
            }
            if (!this.jvmArgs.equals(builder.jvmArgs)) {
                return false;
            }
            if (!this.cassandraConfiguration.equals(builder.cassandraConfiguration)) {
                return false;
            }
            if (!this.dseConfiguration.equals(builder.dseConfiguration)) {
                return false;
            }
            return this.workloads.equals(builder.workloads);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.nodes);
            result = 31 * result + (this.dse ? 1 : 0);
            result = 31 * result + this.ipPrefix.hashCode();
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            result = 31 * result + this.createOptions.hashCode();
            result = 31 * result + this.jvmArgs.hashCode();
            result = 31 * result + this.cassandraConfiguration.hashCode();
            result = 31 * result + this.dseConfiguration.hashCode();
            result = 31 * result + this.workloads.hashCode();
            return result;
        }
    }
}

