/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AddressFormatter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import org.assertj.core.api.Assertions;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class AddressFormatterTest {
    @Test(groups={"unit"}, dataProvider="addresses-provider")
    public void should_format_addresses(Object address, String expected) {
        String result = AddressFormatter.nullSafeToString((Object)address);
        Assertions.assertThat((String)result).isEqualTo((Object)expected);
    }

    @DataProvider(name="addresses-provider")
    public Object[][] addresses() throws UnknownHostException {
        return new Object[][]{{new InetSocketAddress(8888), "0.0.0.0:8888"}, {new InetSocketAddress("127.0.0.1", 8888), "127.0.0.1:8888"}, {InetSocketAddress.createUnresolved("127.0.0.2", 8080), "127.0.0.2:8080"}, {InetAddress.getByName("127.0.0.1"), "127.0.0.1"}};
    }
}

