/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConvictionPolicy;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Token;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mockito.Mockito;
import org.testng.Assert;

public class AbstractReplicationStrategyTest {
    private static final Token.Factory partitioner = Token.getFactory((String)"Murmur3Partitioner");
    private static final Cluster.Manager mockManager = (Cluster.Manager)Mockito.mock(Cluster.Manager.class);

    protected static Token.Factory partitioner() {
        return partitioner;
    }

    protected static HostMock host(InetSocketAddress address) {
        return new HostMock(address, mockManager);
    }

    protected static HostMock host(InetSocketAddress address, String dc, String rack) {
        return new HostMock(address, dc, rack, mockManager);
    }

    protected static HostMock asMock(Host host) {
        return host instanceof HostMock ? (HostMock)host : null;
    }

    protected static InetSocketAddress mockAddress(Host host) {
        HostMock mock = AbstractReplicationStrategyTest.asMock(host);
        return mock == null ? null : mock.getMockAddress();
    }

    protected static Token token(String value) {
        return partitioner.fromString(value);
    }

    protected static List<Token> tokens(String ... values) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : values) {
            builder.add((Object)AbstractReplicationStrategyTest.token(value));
        }
        return builder.build();
    }

    protected static void assertReplicaPlacement(Map<Token, Set<Host>> replicaMap, Token token, InetSocketAddress ... expected) {
        Set<Host> replicaSet = replicaMap.get(token);
        Assert.assertNotNull(replicaSet);
        AbstractReplicationStrategyTest.assertReplicasForToken(replicaSet, expected);
    }

    protected static void assertReplicasForToken(Set<Host> replicaSet, InetSocketAddress ... expected) {
        String message = "Contents of replica set: " + replicaSet + " do not match expected hosts: " + Arrays.toString(expected);
        Assert.assertEquals((int)replicaSet.size(), (int)expected.length, (String)message);
        int i = 0;
        for (Host hostReturned : replicaSet) {
            boolean match = true;
            if (!expected[i++].equals(AbstractReplicationStrategyTest.mockAddress(hostReturned))) {
                match = false;
            }
            Assert.assertTrue((boolean)match, (String)message);
        }
    }

    protected static InetSocketAddress socketAddress(String address) {
        try {
            return new InetSocketAddress(InetAddress.getByName(address), 9042);
        }
        catch (UnknownHostException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected static class HostMock
    extends Host {
        private final InetSocketAddress address;

        private HostMock(InetSocketAddress address, Cluster.Manager manager) {
            super(address, (ConvictionPolicy.Factory)new ConvictionPolicy.DefaultConvictionPolicy.Factory(), manager);
            this.address = address;
        }

        private HostMock(InetSocketAddress address, String dc, String rack, Cluster.Manager manager) {
            this(address, manager);
            this.setLocationInfo(dc, rack);
        }

        public String toString() {
            return this.address.toString();
        }

        public InetSocketAddress getMockAddress() {
            return this.address;
        }

        public boolean equals(Object o) {
            if (!(o instanceof HostMock)) {
                return false;
            }
            return this.address.equals(((HostMock)((Object)o)).address);
        }

        public int hashCode() {
            return this.address.hashCode();
        }
    }
}

