/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class AbstractPoliciesTest
extends CCMTestsSupport {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPoliciesTest.class);
    private String tableName;
    protected Map<InetAddress, Integer> coordinators = new HashMap<InetAddress, Integer>();
    protected PreparedStatement prepared;

    protected void createSchema(int replicationFactor) {
        String ks = TestUtils.generateIdentifier("ks_");
        this.tableName = TestUtils.generateIdentifier("table_");
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : 'SimpleStrategy', 'replication_factor' : %d }", ks, replicationFactor));
        this.useKeyspace(ks);
        this.session().execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, i int)", this.tableName));
        ConditionChecker.check().before(5L, TimeUnit.MINUTES).that(new SchemaInAgreement(this.cluster())).becomesTrue();
    }

    protected void createMultiDCSchema(int dc1RF, int dc2RF) {
        String ks = TestUtils.generateIdentifier("ks_");
        this.tableName = TestUtils.generateIdentifier("table_");
        this.session().execute(String.format("CREATE KEYSPACE %s WITH replication = { 'class' : '%s', %s }", ks, "NetworkTopologyStrategy", String.format("'dc1' : %d, 'dc2' : %d", dc1RF, dc2RF)));
        this.useKeyspace(ks);
        this.session().execute(String.format("CREATE TABLE %s (k int PRIMARY KEY, i int)", this.tableName));
        ConditionChecker.check().before(5L, TimeUnit.MINUTES).that(new SchemaInAgreement(this.cluster())).becomesTrue();
    }

    protected void addCoordinator(ResultSet rs) {
        InetAddress coordinator;
        Integer n = this.coordinators.get(coordinator = rs.getExecutionInfo().getQueriedHost().getAddress());
        this.coordinators.put(coordinator, n == null ? 1 : n + 1);
    }

    @BeforeMethod(groups={"long"})
    protected void resetCoordinators() {
        this.coordinators = new HashMap<InetAddress, Integer>();
    }

    @AfterMethod(groups={"long"})
    protected void pause() {
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private String queriedMapString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<InetAddress, Integer> entry : this.coordinators.entrySet()) {
            sb.append(entry.getKey()).append(" : ").append(entry.getValue()).append(", ");
        }
        return sb.append("}").toString();
    }

    protected void assertQueried(String host, int n) {
        try {
            Integer queried = this.coordinators.get(InetAddress.getByName(host));
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Expected: %s\tReceived: %s", n, queried));
            } else {
                Assert.assertEquals((int)(queried == null ? 0 : queried), (int)n, (String)this.queriedMapString());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void init(int n) {
        this.init(n, false, ConsistencyLevel.ONE);
    }

    protected void init(int n, boolean batch) {
        this.init(n, batch, ConsistencyLevel.ONE);
    }

    protected void init(int n, ConsistencyLevel cl) {
        this.write(n, false, cl);
    }

    protected void init(int n, boolean batch, ConsistencyLevel cl) {
        this.write(n, batch, cl);
        this.prepared = this.session().prepare("SELECT * FROM " + this.tableName + " WHERE k = ?").setConsistencyLevel(cl);
    }

    protected void write(int n) {
        this.write(n, false, ConsistencyLevel.ONE);
    }

    protected void write(int n, boolean batch) {
        this.write(n, batch, ConsistencyLevel.ONE);
    }

    protected void write(int n, ConsistencyLevel cl) {
        this.write(n, false, cl);
    }

    protected void write(int n, boolean batch, ConsistencyLevel cl) {
        for (int i = 0; i < n; ++i) {
            if (batch) {
                this.session().execute(QueryBuilder.batch((RegularStatement[])new RegularStatement[0]).add((RegularStatement)QueryBuilder.insertInto((String)this.tableName).values(new String[]{"k", "i"}, new Object[]{0, 0})).setConsistencyLevel(cl));
                continue;
            }
            this.session().execute(new SimpleStatement(String.format("INSERT INTO %s(k, i) VALUES (0, 0)", this.tableName)).setConsistencyLevel(cl));
        }
    }

    protected void query(int n) {
        this.query(n, false, ConsistencyLevel.ONE);
    }

    protected void query(int n, boolean usePrepared) {
        this.query(n, usePrepared, ConsistencyLevel.ONE);
    }

    protected void query(int n, ConsistencyLevel cl) {
        this.query(n, false, cl);
    }

    protected void query(int n, boolean usePrepared, ConsistencyLevel cl) {
        if (usePrepared) {
            BoundStatement bs = this.prepared.bind(new Object[]{0});
            for (int i = 0; i < n; ++i) {
                this.addCoordinator(this.session().execute((Statement)bs));
            }
        } else {
            ByteBuffer routingKey = ByteBuffer.allocate(4);
            routingKey.putInt(0, 0);
            for (int i = 0; i < n; ++i) {
                this.addCoordinator(this.session().execute(new SimpleStatement(String.format("SELECT * FROM %s WHERE k = 0", this.tableName)).setRoutingKey(routingKey).setConsistencyLevel(cl)));
            }
        }
    }

    private static class SchemaInAgreement
    implements Callable<Boolean> {
        private final Cluster cluster;

        private SchemaInAgreement(Cluster cluster) {
            this.cluster = cluster;
        }

        @Override
        public Boolean call() throws Exception {
            return this.cluster.getMetadata().checkSchemaAgreement();
        }
    }
}

