/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.dse.graph.GraphJsonUtils;
import com.datastax.driver.dse.graph.GraphNode;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class PrintElementsTest {
    @Test(groups={"unit"})
    public void should_print_graph_elements_with_graphson2_correctly() {
        GraphNode gn = GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\":\"g:Vertex\",\"@value\":{\"id\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"label\":\"person\",\"properties\":{\"name\":[{\"@type\":\"g:VertexProperty\",\"@value\":{\"id\":{\"~label\":\"name\",\"~out_vertex\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"~local_id\":{\"@type\":\"g:UUID\",\"@value\":\"00000000-0000-7fff-0000-000000000000\"}},\"value\":\"marko\",\"label\":\"name\"}}],\"age\":[{\"@type\":\"g:VertexProperty\",\"@value\":{\"id\":{\"~label\":\"age\",\"~out_vertex\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"~local_id\":{\"@type\":\"g:UUID\",\"@value\":\"00000000-0000-8000-0000-000000000000\"}},\"value\":{\"@type\":\"g:Int32\",\"@value\":29},\"label\":\"age\"}}]}}}");
        Assertions.assertThat((String)gn.asVertex().toString()).isEqualTo((Object)"Vertex{id={~label=person, community_id=516547968, member_id=2}, label='person', properties={name=[VertexProperty{id={~label=name, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~local_id=00000000-0000-7fff-0000-000000000000}, properties=null, name=name, value=marko, parent-id={~label=person, community_id=516547968, member_id=2}}], age=[VertexProperty{id={~label=age, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~local_id=00000000-0000-8000-0000-000000000000}, properties=null, name=age, value=29, parent-id={~label=person, community_id=516547968, member_id=2}}]}}");
        Assertions.assertThat((String)gn.asVertex().getProperty("name").toString()).isEqualTo((Object)"VertexProperty{id={~label=name, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~local_id=00000000-0000-7fff-0000-000000000000}, properties=null, name=name, value=marko, parent-id={~label=person, community_id=516547968, member_id=2}}");
        gn = GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\":\"g:Edge\",\"@value\":{\"id\":{\"~label\":\"created\",\"~out_vertex\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"~in_vertex\":{\"~label\":\"software\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":1}},\"~local_id\":{\"@type\":\"g:UUID\",\"@value\":\"fd48d261-1a0b-11e7-81ab-170a77df6dc0\"}},\"label\":\"created\",\"inVLabel\":\"software\",\"outVLabel\":\"person\",\"inV\":{\"~label\":\"software\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":1}},\"outV\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"properties\":{\"weight\":{\"@type\":\"g:Property\",\"@value\":{\"key\":\"weight\",\"value\":{\"@type\":\"g:Float\",\"@value\":0.4}}}}}}");
        Assertions.assertThat((String)gn.asEdge().toString()).isEqualTo((Object)"Edge{id={~label=created, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~in_vertex={~label=software, community_id=516547968, member_id=1}, ~local_id=fd48d261-1a0b-11e7-81ab-170a77df6dc0}, label='created', properties={weight=[Property{name='weight', value=0.4, parent-id={~label=created, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~in_vertex={~label=software, community_id=516547968, member_id=1}, ~local_id=fd48d261-1a0b-11e7-81ab-170a77df6dc0}}]}, inV={~label=software, community_id=516547968, member_id=1}, inVLabel='software', outV={~label=person, community_id=516547968, member_id=2}, outVLabel='person'}");
        Assertions.assertThat((String)gn.asEdge().getProperty("weight").toString()).isEqualTo((Object)"Property{name='weight', value=0.4, parent-id={~label=created, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~in_vertex={~label=software, community_id=516547968, member_id=1}, ~local_id=fd48d261-1a0b-11e7-81ab-170a77df6dc0}}");
        gn = GraphJsonUtils.readStringAsTreeGraphson20((String)"{\"@type\":\"g:Path\",\"@value\":{\"labels\":[[\"a\"],[\"b\"]],\"objects\":[{\"@type\":\"g:Vertex\",\"@value\":{\"id\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"label\":\"person\",\"properties\":{\"name\":[{\"@type\":\"g:VertexProperty\",\"@value\":{\"id\":{\"~label\":\"name\",\"~out_vertex\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"~local_id\":{\"@type\":\"g:UUID\",\"@value\":\"00000000-0000-7fff-0000-000000000000\"}},\"value\":\"marko\",\"label\":\"name\"}}],\"age\":[{\"@type\":\"g:VertexProperty\",\"@value\":{\"id\":{\"~label\":\"age\",\"~out_vertex\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"~local_id\":{\"@type\":\"g:UUID\",\"@value\":\"00000000-0000-8000-0000-000000000000\"}},\"value\":{\"@type\":\"g:Int32\",\"@value\":29},\"label\":\"age\"}}]}}},{\"@type\":\"g:Edge\",\"@value\":{\"id\":{\"~label\":\"created\",\"~out_vertex\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"~in_vertex\":{\"~label\":\"software\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":1}},\"~local_id\":{\"@type\":\"g:UUID\",\"@value\":\"fd48d261-1a0b-11e7-81ab-170a77df6dc0\"}},\"label\":\"created\",\"inVLabel\":\"software\",\"outVLabel\":\"person\",\"inV\":{\"~label\":\"software\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":1}},\"outV\":{\"~label\":\"person\",\"community_id\":{\"@type\":\"g:Int32\",\"@value\":516547968},\"member_id\":{\"@type\":\"g:Int64\",\"@value\":2}},\"properties\":{\"weight\":{\"@type\":\"g:Property\",\"@value\":{\"key\":\"weight\",\"value\":{\"@type\":\"g:Float\",\"@value\":0.4}}}}}}]}}");
        Assertions.assertThat((String)gn.asPath().toString()).isEqualTo((Object)"Path{labels=[[a], [b]], objects=[Vertex{id={~label=person, community_id=516547968, member_id=2}, label='person', properties={name=[VertexProperty{id={~label=name, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~local_id=00000000-0000-7fff-0000-000000000000}, properties=null, name=name, value=marko, parent-id={~label=person, community_id=516547968, member_id=2}}], age=[VertexProperty{id={~label=age, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~local_id=00000000-0000-8000-0000-000000000000}, properties=null, name=age, value=29, parent-id={~label=person, community_id=516547968, member_id=2}}]}}, Edge{id={~label=created, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~in_vertex={~label=software, community_id=516547968, member_id=1}, ~local_id=fd48d261-1a0b-11e7-81ab-170a77df6dc0}, label='created', properties={weight=[Property{name='weight', value=0.4, parent-id={~label=created, ~out_vertex={~label=person, community_id=516547968, member_id=2}, ~in_vertex={~label=software, community_id=516547968, member_id=1}, ~local_id=fd48d261-1a0b-11e7-81ab-170a77df6dc0}}]}, inV={~label=software, community_id=516547968, member_id=1}, inVLabel='software', outV={~label=person, community_id=516547968, member_id=2}, outVLabel='person'}]}");
    }
}

