/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphAssertions;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphNode;
import com.datastax.driver.dse.graph.GraphStatement;
import com.datastax.driver.dse.graph.SimpleGraphStatement;
import com.datastax.driver.dse.graph.Vertex;
import com.datastax.driver.dse.graph.VertexProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.annotations.Test;

@DseVersion(value="5.0.0")
public class CustomSerdeIntegrationTest
extends CCMGraphTestsSupport {
    @Override
    public void onTestContextInitialized() {
        super.onTestContextInitialized();
        this.executeGraph(GraphFixtures.gods(CCMBridge.getGlobalDSEVersion()));
    }

    @Test(groups={"short"})
    public void should_deserialize_vertex_as_custom_type() throws Exception {
        GraphNode result = this.session().executeGraph("g.V().has('name', 'neptune').next()").one();
        God neptune = (God)result.as(God.class);
        GraphAssertions.assertThat((Object)neptune).isNotNull();
        GraphAssertions.assertThat((String)neptune.name).isEqualTo((Object)"neptune");
        GraphAssertions.assertThat((int)neptune.age).isEqualTo(4500);
        GraphAssertions.assertThat(neptune.nicknames).containsExactly((Object[])new String[]{"Neppy", "Flipper"});
        God neptune2 = (God)this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V(v).next()").set("v", (Object)neptune)).one().as(God.class);
        GraphAssertions.assertThat((Object)neptune2).isNotNull();
        GraphAssertions.assertThat((Object)neptune2).isEqualToComparingFieldByField((Object)neptune);
    }

    @Test(groups={"short"})
    public void should_deserialize_edge_as_custom_type() throws Exception {
        List results = this.session().executeGraph("g.V().has('name', 'hercules').outE('battled')").all();
        GraphAssertions.assertThat((List)results).hasSize(3);
        ArrayList battles = Lists.transform((List)results, (Function)new Function<GraphNode, Battle>(){

            public Battle apply(GraphNode input) {
                return (Battle)input.as(Battle.class);
            }
        });
        battles = new ArrayList(battles);
        Collections.sort(battles, new Comparator<Battle>(){

            @Override
            public int compare(Battle o1, Battle o2) {
                return o1.when.compareTo(o2.when);
            }
        });
        Battle herculesVsNemean = (Battle)battles.get(0);
        GraphAssertions.assertThat((Object)herculesVsNemean).isNotNull();
        GraphAssertions.assertThat((Date)herculesVsNemean.when).isEqualTo((Object)new Date(1L));
        GraphAssertions.assertThat((Object)herculesVsNemean.where).isEqualToComparingFieldByField((Object)new Location(38.1, 23.7));
        Battle herculesVsHydra = (Battle)battles.get(1);
        GraphAssertions.assertThat((Object)herculesVsHydra).isNotNull();
        GraphAssertions.assertThat((Date)herculesVsHydra.when).isEqualTo((Object)new Date(2L));
        GraphAssertions.assertThat((Object)herculesVsHydra.where).isEqualToComparingFieldByField((Object)new Location(37.7, 23.9));
        Battle herculesVsCerberus = (Battle)battles.get(2);
        GraphAssertions.assertThat((Object)herculesVsCerberus).isNotNull();
        GraphAssertions.assertThat((Date)herculesVsCerberus.when).isEqualTo((Object)new Date(12L));
        GraphAssertions.assertThat((Object)herculesVsCerberus.where).isEqualToComparingFieldByField((Object)new Location(39.0, 22.0));
        Battle herculesVsHydra2 = (Battle)this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.E(e).next()").set("e", (Object)herculesVsHydra)).one().as(Battle.class);
        GraphAssertions.assertThat((Object)herculesVsHydra2).isNotNull();
        GraphAssertions.assertThat((Object)herculesVsHydra2).isEqualToComparingFieldByField((Object)herculesVsHydra);
        God hercules = (God)this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V(v).next()").set("v", (Object)herculesVsCerberus.winner)).one().as(God.class);
        GraphAssertions.assertThat((Object)hercules).isNotNull();
        GraphAssertions.assertThat((String)hercules.name).isEqualTo((Object)"hercules");
        Monster hydra = (Monster)this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V(v).next()").set("v", (Object)herculesVsHydra.loser)).one().as(Monster.class);
        GraphAssertions.assertThat((Object)hydra).isNotNull();
        GraphAssertions.assertThat((String)hydra.name).isEqualTo((Object)"hydra");
    }

    @Test(groups={"short"})
    public void should_deserialize_vertex_as_default_type() throws Exception {
        GraphNode result = this.session().executeGraph("g.V().has('name', 'neptune').next()").one();
        Vertex neptune = result.asVertex();
        GraphAssertions.assertThat(neptune).isNotNull();
        GraphAssertions.assertThat((String)neptune.getProperty("name").getValue().asString()).isEqualTo((Object)"neptune");
        GraphAssertions.assertThat((int)neptune.getProperty("age").getValue().asInt()).isEqualTo(4500);
        Iterator nicknames = neptune.getProperties("nicknames");
        GraphAssertions.assertThat((String)((VertexProperty)nicknames.next()).getValue().asString()).isEqualTo((Object)"Neppy");
        GraphAssertions.assertThat((String)((VertexProperty)nicknames.next()).getValue().asString()).isEqualTo((Object)"Flipper");
        Vertex neptune2 = this.session().executeGraph((GraphStatement)new SimpleGraphStatement("g.V(v).next()").set("v", (Object)neptune)).one().asVertex();
        GraphAssertions.assertThat(neptune2).isNotNull();
        GraphAssertions.assertThat(neptune2).isEqualTo(neptune);
    }

    protected static class LocationDeserializer
    extends StdDeserializer<Location> {
        public LocationDeserializer() {
            super(Location.class);
        }

        public Location deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            Point point = (Point)p.readValueAs(Point.class);
            return new Location(point.X(), point.Y());
        }
    }

    static class BattleDeserializer
    extends StdDeserializer<Battle> {
        BattleDeserializer() {
            super(Battle.class);
        }

        public Battle deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.readValueAsTree();
            ObjectMapper objectMapper = (ObjectMapper)p.getCodec();
            Battle battle = new Battle();
            battle.id = (Map)objectMapper.treeToValue((TreeNode)node.get("id"), Map.class);
            battle.loser.id = (Map)objectMapper.treeToValue((TreeNode)node.get("inV"), Map.class);
            battle.winner.id = (Map)objectMapper.treeToValue((TreeNode)node.get("outV"), Map.class);
            battle.when = (Date)objectMapper.treeToValue((TreeNode)node.get("properties").get("time"), Date.class);
            battle.where = (Location)objectMapper.treeToValue((TreeNode)node.get("properties").get("place"), Location.class);
            return battle;
        }
    }

    static class BattleSerializer
    extends StdSerializer<Battle> {
        BattleSerializer() {
            super(Battle.class);
        }

        public void serialize(Battle value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.getCodec().writeValue(gen, value.id);
        }
    }

    static class MonsterDeserializer
    extends StdDeserializer<Monster> {
        MonsterDeserializer() {
            super(Monster.class);
        }

        public Monster deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.readValueAsTree();
            ObjectMapper objectMapper = (ObjectMapper)p.getCodec();
            Monster monster = new Monster();
            monster.id = (Map)objectMapper.treeToValue((TreeNode)node.get("id"), Map.class);
            monster.name = node.get("properties").get("name").get(0).get("value").asText();
            return monster;
        }
    }

    static class MonsterSerializer
    extends StdSerializer<Monster> {
        MonsterSerializer() {
            super(Monster.class);
        }

        public void serialize(Monster value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.getCodec().writeValue(gen, value.id);
        }
    }

    static class GodDeserializer
    extends StdDeserializer<God> {
        GodDeserializer() {
            super(God.class);
        }

        public God deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.readValueAsTree();
            ObjectMapper objectMapper = (ObjectMapper)p.getCodec();
            God god = new God();
            god.id = (Map)objectMapper.treeToValue((TreeNode)node.get("id"), Map.class);
            god.name = node.get("properties").get("name").get(0).get("value").asText();
            god.age = node.get("properties").get("age").get(0).get("value").asInt();
            god.nicknames = new LinkedHashSet<String>();
            JsonNode nicknames = node.get("properties").get("nicknames");
            if (nicknames != null) {
                for (int i = 0; i < nicknames.size(); ++i) {
                    god.nicknames.add(nicknames.get(i).get("value").asText());
                }
            }
            return god;
        }
    }

    static class GodSerializer
    extends StdSerializer<God> {
        GodSerializer() {
            super(God.class);
        }

        public void serialize(God value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.getCodec().writeValue(gen, value.id);
        }
    }

    @JsonDeserialize(using=LocationDeserializer.class)
    protected static class Location {
        final double x;
        final double y;

        Location(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    @JsonSerialize(using=BattleSerializer.class)
    @JsonDeserialize(using=BattleDeserializer.class)
    static class Battle {
        Map<String, Object> id;
        God winner = new God();
        Monster loser = new Monster();
        Date when;
        Location where;

        Battle() {
        }
    }

    @JsonSerialize(using=MonsterSerializer.class)
    @JsonDeserialize(using=MonsterDeserializer.class)
    static class Monster {
        Map<String, Object> id;
        String name;

        Monster() {
        }
    }

    @JsonSerialize(using=GodSerializer.class)
    @JsonDeserialize(using=GodDeserializer.class)
    static class God {
        Map<String, Object> id;
        String name;
        int age;
        Set<String> nicknames;

        God() {
        }
    }
}

