/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.graph;

import com.datastax.driver.core.CCMBridge;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.ConditionChecker;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.utils.DseVersion;
import com.datastax.driver.dse.DseCluster;
import com.datastax.driver.dse.DseSession;
import com.datastax.driver.dse.graph.CCMGraphTestsSupport;
import com.datastax.driver.dse.graph.GraphFixtures;
import com.datastax.driver.dse.graph.GraphOLAPQueryTest;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DseVersion(value="5.0.0")
@CCMConfig(dirtiesContext={true})
public class CCMGraphTestsOLAPSupport
extends CCMGraphTestsSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphOLAPQueryTest.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initTestContext(Object testInstance, Method testMethod) throws Exception {
        super.initTestContext(testInstance, testMethod);
        InetSocketAddress masterHttpPort = new InetSocketAddress(TestUtils.ipOfNode(1), 7080);
        LOGGER.debug("Waiting for spark master HTTP interface: {}.", (Object)masterHttpPort);
        TestUtils.waitUntilPortIsUp(masterHttpPort);
        this.waitForWorkers(1);
        DseCluster cluster = this.createClusterBuilder().addContactPointsWithPorts(this.getContactPointsWithPorts()).build();
        try {
            DseSession session = cluster.connect();
            session.execute("ALTER KEYSPACE dse_leases WITH REPLICATION = { 'class' : 'NetworkTopologyStrategy', 'GraphAnalytics': '2'}");
        }
        finally {
            cluster.close();
        }
        for (int i = 2; i <= 3; ++i) {
            LOGGER.debug("Adding node {}", (Object)i);
            this.ccm().add(i);
            this.ccm().setWorkload(i, "graph", "spark");
            this.ccm().start(i);
            InetSocketAddress binaryIntf = new InetSocketAddress(TestUtils.ipOfNode(i), this.ccm().getBinaryPort());
            TestUtils.waitUntilPortIsUp(binaryIntf);
            this.waitForWorkers(i);
        }
    }

    private void waitForWorkers(final int workerCount) {
        final ObjectMapper mapper = new ObjectMapper();
        ConditionChecker.check().that(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                LOGGER.debug("Waiting for {} workers to be alive.", (Object)workerCount);
                URL masterHome = new URL(String.format("http://%s:7080/json", TestUtils.ipOfNode(1)));
                HttpURLConnection connection = (HttpURLConnection)masterHome.openConnection();
                connection.setReadTimeout(1000);
                connection.setRequestMethod("GET");
                BufferedReader rd = null;
                try {
                    rd = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    JsonNode data = mapper.readTree((Reader)rd);
                    JsonNode workers = data.get("workers");
                    if (workers != null) {
                        int aliveWorkers = 0;
                        for (int i = 0; i < workers.size(); ++i) {
                            JsonNode worker = workers.get(i);
                            String id = worker.get("id").asText();
                            String state = worker.get("state").asText();
                            LOGGER.debug("{} is {}", (Object)id, (Object)state);
                            if (!state.equalsIgnoreCase("ALIVE")) continue;
                            ++aliveWorkers;
                        }
                        if (aliveWorkers != workerCount) {
                            LOGGER.debug("Only {}/{} workers are alive.", (Object)aliveWorkers, (Object)workerCount);
                            Boolean bl = false;
                            return bl;
                        }
                        LOGGER.debug("{}/{} workers now alive.", (Object)aliveWorkers, (Object)workerCount);
                        Boolean bl = true;
                        return bl;
                    }
                    LOGGER.debug("'workers' element not present in json");
                    Boolean bl = false;
                    return bl;
                }
                catch (Exception e) {
                    LOGGER.debug("Error encountered while checking master URL for worker count.", (Throwable)e);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (rd != null) {
                        rd.close();
                    }
                }
            }
        }).every(1L, TimeUnit.SECONDS).before(5L, TimeUnit.MINUTES).becomesTrue();
    }

    @Override
    public void onTestContextInitialized() {
        this.createAndSetGraphConfig(3);
        this.executeGraph(GraphFixtures.modern);
    }

    @Override
    public CCMBridge.Builder configureCCM() {
        CCMBridge.Builder builder = super.configureCCM().withNodes(1).withWorkload(1, "graph", "spark");
        if (CCMBridge.getGlobalDSEVersion().compareTo(VersionNumber.parse((String)"6.7.0")) >= 0) {
            builder = builder.withDSEConfiguration("alwayson_sql_options.enabled", "false");
        }
        return builder;
    }

    public Host findSparkMaster() {
        for (Host host : this.cluster().getMetadata().getAllHosts()) {
            if (!TestUtils.pingPort(host.getAddress(), 7077)) continue;
            return host;
        }
        return null;
    }
}

