/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry.codecs;

import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.codecs.GeometryCodec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public abstract class GeometryCodecTest<G extends Geometry, C extends GeometryCodec<G>> {
    private C codec;

    protected GeometryCodecTest(C codec) {
        this.codec = codec;
    }

    public abstract Object[][] serde();

    public abstract Object[][] format();

    public abstract Object[][] parse();

    @Test(groups={"unit"}, dataProvider="jackson")
    public void should_serialize_and_deserialize(G input, G expected) throws Exception {
        Assertions.assertThat((Object)this.codec.deserialize(this.codec.serialize(input, ProtocolVersion.V4), ProtocolVersion.V4)).isEqualTo(expected);
        Assertions.assertThat((Object)GeometryCodecTest.deserialize(GeometryCodecTest.serialize(input))).isEqualTo(expected);
    }

    @Test(groups={"unit"}, dataProvider="format")
    public void should_format(G input, String expected) {
        Assertions.assertThat((String)this.codec.format(input)).isEqualTo((Object)expected);
    }

    @Test(groups={"unit"}, dataProvider="parse")
    public void should_parse(String input, G expected) {
        Assertions.assertThat((Object)this.codec.parse(input)).isEqualTo(expected);
    }

    private static byte[] serialize(Object o) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(baos);
        os.writeObject(o);
        os.flush();
        os.close();
        return baos.toByteArray();
    }

    private static Object deserialize(byte[] bytes) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Object o = ois.readObject();
        bais.close();
        return o;
    }
}

