/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.dse.geometry.Distance;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.Point;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;

public class Utils {
    public static Point p(double x, double y) {
        return new Point(x, y);
    }

    static Object serializeAndDeserialize(Geometry geometry) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(geometry);
        byte[] bytes = baos.toByteArray();
        if (!(geometry instanceof Distance)) {
            byte[] wkb = Bytes.getArray((ByteBuffer)geometry.asWellKnownBinary());
            Assertions.assertThat((byte[])bytes).containsSequence(wkb);
        }
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return in.readObject();
    }
}

