/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.dse.geometry;

import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.dse.geometry.Geometry;
import com.datastax.driver.dse.geometry.LineString;
import com.datastax.driver.dse.geometry.Point;
import com.datastax.driver.dse.geometry.Polygon;
import com.datastax.driver.dse.geometry.Utils;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.testng.annotations.Test;

public class PolygonTest {
    private Polygon polygon = new Polygon(Utils.p(30.0, 10.0), Utils.p(10.0, 20.0), Utils.p(20.0, 40.0), new Point[]{Utils.p(40.0, 40.0)});
    private String wkt = "POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))";
    private String json = "{\"type\":\"Polygon\",\"coordinates\":[[[30.0,10.0],[10.0,20.0],[20.0,40.0],[40.0,40.0],[30.0,10.0]]]}";

    @Test(groups={"unit"})
    public void should_parse_valid_well_known_text() {
        Assertions.assertThat((Object)Polygon.fromWellKnownText((String)this.wkt)).isEqualTo((Object)this.polygon);
    }

    @Test(groups={"unit"})
    public void should_fail_to_parse_invalid_well_known_text() {
        this.assertInvalidWkt("polygon(())");
        this.assertInvalidWkt("polygon((30 10 1, 40 40 1, 20 40 1, 10 20 1, 30 10 1))");
        this.assertInvalidWkt("polygon((0 0, 1 1, 0 1, 1 0, 0 0))");
        this.assertInvalidWkt("polygon123((30 10, 40 40, 20 40, 10 20, 30 10))");
    }

    @Test(groups={"unit"})
    public void should_convert_to_well_know_binary() {
        ByteBuffer actual = this.polygon.asWellKnownBinary();
        ByteBuffer expected = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        expected.position(0);
        expected.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        expected.putInt(3);
        expected.putInt(1);
        expected.putInt(5);
        expected.putDouble(30.0);
        expected.putDouble(10.0);
        expected.putDouble(40.0);
        expected.putDouble(40.0);
        expected.putDouble(20.0);
        expected.putDouble(40.0);
        expected.putDouble(10.0);
        expected.putDouble(20.0);
        expected.putDouble(30.0);
        expected.putDouble(10.0);
        expected.flip();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
    }

    @Test(groups={"unit"})
    public void should_load_from_well_know_binary() {
        ByteBuffer bb = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        bb.position(0);
        bb.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        bb.putInt(3);
        bb.putInt(1);
        bb.putInt(5);
        bb.putDouble(30.0);
        bb.putDouble(10.0);
        bb.putDouble(40.0);
        bb.putDouble(40.0);
        bb.putDouble(20.0);
        bb.putDouble(40.0);
        bb.putDouble(10.0);
        bb.putDouble(20.0);
        bb.putDouble(30.0);
        bb.putDouble(10.0);
        bb.flip();
        Assertions.assertThat((Object)Polygon.fromWellKnownBinary((ByteBuffer)bb)).isEqualTo((Object)this.polygon);
    }

    @Test(groups={"unit"})
    public void should_parse_valid_geo_json() {
        Assertions.assertThat((Object)Polygon.fromGeoJson((String)this.json)).isEqualTo((Object)this.polygon);
    }

    @Test(groups={"unit"})
    public void should_convert_to_geo_json() {
        Assertions.assertThat((String)this.polygon.asGeoJson()).isEqualTo((Object)this.json);
    }

    @Test(groups={"unit"})
    public void should_convert_to_ogc_polygon() {
        Assertions.assertThat((Object)this.polygon.getOgcGeometry()).isInstanceOf(OGCPolygon.class);
    }

    @Test(groups={"unit"})
    public void should_produce_same_hashcode_for_equal_objects() {
        Polygon polygon1 = new Polygon(Utils.p(30.0, 10.0), Utils.p(10.0, 20.0), Utils.p(20.0, 40.0), new Point[]{Utils.p(40.0, 40.0)});
        Polygon polygon2 = Polygon.fromWellKnownText((String)this.wkt);
        Assertions.assertThat((Object)polygon1).isEqualTo((Object)polygon2);
        Assertions.assertThat((int)polygon1.hashCode()).isEqualTo(polygon2.hashCode());
    }

    @Test(groups={"unit"})
    public void should_build_with_constructor_without_checking_orientation() {
        Polygon polygon = new Polygon(Utils.p(5.0, 0.0), Utils.p(5.0, 3.0), Utils.p(0.0, 3.0), new Point[]{Utils.p(0.0, 0.0)});
        Assertions.assertThat((String)polygon.asWellKnownText()).isEqualTo((Object)"POLYGON ((0 0, 5 0, 5 3, 0 3, 0 0))");
    }

    @Test(groups={"unit"})
    public void should_build_complex_polygon_with_builder() {
        Polygon polygon = Polygon.builder().addRing(Utils.p(0.0, 0.0), Utils.p(0.0, 3.0), Utils.p(5.0, 3.0), new Point[]{Utils.p(5.0, 0.0)}).addRing(Utils.p(1.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 2.0), new Point[]{Utils.p(2.0, 1.0)}).addRing(Utils.p(3.0, 1.0), Utils.p(3.0, 2.0), Utils.p(4.0, 2.0), new Point[]{Utils.p(4.0, 1.0)}).build();
        Assertions.assertThat((String)polygon.asWellKnownText()).isEqualTo((Object)"POLYGON ((0 0, 5 0, 5 3, 0 3, 0 0), (1 1, 1 2, 2 2, 2 1, 1 1), (3 1, 3 2, 4 2, 4 1, 3 1))");
    }

    @Test(groups={"unit"})
    public void should_expose_rings() {
        Assertions.assertThat((List)this.polygon.getExteriorRing()).containsOnly((Object[])new Point[]{Utils.p(30.0, 10.0), Utils.p(10.0, 20.0), Utils.p(20.0, 40.0), Utils.p(40.0, 40.0)});
        Assertions.assertThat((boolean)this.polygon.getInteriorRings().isEmpty());
        Polygon fromWkt = Polygon.fromWellKnownText((String)this.wkt);
        Assertions.assertThat((List)fromWkt.getExteriorRing()).containsOnly((Object[])new Point[]{Utils.p(30.0, 10.0), Utils.p(10.0, 20.0), Utils.p(20.0, 40.0), Utils.p(40.0, 40.0)});
        Assertions.assertThat((boolean)fromWkt.getInteriorRings().isEmpty());
        Polygon complex = Polygon.builder().addRing(Utils.p(0.0, 0.0), Utils.p(0.0, 3.0), Utils.p(5.0, 3.0), new Point[]{Utils.p(5.0, 0.0)}).addRing(Utils.p(1.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 2.0), new Point[]{Utils.p(2.0, 1.0)}).addRing(Utils.p(3.0, 1.0), Utils.p(3.0, 2.0), Utils.p(4.0, 2.0), new Point[]{Utils.p(4.0, 1.0)}).build();
        Assertions.assertThat((List)complex.getExteriorRing()).containsOnly((Object[])new Point[]{Utils.p(0.0, 0.0), Utils.p(0.0, 3.0), Utils.p(5.0, 3.0), Utils.p(5.0, 0.0)});
        Assertions.assertThat((List)complex.getInteriorRings()).hasSize(2);
        Assertions.assertThat((List)((List)complex.getInteriorRings().get(0))).containsOnly((Object[])new Point[]{Utils.p(1.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 2.0), Utils.p(2.0, 1.0)});
        Assertions.assertThat((List)((List)complex.getInteriorRings().get(1))).containsOnly((Object[])new Point[]{Utils.p(3.0, 1.0), Utils.p(3.0, 2.0), Utils.p(4.0, 2.0), Utils.p(4.0, 1.0)});
        Polygon complexFromWkt = Polygon.fromWellKnownText((String)"POLYGON ((0 0, 5 0, 5 3, 0 3, 0 0), (1 1, 1 2, 2 2, 2 1, 1 1), (3 1, 3 2, 4 2, 4 1, 3 1))");
        Assertions.assertThat((List)complexFromWkt.getExteriorRing()).containsOnly((Object[])new Point[]{Utils.p(0.0, 0.0), Utils.p(0.0, 3.0), Utils.p(5.0, 3.0), Utils.p(5.0, 0.0)});
        Assertions.assertThat((List)complexFromWkt.getInteriorRings()).hasSize(2);
        Assertions.assertThat((List)((List)complexFromWkt.getInteriorRings().get(0))).containsOnly((Object[])new Point[]{Utils.p(1.0, 1.0), Utils.p(1.0, 2.0), Utils.p(2.0, 2.0), Utils.p(2.0, 1.0)});
        Assertions.assertThat((List)((List)complexFromWkt.getInteriorRings().get(1))).containsOnly((Object[])new Point[]{Utils.p(3.0, 1.0), Utils.p(3.0, 2.0), Utils.p(4.0, 2.0), Utils.p(4.0, 1.0)});
    }

    @Test(groups={"unit"})
    public void should_serialize_and_deserialize() throws Exception {
        Assertions.assertThat((Object)Utils.serializeAndDeserialize((Geometry)this.polygon)).isEqualTo((Object)this.polygon);
    }

    @Test(groups={"unit"})
    public void should_contain_self() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)this.polygon)).isTrue();
    }

    @Test(groups={"unit"})
    public void should_not_contain_point_or_linestring_on_exterior_ring() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Utils.p(30.0, 10.0))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Utils.p(30.0, 40.0))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)new LineString(Utils.p(35.0, 40.0), Utils.p(25.0, 40.0), new Point[0]))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_contain_interior_shape() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Utils.p(20.0, 20.0))).isTrue();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)new LineString(Utils.p(20.0, 20.0), Utils.p(30.0, 20.0), new Point[0]))).isTrue();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)new Polygon(Utils.p(20.0, 20.0), Utils.p(30.0, 20.0), Utils.p(20.0, 30.0), new Point[0]))).isTrue();
    }

    @Test(groups={"unit"})
    public void should_not_contain_exterior_shape() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Utils.p(10.0, 10.0))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)new LineString(Utils.p(10.0, 10.0), Utils.p(20.0, 20.0), new Point[0]))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)new Polygon(Utils.p(0.0, 0.0), Utils.p(0.0, 10.0), Utils.p(10.0, 10.0), new Point[0]))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_not_contain_shapes_in_interior_hole() {
        Polygon complex = Polygon.builder().addRing(Utils.p(0.0, 0.0), Utils.p(30.0, 0.0), Utils.p(30.0, 30.0), new Point[]{Utils.p(0.0, 30.0)}).addRing(Utils.p(10.0, 10.0), Utils.p(20.0, 10.0), Utils.p(20.0, 20.0), new Point[]{Utils.p(10.0, 20.0)}).build();
        Assertions.assertThat((boolean)complex.contains((Geometry)Utils.p(15.0, 15.0))).isFalse();
    }

    @Test(groups={"unit"})
    public void should_accept_empty_shape() throws Exception {
        Polygon polygon = Polygon.fromWellKnownText((String)"POLYGON EMPTY");
        Assertions.assertThat((List)polygon.getExteriorRing()).isEmpty();
        Assertions.assertThat((boolean)polygon.getOgcGeometry().isEmpty()).isTrue();
    }

    private void assertInvalidWkt(String s) {
        try {
            Polygon.fromWellKnownText((String)s);
            Fail.fail((String)"Should have thrown InvalidTypeException");
        }
        catch (InvalidTypeException invalidTypeException) {
            // empty catch block
        }
    }
}

