/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.QueryTracker;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.google.common.collect.Lists;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class WhiteListPolicyTest {
    QueryTracker queryTracker;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.queryTracker = new QueryTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_only_query_hosts_in_white_list() throws Exception {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5).build();
        ArrayList whiteList = Lists.newArrayList((Object[])new InetSocketAddress[]{sCluster.address(3), sCluster.address(5)});
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(5).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), (Collection)whiteList)).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 25);
            this.queryTracker.assertQueried(sCluster, 1, 4, 0);
            this.queryTracker.assertQueried(sCluster, 1, 5, 25);
            this.queryTracker.reset();
            sCluster.stop(cluster, 3);
            sCluster.stop(cluster, 5);
            this.queryTracker.query(session, 50, ConsistencyLevel.ONE, NoHostAvailableException.class);
            this.queryTracker.assertQueried(sCluster, 1, 1, 0);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 0);
            this.queryTracker.assertQueried(sCluster, 1, 5, 0);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_throw_IAE_if_name_could_not_be_resolved() {
        WhiteListPolicy.ofHosts((LoadBalancingPolicy)new RoundRobinPolicy(), (String[])new String[]{"a.b.c.d.e.f.UNRESOLVEABLE"});
    }

    @Test(groups={"unit"}, expectedExceptions={NullPointerException.class})
    public void should_throw_NPE_if_null_provided() {
        WhiteListPolicy.ofHosts((LoadBalancingPolicy)new RoundRobinPolicy(), (String[])new String[]{null, null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_only_query_hosts_in_white_list_from_hosts() throws Exception {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5).build();
        WhiteListPolicy policy = WhiteListPolicy.ofHosts((LoadBalancingPolicy)new RoundRobinPolicy(), (String[])new String[]{sCluster.address(1).getHostName(), sCluster.address(4).getHostName()});
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)policy).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            this.queryTracker.assertQueried(sCluster, 1, 1, 25);
            this.queryTracker.assertQueried(sCluster, 1, 2, 0);
            this.queryTracker.assertQueried(sCluster, 1, 3, 0);
            this.queryTracker.assertQueried(sCluster, 1, 4, 25);
            this.queryTracker.assertQueried(sCluster, 1, 5, 0);
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, expectedExceptions={IllegalArgumentException.class})
    public void should_require_contact_point_in_white_list() throws Exception {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5).build();
        ArrayList whiteList = Lists.newArrayList((Object[])new InetSocketAddress[]{sCluster.address(2)});
        Cluster cluster = Cluster.builder().addContactPointsWithPorts(new InetSocketAddress[]{sCluster.address(3)}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), (Collection)whiteList)).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            sCluster.init();
            cluster.init();
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }
}

