/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.policies;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.DataProviders;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.QueryTracker;
import com.datastax.driver.core.ScassandraCluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.net.InetAddress;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RoundRobinPolicyTest {
    Logger policyLogger = Logger.getLogger(RoundRobinPolicy.class);
    MemoryAppender logs;
    QueryTracker queryTracker;
    Level originalLevel;

    @BeforeMethod(groups={"short"})
    public void setUp() {
        this.queryTracker = new QueryTracker();
        this.originalLevel = this.policyLogger.getLevel();
        this.policyLogger.setLevel(Level.WARN);
        this.logs = new MemoryAppender();
        this.policyLogger.addAppender((Appender)this.logs);
    }

    @AfterMethod(groups={"short"}, alwaysRun=true)
    public void tearDown() {
        this.policyLogger.setLevel(this.originalLevel);
        this.policyLogger.removeAppender((Appender)this.logs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_round_robin_within_single_datacenter() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(5).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            for (int i = 1; i <= 5; ++i) {
                this.queryTracker.assertQueried(sCluster, 1, i, 10);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"})
    public void should_round_robin_irrespective_of_topology() {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(2, 2, 2, 2, 2).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50);
            for (int dc = 1; dc <= 5; ++dc) {
                for (int i = 1; i <= 2; ++i) {
                    this.queryTracker.assertQueried(sCluster, dc, i, 5);
                }
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"short"}, dataProvider="consistencyLevels", dataProviderClass=DataProviders.class)
    public void should_warn_if_using_dc_local_consistency_level(ConsistencyLevel cl) {
        ScassandraCluster sCluster = ScassandraCluster.builder().withNodes(1, 1).build();
        Cluster cluster = Cluster.builder().addContactPoints(new InetAddress[]{sCluster.address(1).getAddress()}).withPort(sCluster.getBinaryPort()).withLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy()).withNettyOptions(TestUtils.nonQuietClusterCloseOptions).build();
        String expectedLogMessage = "Detected request at Consistency Level " + cl + " but the non-DC aware RoundRobinPolicy is in use.";
        try {
            sCluster.init();
            Session session = cluster.connect();
            this.queryTracker.query(session, 50, cl);
            this.queryTracker.assertQueried(sCluster, 1, 1, 25);
            this.queryTracker.assertQueried(sCluster, 2, 1, 25);
            if (cl.isDCLocal()) {
                Assertions.assertThat((String)this.logs.get()).containsOnlyOnce((CharSequence)expectedLogMessage);
            } else {
                Assertions.assertThat((String)this.logs.get()).doesNotContain((CharSequence)expectedLogMessage);
            }
        }
        finally {
            cluster.close();
            sCluster.stop();
        }
    }
}

