/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.MemoryAppender;
import com.datastax.driver.core.RequestHandler;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.base.Strings;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Test;

@CCMConfig(config={"batch_size_warn_threshold_in_kb:5"})
@CassandraVersion(value="2.2.0")
public class WarningsTest
extends CCMTestsSupport {
    private MemoryAppender logAppender;

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE foo(k int primary key, v text)");
    }

    @Override
    public void beforeTestClass(Object instance) throws Exception {
        this.logAppender = new MemoryAppender();
        this.logAppender.enableFor(LoggerFactory.getLogger(RequestHandler.class));
        super.beforeTestClass(instance);
    }

    @Override
    public void afterTestClass() throws Exception {
        super.afterTestClass();
        this.logAppender.disableFor(LoggerFactory.getLogger(RequestHandler.class));
        this.logAppender = null;
    }

    @Test(groups={"short"})
    public void should_expose_warnings_on_execution_info() {
        String query = String.format("BEGIN UNLOGGED BATCH\nINSERT INTO foo (k, v) VALUES (1, '%s')\nINSERT INTO foo (k, v) VALUES (2, '%s')\nAPPLY BATCH", Strings.repeat((String)"1", (int)2048), Strings.repeat((String)"1", (int)3072));
        ResultSet rs = this.session().execute(query);
        List warnings = rs.getExecutionInfo().getWarnings();
        Assertions.assertThat((List)warnings).hasSize(1);
        String log = this.logAppender.getNext();
        Assertions.assertThat((String)log).isNotNull();
        Assertions.assertThat((String)log).isNotEmpty();
        Assertions.assertThat((String)log).startsWith((CharSequence)"Query '").contains(new CharSequence[]{query.substring(0, 500)}).contains(new CharSequence[]{"' generated server side warning(s): "}).contains(new CharSequence[]{String.format("Batch for [%s.foo] is of size 5152, exceeding specified threshold of 5120 by 32.", this.keyspace)});
    }

    @Test(groups={"short"})
    public void should_execute_query_and_log_server_side_warnings() {
        Assertions.assertThat((boolean)Boolean.getBoolean("com.datastax.driver.DISABLE_QUERY_WARNING_LOGS")).isFalse();
        String query = "SELECT count(*) FROM foo;";
        SimpleStatement statement = new SimpleStatement("SELECT count(*) FROM foo;");
        ResultSet rs = this.session().execute((Statement)statement);
        Row row = rs.one();
        Assertions.assertThat((Object)row).isNotNull();
        ExecutionInfo ei = rs.getExecutionInfo();
        List warnings = ei.getWarnings();
        Assertions.assertThat((List)warnings).isNotEmpty();
        Assertions.assertThat((int)warnings.size()).isEqualTo(1);
        Assertions.assertThat((String)((String)warnings.get(0))).isEqualTo((Object)"Aggregation query used without partition key");
        String log = this.logAppender.getNext();
        Assertions.assertThat((String)log).isNotNull();
        Assertions.assertThat((String)log).isNotEmpty();
        Assertions.assertThat((String)log).startsWith((CharSequence)"Query '[0 bound values] SELECT count(*) FROM foo;' generated server side warning(s): Aggregation query used without partition key");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(groups={"isolated"})
    public void should_execute_query_and_not_log_server_side_warnings() {
        String disabledLogFlag = System.getProperty("com.datastax.driver.DISABLE_QUERY_WARNING_LOGS", "false");
        Assertions.assertThat((String)disabledLogFlag).isEqualTo((Object)"false");
        System.setProperty("com.datastax.driver.DISABLE_QUERY_WARNING_LOGS", "true");
        try {
            SimpleStatement statement = new SimpleStatement("SELECT count(*) FROM foo");
            ResultSet rs = this.session().execute((Statement)statement);
            Row row = rs.one();
            Assertions.assertThat((Object)row).isNotNull();
            ExecutionInfo ei = rs.getExecutionInfo();
            List warnings = ei.getWarnings();
            Assertions.assertThat((List)warnings).isNotEmpty();
            Assertions.assertThat((int)warnings.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)warnings.get(0))).isEqualTo((Object)"Aggregation query used without partition key");
            String log = this.logAppender.getNext();
            Assertions.assertThat((String)log).isNullOrEmpty();
        }
        finally {
            System.setProperty("com.datastax.driver.DISABLE_QUERY_WARNING_LOGS", disabledLogFlag);
        }
    }
}

