/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.MappingCodec;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

@CassandraVersion(value="2.1.0")
public class TypeCodecUDTIntegrationTest
extends CCMTestsSupport {
    private final String insertQuery = "INSERT INTO users (id, name, address) VALUES (?, ?, ?)";
    private final String selectQuery = "SELECT id, name, address FROM users WHERE id = ?";
    private final UUID uuid = UUID.randomUUID();
    private final Phone phone1 = new Phone("1234567", Sets.newHashSet((Object[])new String[]{"home", "iphone"}));
    private final Phone phone2 = new Phone("2345678", Sets.newHashSet((Object[])new String[]{"work"}));
    private final Address address = new Address("blah", 75010, Lists.newArrayList((Object[])new Phone[]{this.phone1, this.phone2}));
    private UserType addressType;
    private UserType phoneType;
    private UDTValue addressValue;

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TYPE IF NOT EXISTS \"phone\" (number text, tags set<text>)", "CREATE TYPE IF NOT EXISTS \"address\" (street text, zipcode int, phones list<frozen<phone>>)", "CREATE TABLE IF NOT EXISTS \"users\" (id uuid PRIMARY KEY, name text, address frozen<address>)");
    }

    @Test(groups={"short"})
    public void should_handle_udts_with_default_codecs() {
        this.setUpUserTypes(this.cluster());
        this.session().execute("INSERT INTO users (id, name, address) VALUES (?, ?, ?)", new Object[]{this.uuid, "John Doe", this.addressValue});
        ResultSet rows = this.session().execute("SELECT id, name, address FROM users WHERE id = ?", new Object[]{this.uuid});
        Row row = rows.one();
        this.assertRow(row);
        PreparedStatement ps = this.session().prepare("INSERT INTO users (id, name, address) VALUES (?, ?, ?)");
        this.session().execute((Statement)ps.bind(new Object[]{this.uuid, "John Doe", this.addressValue}));
        rows = this.session().execute("SELECT id, name, address FROM users WHERE id = ?", new Object[]{this.uuid});
        row = rows.one();
        this.assertRow(row);
        this.session().execute((Statement)ps.bind().setUUID(0, this.uuid).setString(1, "John Doe").setUDTValue(2, this.addressValue));
        rows = this.session().execute("SELECT id, name, address FROM users WHERE id = ?", new Object[]{this.uuid});
        row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_handle_udts_with_custom_codecs() {
        CodecRegistry codecRegistry = new CodecRegistry();
        Cluster cluster = this.register(Cluster.builder().addContactPoints(this.getContactPoints()).withPort(this.ccm().getBinaryPort()).withCodecRegistry(codecRegistry).build());
        Session session = cluster.connect(this.keyspace);
        this.setUpUserTypes(cluster);
        TypeCodec addressTypeCodec = TypeCodec.userType((UserType)this.addressType);
        TypeCodec phoneTypeCodec = TypeCodec.userType((UserType)this.phoneType);
        codecRegistry.register((TypeCodec)new AddressCodec((TypeCodec<UDTValue>)addressTypeCodec, Address.class)).register((TypeCodec)new PhoneCodec((TypeCodec<UDTValue>)phoneTypeCodec, Phone.class));
        session.execute("INSERT INTO users (id, name, address) VALUES (?, ?, ?)", new Object[]{this.uuid, "John Doe", this.address});
        ResultSet rows = session.execute("SELECT id, name, address FROM users WHERE id = ?", new Object[]{this.uuid});
        Row row = rows.one();
        Assertions.assertThat((Comparable)row.getUUID(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Comparable)((Comparable)row.get(0, UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((String)row.getString(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((String)((String)row.get(1, String.class))).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getUDTValue(2)).isEqualTo((Object)this.addressValue);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)this.address);
        Assertions.assertThat((Object)row.get(2, UDTValue.class)).isEqualTo((Object)this.addressValue);
        Assertions.assertThat((Object)row.get(2, Address.class)).isEqualTo((Object)this.address);
    }

    private void assertRow(Row row) {
        Assertions.assertThat((Comparable)row.getUUID(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.uuid);
        Assertions.assertThat((Comparable)((Comparable)row.get(0, UUID.class))).isEqualTo((Object)this.uuid);
        Assertions.assertThat((String)row.getString(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)"John Doe");
        Assertions.assertThat((String)((String)row.get(1, String.class))).isEqualTo((Object)"John Doe");
        Assertions.assertThat((Object)row.getUDTValue(2)).isEqualTo((Object)this.addressValue);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)this.addressValue);
        Assertions.assertThat((Object)row.get(2, UDTValue.class)).isEqualTo((Object)this.addressValue);
    }

    private void setUpUserTypes(Cluster cluster) {
        this.addressType = cluster.getMetadata().getKeyspace(this.keyspace).getUserType("address");
        this.phoneType = cluster.getMetadata().getKeyspace(this.keyspace).getUserType("phone");
        UDTValue phone1Value = (UDTValue)((UDTValue)this.phoneType.newValue().setString("number", this.phone1.number)).setSet("tags", this.phone1.tags);
        UDTValue phone2Value = (UDTValue)((UDTValue)this.phoneType.newValue().setString("number", this.phone2.number)).setSet("tags", this.phone2.tags);
        this.addressValue = (UDTValue)((UDTValue)((UDTValue)this.addressType.newValue().setString("street", this.address.street)).setInt(1, this.address.zipcode)).setList("phones", (List)Lists.newArrayList((Object[])new UDTValue[]{phone1Value, phone2Value}));
    }

    static class Phone {
        String number;
        Set<String> tags;

        public Phone(String number, Set<String> tags) {
            this.number = number;
            this.tags = tags;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Phone phone = (Phone)o;
            return this.number.equals(phone.number) && this.tags.equals(phone.tags);
        }

        public int hashCode() {
            int result = this.number.hashCode();
            result = 31 * result + this.tags.hashCode();
            return result;
        }
    }

    static class Address {
        String street;
        int zipcode;
        List<Phone> phones;

        public Address(String street, int zipcode, List<Phone> phones) {
            this.street = street;
            this.zipcode = zipcode;
            this.phones = phones;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Address address = (Address)o;
            return this.zipcode == address.zipcode && this.street.equals(address.street) && this.phones.equals(address.phones);
        }

        public int hashCode() {
            int result = this.street.hashCode();
            result = 31 * result + this.zipcode;
            result = 31 * result + this.phones.hashCode();
            return result;
        }
    }

    static class PhoneCodec
    extends MappingCodec<Phone, UDTValue> {
        private final UserType userType;

        public PhoneCodec(TypeCodec<UDTValue> innerCodec, Class<Phone> javaType) {
            super(innerCodec, javaType);
            this.userType = (UserType)innerCodec.getCqlType();
        }

        @Override
        protected Phone deserialize(UDTValue value) {
            return value == null ? null : new Phone(value.getString("number"), value.getSet("tags", String.class));
        }

        @Override
        protected UDTValue serialize(Phone value) {
            return value == null ? null : (UDTValue)((UDTValue)this.userType.newValue().setString("number", value.number)).setSet("tags", value.tags);
        }
    }

    static class AddressCodec
    extends MappingCodec<Address, UDTValue> {
        private final UserType userType;

        public AddressCodec(TypeCodec<UDTValue> innerCodec, Class<Address> javaType) {
            super(innerCodec, javaType);
            this.userType = (UserType)innerCodec.getCqlType();
        }

        @Override
        protected Address deserialize(UDTValue value) {
            return value == null ? null : new Address(value.getString("street"), value.getInt("zipcode"), value.getList("phones", Phone.class));
        }

        @Override
        protected UDTValue serialize(Address value) {
            return value == null ? null : (UDTValue)((UDTValue)((UDTValue)this.userType.newValue().setString("street", value.street)).setInt("zipcode", value.zipcode)).setList("phones", value.phones, Phone.class);
        }
    }
}

