/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import com.datastax.driver.core.utils.MoreObjects;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TypeCodecEncapsulationIntegrationTest
extends CCMTestsSupport {
    private static final TypeToken<NumberBox<Integer>> NUMBERBOX_OF_INTEGER_TOKEN = new TypeToken<NumberBox<Integer>>(){};
    private static final TypeToken<NumberBox<Long>> NUMBERBOX_OF_LONG_TOKEN = new TypeToken<NumberBox<Long>>(){};
    private static final TypeToken<NumberBox<Float>> NUMBERBOX_OF_FLOAT_TOKEN = new TypeToken<NumberBox<Float>>(){};
    private static final TypeToken<NumberBox<Double>> NUMBERBOX_OF_DOUBLE_TOKEN = new TypeToken<NumberBox<Double>>(){};
    private static final TypeToken<NumberBox<BigInteger>> NUMBERBOX_OF_BIGINTEGER_TOKEN = new TypeToken<NumberBox<BigInteger>>(){};
    private static final TypeToken<NumberBox<BigDecimal>> NUMBERBOX_OF_BIGDECIMAL_TOKEN = new TypeToken<NumberBox<BigDecimal>>(){};
    private final String insertQuery = "INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)";
    private final String selectQuery = "SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?";
    private BuiltStatement insertStmt;
    private BuiltStatement selectStmt;
    private int n_int = 42;
    private long n_bigint = 4242L;
    private float n_float = 42.42f;
    private double n_double = 4242.42;
    private BigInteger n_varint = new BigInteger("424242");
    private BigDecimal n_decimal = new BigDecimal("424242.42");

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE \"myTable\" (c_int int, c_bigint bigint, c_float float, c_double double, c_varint varint, c_decimal decimal, PRIMARY KEY (c_int, c_bigint))");
    }

    @Override
    public Cluster.Builder createClusterBuilder() {
        return Cluster.builder().withCodecRegistry(new CodecRegistry().register(new TypeCodec[]{new NumberBoxCodec(TypeCodec.cint()), new NumberBoxCodec(TypeCodec.bigint()), new NumberBoxCodec(TypeCodec.cfloat()), new NumberBoxCodec(TypeCodec.cdouble()), new NumberBoxCodec(TypeCodec.varint()), new NumberBoxCodec(TypeCodec.decimal())}));
    }

    @BeforeMethod(groups={"short"})
    public void createBuiltStatements() throws Exception {
        this.insertStmt = QueryBuilder.insertInto((String)"\"myTable\"").value("c_int", (Object)QueryBuilder.bindMarker()).value("c_bigint", (Object)QueryBuilder.bindMarker()).value("c_float", (Object)QueryBuilder.bindMarker()).value("c_double", (Object)QueryBuilder.bindMarker()).value("c_varint", (Object)QueryBuilder.bindMarker()).value("c_decimal", (Object)QueryBuilder.bindMarker());
        this.selectStmt = QueryBuilder.select((String[])new String[]{"c_int", "c_bigint", "c_float", "c_double", "c_varint", "c_decimal"}).from("\"myTable\"").where(QueryBuilder.eq((String)"c_int", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"c_bigint", (Object)QueryBuilder.bindMarker()));
    }

    @Test(groups={"short"})
    @CassandraVersion(value="2.0.0")
    public void should_use_custom_codecs_with_simple_statements() {
        this.session().execute("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)", new Object[]{this.n_int, new NumberBox(this, this.n_bigint), new NumberBox(this, Float.valueOf(this.n_float)), new NumberBox(this, this.n_double), new NumberBox(this, this.n_varint), new NumberBox(this, this.n_decimal)});
        ResultSet rows = this.session().execute("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?", new Object[]{this.n_int, new NumberBox(this, this.n_bigint)});
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_custom_codecs_with_prepared_statements_1() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)").bind(new Object[]{this.n_int, new NumberBox(this, this.n_bigint), new NumberBox(this, Float.valueOf(this.n_float)), new NumberBox(this, this.n_double), new NumberBox(this, this.n_varint), new NumberBox(this, this.n_decimal)}));
        PreparedStatement ps = this.session().prepare("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind(new Object[]{this.n_int, new NumberBox(this, this.n_bigint)}));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_custom_codecs_with_prepared_statements_2() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable\" (c_int, c_bigint, c_float, c_double, c_varint, c_decimal) VALUES (?, ?, ?, ?, ?, ?)").bind().set(0, new NumberBox(this, this.n_int), NUMBERBOX_OF_INTEGER_TOKEN).set(1, new NumberBox(this, this.n_bigint), NUMBERBOX_OF_LONG_TOKEN).set(2, new NumberBox(this, Float.valueOf(this.n_float)), NUMBERBOX_OF_FLOAT_TOKEN).set(3, new NumberBox(this, this.n_double), NUMBERBOX_OF_DOUBLE_TOKEN).set(4, new NumberBox(this, this.n_varint), NUMBERBOX_OF_BIGINTEGER_TOKEN).set(5, new NumberBox(this, this.n_decimal), NUMBERBOX_OF_BIGDECIMAL_TOKEN));
        PreparedStatement ps = this.session().prepare("SELECT c_int, c_bigint, c_float, c_double, c_varint, c_decimal FROM \"myTable\" WHERE c_int = ? and c_bigint = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().set(0, new NumberBox(this, this.n_int), NUMBERBOX_OF_INTEGER_TOKEN).set(1, new NumberBox(this, this.n_bigint), NUMBERBOX_OF_LONG_TOKEN));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_custom_codecs_with_built_statements_1() {
        this.session().execute((Statement)this.session().prepare((RegularStatement)this.insertStmt).bind(new Object[]{this.n_int, new NumberBox(this, this.n_bigint), new NumberBox(this, Float.valueOf(this.n_float)), new NumberBox(this, this.n_double), new NumberBox(this, this.n_varint), new NumberBox(this, this.n_decimal)}));
        PreparedStatement ps = this.session().prepare((RegularStatement)this.selectStmt);
        ResultSet rows = this.session().execute((Statement)ps.bind(new Object[]{this.n_int, new NumberBox(this, this.n_bigint)}));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_custom_codecs_with_built_statements_2() {
        this.session().execute((Statement)this.session().prepare((RegularStatement)this.insertStmt).bind().set(0, new NumberBox(this, this.n_int), NUMBERBOX_OF_INTEGER_TOKEN).set(1, new NumberBox(this, this.n_bigint), NUMBERBOX_OF_LONG_TOKEN).set(2, new NumberBox(this, Float.valueOf(this.n_float)), NUMBERBOX_OF_FLOAT_TOKEN).set(3, new NumberBox(this, this.n_double), NUMBERBOX_OF_DOUBLE_TOKEN).set(4, new NumberBox(this, this.n_varint), NUMBERBOX_OF_BIGINTEGER_TOKEN).set(5, new NumberBox(this, this.n_decimal), NUMBERBOX_OF_BIGDECIMAL_TOKEN));
        PreparedStatement ps = this.session().prepare((RegularStatement)this.selectStmt);
        ResultSet rows = this.session().execute((Statement)ps.bind().set(0, new NumberBox(this, this.n_int), NUMBERBOX_OF_INTEGER_TOKEN).set(1, new NumberBox(this, this.n_bigint), NUMBERBOX_OF_LONG_TOKEN));
        Row row = rows.one();
        this.assertRow(row);
    }

    private void assertRow(Row row) {
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(this.n_int);
        Assertions.assertThat((long)row.getLong(1)).isEqualTo(this.n_bigint);
        Assertions.assertThat((float)row.getFloat(2)).isEqualTo(this.n_float);
        Assertions.assertThat((double)row.getDouble(3)).isEqualTo(this.n_double);
        Assertions.assertThat((Comparable)row.getVarint(4)).isEqualTo((Object)this.n_varint);
        Assertions.assertThat((BigDecimal)row.getDecimal(5)).isEqualTo((Object)this.n_decimal);
        Assertions.assertThat((Object)row.getObject(0)).isEqualTo((Object)this.n_int);
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo((Object)this.n_bigint);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo((Object)Float.valueOf(this.n_float));
        Assertions.assertThat((Object)row.getObject(3)).isEqualTo((Object)this.n_double);
        Assertions.assertThat((Object)row.getObject(4)).isEqualTo((Object)this.n_varint);
        Assertions.assertThat((Object)row.getObject(5)).isEqualTo((Object)this.n_decimal);
        Assertions.assertThat((Integer)((Integer)row.get(0, Integer.class))).isEqualTo(this.n_int);
        Assertions.assertThat((Long)((Long)row.get(1, Long.class))).isEqualTo(this.n_bigint);
        Assertions.assertThat((Float)((Float)row.get(2, Float.class))).isEqualTo(this.n_float);
        Assertions.assertThat((Double)((Double)row.get(3, Double.class))).isEqualTo(this.n_double);
        Assertions.assertThat((Comparable)((Comparable)row.get(4, BigInteger.class))).isEqualTo((Object)this.n_varint);
        Assertions.assertThat((BigDecimal)((BigDecimal)row.get(5, BigDecimal.class))).isEqualTo((Object)this.n_decimal);
        Assertions.assertThat((Object)row.get(0, NUMBERBOX_OF_INTEGER_TOKEN)).isEqualTo(new NumberBox(this, this.n_int));
        Assertions.assertThat((Object)row.get(1, NUMBERBOX_OF_LONG_TOKEN)).isEqualTo(new NumberBox(this, this.n_bigint));
        Assertions.assertThat((Object)row.get(2, NUMBERBOX_OF_FLOAT_TOKEN)).isEqualTo(new NumberBox(this, Float.valueOf(this.n_float)));
        Assertions.assertThat((Object)row.get(3, NUMBERBOX_OF_DOUBLE_TOKEN)).isEqualTo(new NumberBox(this, this.n_double));
        Assertions.assertThat((Object)row.get(4, NUMBERBOX_OF_BIGINTEGER_TOKEN)).isEqualTo(new NumberBox(this, this.n_varint));
        Assertions.assertThat((Object)row.get(5, NUMBERBOX_OF_BIGDECIMAL_TOKEN)).isEqualTo(new NumberBox(this, this.n_decimal));
    }

    private static class NumberBox<T extends Number> {
        private final T number;
        final /* synthetic */ TypeCodecEncapsulationIntegrationTest this$0;

        private NumberBox(T number) {
            this.this$0 = var1_1;
            this.number = number;
        }

        public T getNumber() {
            return this.number;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberBox numberBox = (NumberBox)o;
            return MoreObjects.equal(this.number, numberBox.number);
        }

        public int hashCode() {
            return MoreObjects.hashCode((Object[])new Object[]{this.number});
        }
    }

    private class NumberBoxCodec<T extends Number>
    extends TypeCodec<NumberBox<T>> {
        private final TypeCodec<T> numberCodec;

        protected NumberBoxCodec(TypeCodec<T> numberCodec) {
            super(numberCodec.getCqlType(), new TypeToken<NumberBox<T>>(){}.where(new TypeParameter<T>(){}, numberCodec.getJavaType()));
            this.numberCodec = numberCodec;
        }

        public boolean accepts(Object value) {
            return value instanceof NumberBox && this.numberCodec.accepts(((NumberBox)value).getNumber());
        }

        public ByteBuffer serialize(NumberBox<T> value, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return this.numberCodec.serialize(value.getNumber(), protocolVersion);
        }

        public NumberBox<T> deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
            return new NumberBox(TypeCodecEncapsulationIntegrationTest.this, (Number)this.numberCodec.deserialize(bytes, protocolVersion));
        }

        public NumberBox<T> parse(String value) throws InvalidTypeException {
            return new NumberBox(TypeCodecEncapsulationIntegrationTest.this, (Number)this.numberCodec.parse(value));
        }

        public String format(NumberBox<T> value) throws InvalidTypeException {
            return this.numberCodec.format(value.getNumber());
        }
    }
}

