/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeTokens;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.utils.CassandraVersion;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@CassandraVersion(value="2.0.0")
public class TypeCodecCollectionsIntegrationTest
extends CCMTestsSupport {
    private final String insertQuery = "INSERT INTO \"myTable2\" (c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal) VALUES (?, ?, ?, ?, ?, ?, ?)";
    private final String selectQuery = "SELECT c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal FROM \"myTable2\" WHERE c_int = ?";
    private BuiltStatement insertStmt;
    private BuiltStatement selectStmt;
    private int n_int = 42;
    private List<Integer> l_int = Lists.newArrayList((Object[])new Integer[]{42, 43});
    private List<Long> l_bigint = Lists.newArrayList((Object[])new Long[]{42L, 43L});
    private Set<Float> s_float = Sets.newHashSet((Object[])new Float[]{Float.valueOf(42.42f), Float.valueOf(43.43f)});
    private Set<Double> s_double = Sets.newHashSet((Object[])new Double[]{42.42, 43.43});
    private Map<Integer, BigInteger> m_varint = ImmutableMap.of((Object)42, (Object)new BigInteger("424242"), (Object)43, (Object)new BigInteger("434343"));
    private Map<Integer, BigDecimal> m_decimal = ImmutableMap.of((Object)42, (Object)new BigDecimal("424242.42"), (Object)43, (Object)new BigDecimal("434343.43"));

    @Override
    public void onTestContextInitialized() {
        this.execute("CREATE TABLE IF NOT EXISTS \"myTable2\" (c_int int PRIMARY KEY, l_int list<int>, l_bigint list<bigint>, s_float set<float>, s_double set<double>, m_varint map<int,varint>, m_decimal map<int,decimal>)");
    }

    @BeforeMethod(groups={"short"})
    public void createBuiltStatements() throws Exception {
        this.insertStmt = QueryBuilder.insertInto((String)"\"myTable2\"").value("c_int", (Object)QueryBuilder.bindMarker()).value("l_int", (Object)QueryBuilder.bindMarker()).value("l_bigint", (Object)QueryBuilder.bindMarker()).value("s_float", (Object)QueryBuilder.bindMarker()).value("s_double", (Object)QueryBuilder.bindMarker()).value("m_varint", (Object)QueryBuilder.bindMarker()).value("m_decimal", (Object)QueryBuilder.bindMarker());
        this.selectStmt = QueryBuilder.select((String[])new String[]{"c_int", "l_int", "l_bigint", "s_float", "s_double", "m_varint", "m_decimal"}).from("\"myTable2\"").where(QueryBuilder.eq((String)"c_int", (Object)QueryBuilder.bindMarker()));
    }

    @Test(groups={"short"})
    public void should_use_collection_codecs_with_simple_statements() {
        this.session().execute("INSERT INTO \"myTable2\" (c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal) VALUES (?, ?, ?, ?, ?, ?, ?)", new Object[]{this.n_int, this.l_int, this.l_bigint, this.s_float, this.s_double, this.m_varint, this.m_decimal});
        ResultSet rows = this.session().execute("SELECT c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal FROM \"myTable2\" WHERE c_int = ?", new Object[]{this.n_int});
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_collection_codecs_with_prepared_statements_1() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable2\" (c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal) VALUES (?, ?, ?, ?, ?, ?, ?)").bind(new Object[]{this.n_int, this.l_int, this.l_bigint, this.s_float, this.s_double, this.m_varint, this.m_decimal}));
        PreparedStatement ps = this.session().prepare("SELECT c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal FROM \"myTable2\" WHERE c_int = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind(new Object[]{this.n_int}));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_collection_codecs_with_prepared_statements_2() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable2\" (c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal) VALUES (?, ?, ?, ?, ?, ?, ?)").bind().setInt(0, this.n_int).setList(1, this.l_int).setList(2, this.l_bigint, Long.class).setSet(3, this.s_float).setSet(4, this.s_double, TypeToken.of(Double.class)).setMap(5, this.m_varint).setMap(6, this.m_decimal, Integer.class, BigDecimal.class));
        PreparedStatement ps = this.session().prepare("SELECT c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal FROM \"myTable2\" WHERE c_int = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.n_int));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_collection_codecs_with_prepared_statements_3() {
        this.session().execute((Statement)this.session().prepare("INSERT INTO \"myTable2\" (c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal) VALUES (?, ?, ?, ?, ?, ?, ?)").bind().setInt(0, this.n_int).set(1, this.l_int, TypeTokens.listOf(Integer.class)).set(2, this.l_bigint, TypeTokens.listOf(Long.class)).set(3, this.s_float, TypeTokens.setOf(Float.class)).set(4, this.s_double, TypeTokens.setOf(Double.class)).set(5, this.m_varint, TypeTokens.mapOf(Integer.class, BigInteger.class)).set(6, this.m_decimal, TypeTokens.mapOf(Integer.class, BigDecimal.class)));
        PreparedStatement ps = this.session().prepare("SELECT c_int, l_int, l_bigint, s_float, s_double, m_varint, m_decimal FROM \"myTable2\" WHERE c_int = ?");
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.n_int));
        Row row = rows.one();
        this.assertRow(row);
    }

    @Test(groups={"short"})
    public void should_use_collection_codecs_with_built_statements() {
        this.session().execute((Statement)this.session().prepare((RegularStatement)this.insertStmt).bind().setInt(0, this.n_int).set(1, this.l_int, TypeTokens.listOf(Integer.class)).set(2, this.l_bigint, TypeTokens.listOf(Long.class)).set(3, this.s_float, TypeTokens.setOf(Float.class)).set(4, this.s_double, TypeTokens.setOf(Double.class)).set(5, this.m_varint, TypeTokens.mapOf(Integer.class, BigInteger.class)).set(6, this.m_decimal, TypeTokens.mapOf(Integer.class, BigDecimal.class)));
        PreparedStatement ps = this.session().prepare((RegularStatement)this.selectStmt);
        ResultSet rows = this.session().execute((Statement)ps.bind().setInt(0, this.n_int));
        Row row = rows.one();
        this.assertRow(row);
    }

    private void assertRow(Row row) {
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(this.n_int);
        Assertions.assertThat((List)row.getList(1, Integer.class)).isEqualTo(this.l_int);
        Assertions.assertThat((List)row.getList(2, Long.class)).isEqualTo(this.l_bigint);
        Assertions.assertThat((Iterable)row.getSet(3, Float.class)).isEqualTo(this.s_float);
        Assertions.assertThat((Iterable)row.getSet(4, Double.class)).isEqualTo(this.s_double);
        Assertions.assertThat((Map)row.getMap(5, Integer.class, BigInteger.class)).isEqualTo(this.m_varint);
        Assertions.assertThat((Map)row.getMap(6, Integer.class, BigDecimal.class)).isEqualTo(this.m_decimal);
        Assertions.assertThat((List)((List)row.get(1, TypeTokens.listOf(Integer.class)))).isEqualTo(this.l_int);
        Assertions.assertThat((List)((List)row.get(2, TypeTokens.listOf(Long.class)))).isEqualTo(this.l_bigint);
        Assertions.assertThat((Iterable)((Iterable)row.get(3, TypeTokens.setOf(Float.class)))).isEqualTo(this.s_float);
        Assertions.assertThat((Iterable)((Iterable)row.get(4, TypeTokens.setOf(Double.class)))).isEqualTo(this.s_double);
        Assertions.assertThat((Map)((Map)row.get(5, TypeTokens.mapOf(Integer.class, BigInteger.class)))).isEqualTo(this.m_varint);
        Assertions.assertThat((Map)((Map)row.get(6, TypeTokens.mapOf(Integer.class, BigDecimal.class)))).isEqualTo(this.m_decimal);
        Assertions.assertThat((Object)row.getObject(1)).isEqualTo(this.l_int);
        Assertions.assertThat((Object)row.getObject(2)).isEqualTo(this.l_bigint);
        Assertions.assertThat((Object)row.getObject(3)).isEqualTo(this.s_float);
        Assertions.assertThat((Object)row.getObject(4)).isEqualTo(this.s_double);
        Assertions.assertThat((Object)row.getObject(5)).isEqualTo(this.m_varint);
        Assertions.assertThat((Object)row.getObject(6)).isEqualTo(this.m_decimal);
    }
}

