/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TokenRangeTest {
    Token.Factory factory = Token.getFactory((String)"Murmur3Partitioner");
    private Token minToken = this.factory.minToken();

    @Test(groups={"unit"})
    public void should_check_intersection() {
        Assertions.assertThat(this.tokenRange(3L, 9L)).doesNotIntersect(this.tokenRange(11L, 1L)).doesNotIntersect(this.tokenRange(1L, 2L)).doesNotIntersect(this.tokenRange(11L, 3L)).doesNotIntersect(this.tokenRange(2L, 3L)).doesNotIntersect(this.tokenRange(3L, 3L)).intersects(this.tokenRange(2L, 6L)).intersects(this.tokenRange(2L, 10L)).intersects(this.tokenRange(6L, 10L)).intersects(this.tokenRange(4L, 8L)).intersects(this.tokenRange(3L, 9L)).doesNotIntersect(this.tokenRange(9L, 10L)).doesNotIntersect(this.tokenRange(10L, 11L));
        Assertions.assertThat(this.tokenRange(9L, 3L)).doesNotIntersect(this.tokenRange(5L, 7L)).doesNotIntersect(this.tokenRange(7L, 8L)).doesNotIntersect(this.tokenRange(5L, 9L)).doesNotIntersect(this.tokenRange(8L, 9L)).doesNotIntersect(this.tokenRange(9L, 9L)).intersects(this.tokenRange(8L, 2L)).intersects(this.tokenRange(8L, 4L)).intersects(this.tokenRange(2L, 4L)).intersects(this.tokenRange(10L, 2L)).intersects(this.tokenRange(9L, 3L)).doesNotIntersect(this.tokenRange(3L, 4L)).doesNotIntersect(this.tokenRange(4L, 5L));
        Assertions.assertThat(this.tokenRange(3L, 3L)).doesNotIntersect(this.tokenRange(3L, 3L));
        Assertions.assertThat(this.tokenRange(this.minToken, 5L)).doesNotIntersect(this.tokenRange(6L, 7L)).doesNotIntersect(this.tokenRange(6L, this.minToken)).intersects(this.tokenRange(6L, 4L)).intersects(this.tokenRange(2L, 4L)).intersects(this.tokenRange(this.minToken, 4L)).intersects(this.tokenRange(this.minToken, 5L));
        Assertions.assertThat(this.tokenRange(5L, this.minToken)).doesNotIntersect(this.tokenRange(3L, 4L)).doesNotIntersect(this.tokenRange(this.minToken, 4L)).intersects(this.tokenRange(6L, 7L)).intersects(this.tokenRange(4L, 1L)).intersects(this.tokenRange(6L, this.minToken)).intersects(this.tokenRange(5L, this.minToken));
        Assertions.assertThat(this.tokenRange(this.minToken, this.minToken)).intersects(this.tokenRange(3L, 4L)).intersects(this.tokenRange(3L, this.minToken)).intersects(this.tokenRange(this.minToken, 3L)).doesNotIntersect(this.tokenRange(3L, 3L));
    }

    @Test(groups={"unit"})
    public void should_compute_intersection() {
        Assertions.assertThat((List)this.tokenRange(3L, 9L).intersectWith(this.tokenRange(2L, 4L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(3L, 4L)));
        Assertions.assertThat((List)this.tokenRange(3L, 9L).intersectWith(this.tokenRange(3L, 5L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(3L, 5L)));
        Assertions.assertThat((List)this.tokenRange(3L, 9L).intersectWith(this.tokenRange(4L, 6L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(4L, 6L)));
        Assertions.assertThat((List)this.tokenRange(3L, 9L).intersectWith(this.tokenRange(7L, 9L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(7L, 9L)));
        Assertions.assertThat((List)this.tokenRange(3L, 9L).intersectWith(this.tokenRange(8L, 10L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(8L, 9L)));
    }

    @Test(groups={"unit"})
    public void should_compute_intersection_with_ranges_around_ring() {
        Assertions.assertThat((List)this.tokenRange(10L, -10L).intersectWith(this.tokenRange(-20L, 20L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(10L, 20L), (Object)this.tokenRange(-20L, -10L)));
        Assertions.assertThat((List)this.tokenRange(-20L, 20L).intersectWith(this.tokenRange(10L, -10L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(10L, 20L), (Object)this.tokenRange(-20L, -10L)));
        Assertions.assertThat((List)this.tokenRange(10L, -30L).intersectWith(this.tokenRange(20L, -20L))).isEqualTo((Object)ImmutableList.of((Object)this.tokenRange(20L, -30L)));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_fail_to_compute_intersection_when_ranges_dont_intersect() {
        this.tokenRange(1L, 2L).intersectWith(this.tokenRange(2L, 3L));
    }

    @Test(groups={"unit"})
    public void should_merge_with_other_range() {
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(2L, 3L))).isEqualTo(this.tokenRange(2L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(2L, 4L))).isEqualTo(this.tokenRange(2L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(11L, 3L))).isEqualTo(this.tokenRange(11L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(11L, 4L))).isEqualTo(this.tokenRange(11L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(4L, 8L))).isEqualTo(this.tokenRange(3L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(3L, 9L))).isEqualTo(this.tokenRange(3L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(3L, 3L))).isEqualTo(this.tokenRange(3L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 3L).mergeWith(this.tokenRange(3L, 9L))).isEqualTo(this.tokenRange(3L, 9L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(9L, 11L))).isEqualTo(this.tokenRange(3L, 11L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(8L, 11L))).isEqualTo(this.tokenRange(3L, 11L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(9L, 1L))).isEqualTo(this.tokenRange(3L, 1L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(8L, 1L))).isEqualTo(this.tokenRange(3L, 1L));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(9L, 3L))).isEqualTo(this.tokenRange(this.minToken, this.minToken));
        Assertions.assertThat(this.tokenRange(3L, 9L).mergeWith(this.tokenRange(9L, 4L))).isEqualTo(this.tokenRange(this.minToken, this.minToken));
        Assertions.assertThat(this.tokenRange(3L, 10L).mergeWith(this.tokenRange(9L, 4L))).isEqualTo(this.tokenRange(this.minToken, this.minToken));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(8L, 9L))).isEqualTo(this.tokenRange(8L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(8L, 10L))).isEqualTo(this.tokenRange(8L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(4L, 9L))).isEqualTo(this.tokenRange(4L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(4L, 10L))).isEqualTo(this.tokenRange(4L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(10L, 2L))).isEqualTo(this.tokenRange(9L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(9L, 3L))).isEqualTo(this.tokenRange(9L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(9L, 9L))).isEqualTo(this.tokenRange(9L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 9L).mergeWith(this.tokenRange(9L, 3L))).isEqualTo(this.tokenRange(9L, 3L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(3L, 5L))).isEqualTo(this.tokenRange(9L, 5L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(2L, 5L))).isEqualTo(this.tokenRange(9L, 5L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(3L, 7L))).isEqualTo(this.tokenRange(9L, 7L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(2L, 7L))).isEqualTo(this.tokenRange(9L, 7L));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(3L, 9L))).isEqualTo(this.tokenRange(this.minToken, this.minToken));
        Assertions.assertThat(this.tokenRange(9L, 3L).mergeWith(this.tokenRange(3L, 10L))).isEqualTo(this.tokenRange(this.minToken, this.minToken));
        Assertions.assertThat(this.tokenRange(3L, 3L).mergeWith(this.tokenRange(3L, 3L))).isEqualTo(this.tokenRange(3L, 3L));
        Assertions.assertThat(this.tokenRange(5L, this.minToken).mergeWith(this.tokenRange(6L, 7L))).isEqualTo(this.tokenRange(5L, this.minToken));
        Assertions.assertThat(this.tokenRange(5L, this.minToken).mergeWith(this.tokenRange(this.minToken, 3L))).isEqualTo(this.tokenRange(5L, 3L));
        Assertions.assertThat(this.tokenRange(5L, this.minToken).mergeWith(this.tokenRange(3L, 5L))).isEqualTo(this.tokenRange(3L, this.minToken));
        Assertions.assertThat(this.tokenRange(this.minToken, 5L).mergeWith(this.tokenRange(2L, 3L))).isEqualTo(this.tokenRange(this.minToken, 5L));
        Assertions.assertThat(this.tokenRange(this.minToken, 5L).mergeWith(this.tokenRange(7L, this.minToken))).isEqualTo(this.tokenRange(7L, 5L));
        Assertions.assertThat(this.tokenRange(this.minToken, 5L).mergeWith(this.tokenRange(5L, 7L))).isEqualTo(this.tokenRange(this.minToken, 7L));
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_not_merge_with_nonadjacent_and_disjoint_ranges() {
        this.tokenRange(0L, 5L).mergeWith(this.tokenRange(7L, 14L));
    }

    @Test(groups={"unit"})
    public void should_return_non_empty_range_if_other_range_is_empty() {
        Assertions.assertThat(this.tokenRange(1L, 5L).mergeWith(this.tokenRange(5L, 5L))).isEqualTo(this.tokenRange(1L, 5L));
    }

    @Test(groups={"unit"})
    public void should_unwrap_to_non_wrapping_ranges() {
        Assertions.assertThat(this.tokenRange(9L, 3L)).unwrapsTo(this.tokenRange(9L, this.minToken), this.tokenRange(this.minToken, 3L));
        Assertions.assertThat(this.tokenRange(3L, 9L)).isNotWrappedAround();
        Assertions.assertThat(this.tokenRange(3L, this.minToken)).isNotWrappedAround();
        Assertions.assertThat(this.tokenRange(this.minToken, 3L)).isNotWrappedAround();
        Assertions.assertThat(this.tokenRange(3L, 3L)).isNotWrappedAround();
        Assertions.assertThat(this.tokenRange(this.minToken, this.minToken)).isNotWrappedAround();
    }

    @Test(groups={"unit"})
    public void should_split_evenly() {
        List splits = this.tokenRange(3L, 9L).splitEvenly(3);
        Assertions.assertThat((List)splits).hasSize(3);
        Assertions.assertThat((List)splits).containsExactly((Object[])new TokenRange[]{this.tokenRange(3L, 5L), this.tokenRange(5L, 7L), this.tokenRange(7L, 9L)});
    }

    @Test(groups={"unit"})
    public void should_throw_error_with_less_than_1_splits() {
        for (int i = -255; i < 1; ++i) {
            try {
                this.tokenRange(0L, 1L).splitEvenly(i);
                Assert.fail((String)("Expected error when providing " + i + " splits."));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Test(groups={"unit"}, expectedExceptions={IllegalArgumentException.class})
    public void should_not_split_empty_token_range() {
        this.tokenRange(0L, 0L).splitEvenly(1);
    }

    @Test(groups={"unit"})
    public void should_create_empty_token_ranges_if_too_many_splits() {
        TokenRange range = this.tokenRange(0L, 10L);
        List ranges = range.splitEvenly(255);
        Assertions.assertThat((List)ranges).hasSize(255);
        for (int i = 0; i < ranges.size(); ++i) {
            TokenRange tr = (TokenRange)ranges.get(i);
            if (i < 10) {
                Assertions.assertThat(tr).isEqualTo(this.tokenRange((long)i, (long)(i + 1)));
                continue;
            }
            Assertions.assertThat((boolean)tr.isEmpty());
        }
    }

    @Test(groups={"unit"})
    public void should_check_if_range_contains_token() {
        Assertions.assertThat(this.tokenRange(1L, 2L)).contains(this.newM3PToken(2L), false).doesNotContain(this.newM3PToken(2L), true);
        Assertions.assertThat(this.tokenRange(1L, 2L)).doesNotContain(this.newM3PToken(1L), false).contains(this.newM3PToken(1L), true);
        Assertions.assertThat(this.tokenRange(2L, 1L)).contains(this.minToken, true);
        Assertions.assertThat(this.tokenRange(this.minToken, 1L)).doesNotContain(this.minToken, false).contains(this.minToken, true);
        Assertions.assertThat(this.tokenRange(1L, this.minToken)).contains(this.minToken, false).doesNotContain(this.minToken, true);
        Assertions.assertThat(this.tokenRange(1L, 1L)).doesNotContain(this.newM3PToken(1L), true).doesNotContain(this.newM3PToken(1L), false).doesNotContain(this.minToken, true).doesNotContain(this.minToken, false);
        Assertions.assertThat(this.tokenRange(this.minToken, this.minToken)).contains(this.minToken, true).contains(this.minToken, false).contains(this.newM3PToken(1L), true).contains(this.newM3PToken(1L), false);
    }

    private TokenRange tokenRange(long start, long end) {
        return new TokenRange(this.newM3PToken(start), this.newM3PToken(end), this.factory);
    }

    private TokenRange tokenRange(Token start, long end) {
        return new TokenRange(start, this.newM3PToken(end), this.factory);
    }

    private TokenRange tokenRange(long start, Token end) {
        return new TokenRange(this.newM3PToken(start), end, this.factory);
    }

    private TokenRange tokenRange(Token start, Token end) {
        return new TokenRange(start, end, this.factory);
    }

    private Token newM3PToken(long value) {
        return this.factory.fromString(Long.toString(value));
    }
}

