/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.IndexMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.TableMetadata;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.Assertions;

public class TableMetadataAssert
extends AbstractAssert<TableMetadataAssert, TableMetadata> {
    protected TableMetadataAssert(TableMetadata actual) {
        super((Object)actual, TableMetadataAssert.class);
    }

    public TableMetadataAssert hasName(String name) {
        Assertions.assertThat((String)((TableMetadata)this.actual).getName()).isEqualTo((Object)name);
        return this;
    }

    public TableMetadataAssert isInKeyspace(String keyspaceName) {
        Assertions.assertThat((String)((TableMetadata)this.actual).getKeyspace().getName()).isEqualTo((Object)keyspaceName);
        return this;
    }

    public TableMetadataAssert hasColumn(String columnName) {
        Assertions.assertThat((Object)((TableMetadata)this.actual).getColumn(columnName)).isNotNull();
        return this;
    }

    public TableMetadataAssert hasColumn(String columnName, DataType dataType) {
        ColumnMetadata column = ((TableMetadata)this.actual).getColumn(columnName);
        Assertions.assertThat((Object)column).isNotNull();
        Assertions.assertThat((Object)column.getType()).isEqualTo((Object)dataType);
        return this;
    }

    public TableMetadataAssert hasNoColumn(String columnName) {
        Assertions.assertThat((Object)((TableMetadata)this.actual).getColumn(columnName)).isNull();
        return this;
    }

    public TableMetadataAssert hasComment(String comment) {
        Assertions.assertThat((String)((TableMetadata)this.actual).getOptions().getComment()).isEqualTo((Object)comment);
        return this;
    }

    public TableMetadataAssert doesNotHaveComment(String comment) {
        Assertions.assertThat((String)((TableMetadata)this.actual).getOptions().getComment()).isNotEqualTo((Object)comment);
        return this;
    }

    public TableMetadataAssert doesNotHaveColumn(String columnName) {
        ColumnMetadata column = ((TableMetadata)this.actual).getColumn(columnName);
        Assertions.assertThat((Object)column).isNull();
        return this;
    }

    public TableMetadataAssert isCompactStorage() {
        Assertions.assertThat((boolean)((TableMetadata)this.actual).getOptions().isCompactStorage()).isTrue();
        return this;
    }

    public TableMetadataAssert isNotCompactStorage() {
        Assertions.assertThat((boolean)((TableMetadata)this.actual).getOptions().isCompactStorage()).isFalse();
        return this;
    }

    public TableMetadataAssert hasNumberOfColumns(int expected) {
        Assertions.assertThat((int)((TableMetadata)this.actual).getColumns().size()).isEqualTo(expected);
        return this;
    }

    public TableMetadataAssert hasMaterializedView(MaterializedViewMetadata expected) {
        ((AbstractObjectAssert)Assertions.assertThat((Object)((TableMetadata)this.actual).getView(Metadata.quote((String)expected.getName()))).isNotNull()).isEqualTo((Object)expected);
        return this;
    }

    public TableMetadataAssert hasIndex(IndexMetadata index) {
        Assertions.assertThat((Iterable)((TableMetadata)this.actual).getIndexes()).contains((Object[])new IndexMetadata[]{index});
        return this;
    }
}

