/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.MD5Digest;
import com.datastax.driver.core.PreparedId;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.StatementWrapper;
import com.datastax.driver.core.utils.Bytes;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableMap;
import java.nio.ByteBuffer;
import java.util.Map;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class StatementSizeTest {
    private static final byte[] MOCK_PAGING_STATE = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xdeadbeef"));
    private static final ByteBuffer MOCK_PAYLOAD_VALUE1 = Bytes.fromHexString((String)"0xabcd");
    private static final ByteBuffer MOCK_PAYLOAD_VALUE2 = Bytes.fromHexString((String)"0xef");
    private static final ImmutableMap<String, ByteBuffer> MOCK_PAYLOAD = ImmutableMap.of((Object)"key1", (Object)MOCK_PAYLOAD_VALUE1, (Object)"key2", (Object)MOCK_PAYLOAD_VALUE2);
    private static final byte[] PREPARED_ID = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xaaaa"));
    private static final byte[] RESULT_METADATA_ID = Bytes.getArray((ByteBuffer)Bytes.fromHexString((String)"0xbbbb"));
    @Mock
    private PreparedStatement preparedStatement;

    @BeforeMethod(groups={"unit"})
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        PreparedId preparedId = new PreparedId(new PreparedId.PreparedMetadata(MD5Digest.wrap((byte[])PREPARED_ID), null), new PreparedId.PreparedMetadata(MD5Digest.wrap((byte[])RESULT_METADATA_ID), null), new int[0], ProtocolVersion.V5);
        Mockito.when((Object)this.preparedStatement.getPreparedId()).thenReturn((Object)preparedId);
        ColumnDefinitions columnDefinitions = new ColumnDefinitions(new ColumnDefinitions.Definition[]{new ColumnDefinitions.Definition("ks", "table", "c1", DataType.cint()), new ColumnDefinitions.Definition("ks", "table", "c2", DataType.text())}, CodecRegistry.DEFAULT_INSTANCE);
        Mockito.when((Object)this.preparedStatement.getVariables()).thenReturn((Object)columnDefinitions);
        Mockito.when((Object)this.preparedStatement.getIncomingPayload()).thenReturn(null);
        Mockito.when((Object)this.preparedStatement.getOutgoingPayload()).thenReturn(null);
        Mockito.when((Object)this.preparedStatement.getCodecRegistry()).thenReturn((Object)CodecRegistry.DEFAULT_INSTANCE);
    }

    @Test(groups={"unit"})
    public void should_measure_size_of_simple_statement() {
        String queryString = "SELECT release_version FROM system.local WHERE key = ?";
        SimpleStatement statement = new SimpleStatement(queryString);
        int expectedSize = 9 + (4 + queryString.getBytes(Charsets.UTF_8).length) + 2 + 2 + 4 + 8 + 4;
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
        SimpleStatement statementWithAnonymousValue = new SimpleStatement(statement.getQueryString(), new Object[]{"local"});
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithAnonymousValue)).isEqualTo(expectedSize + 2 + (4 + "local".getBytes(Charsets.UTF_8).length));
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statementWithAnonymousValue)).isEqualTo(expectedSize + 2 + (4 + "local".getBytes(Charsets.UTF_8).length));
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statementWithAnonymousValue)).isEqualTo(expectedSize + 2 + (4 + "local".getBytes(Charsets.UTF_8).length));
        SimpleStatement statementWithNamedValue = new SimpleStatement(statement.getQueryString(), (Map)ImmutableMap.of((Object)"key", (Object)"local"));
        Assertions.assertThat((int)this.v5SizeOf((Statement)statementWithNamedValue)).isEqualTo(expectedSize + 2 + (2 + "key".getBytes(Charsets.UTF_8).length) + (4 + "local".getBytes(Charsets.UTF_8).length));
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statementWithNamedValue)).isEqualTo(expectedSize + 2 + (2 + "key".getBytes(Charsets.UTF_8).length) + (4 + "local".getBytes(Charsets.UTF_8).length));
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statementWithNamedValue)).isEqualTo(expectedSize + 2 + (2 + "key".getBytes(Charsets.UTF_8).length) + (4 + "local".getBytes(Charsets.UTF_8).length));
        statement.setPagingStateUnsafe(MOCK_PAGING_STATE);
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize += 4 + MOCK_PAGING_STATE.length);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
        statement.setOutgoingPayload(MOCK_PAYLOAD);
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize += 2 + (2 + "key1".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE1.remaining()) + (2 + "key2".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE2.remaining()));
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
    }

    @Test(groups={"unit"})
    public void should_measure_size_of_bound_statement() {
        BoundStatement statement = new BoundStatement(this.preparedStatement);
        int preparedMetadataChangesSize = 2 + RESULT_METADATA_ID.length;
        int expectedSize = 9 + (2 + PREPARED_ID.length) + preparedMetadataChangesSize + 2 + 2 + 4 + 8 + 4 + 2 + 8;
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize - preparedMetadataChangesSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
        statement.setInt(0, 0);
        expectedSize += 4;
        statement.setString(1, "test");
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize += "test".getBytes(Charsets.UTF_8).length);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize - preparedMetadataChangesSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
        statement.setPagingStateUnsafe(MOCK_PAGING_STATE);
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize += 4 + MOCK_PAGING_STATE.length);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize - preparedMetadataChangesSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
        statement.setOutgoingPayload(MOCK_PAYLOAD);
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize += 2 + (2 + "key1".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE1.remaining()) + (2 + "key2".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE2.remaining()));
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize - preparedMetadataChangesSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
    }

    @Test(groups={"unit"})
    public void should_measure_size_of_batch_statement() {
        String queryString = "SELECT release_version FROM system.local";
        SimpleStatement statement1 = new SimpleStatement(queryString);
        BoundStatement statement2 = new BoundStatement(this.preparedStatement).setInt(0, 0).setString(1, "test");
        BoundStatement statement3 = new BoundStatement(this.preparedStatement).setInt(0, 0).setString(1, "test2");
        BatchStatement batchStatement = new BatchStatement().add((Statement)statement1).add((Statement)statement2).add((Statement)statement3);
        int expectedSize = 13 + (4 + queryString.getBytes(Charsets.UTF_8).length) + 1 + (2 + PREPARED_ID.length) + 1 + (2 + PREPARED_ID.length) + 2 + (10 + (4 + "test".getBytes(Charsets.UTF_8).length)) + (10 + (4 + "test2".getBytes(Charsets.UTF_8).length)) + 2 + 2 + 8 + 4;
        Assertions.assertThat((int)this.v5SizeOf((Statement)batchStatement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)batchStatement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)batchStatement)).isEqualTo(expectedSize);
        batchStatement.setOutgoingPayload(MOCK_PAYLOAD);
        Assertions.assertThat((int)this.v5SizeOf((Statement)batchStatement)).isEqualTo(expectedSize += 2 + (2 + "key1".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE1.remaining()) + (2 + "key2".getBytes(Charsets.UTF_8).length) + (4 + MOCK_PAYLOAD_VALUE2.remaining()));
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)batchStatement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)batchStatement)).isEqualTo(expectedSize);
    }

    @Test(groups={"unit"})
    public void should_measure_size_of_wrapped_statement() {
        String queryString = "SELECT release_version FROM system.local WHERE key = ?";
        StatementWrapper statement = new StatementWrapper((Statement)new SimpleStatement(queryString)){};
        int expectedSize = 9 + (4 + queryString.getBytes(Charsets.UTF_8).length) + 2 + 2 + 4 + 8 + 4;
        Assertions.assertThat((int)this.v5SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV1SizeOf((Statement)statement)).isEqualTo(expectedSize);
        Assertions.assertThat((int)this.dseV2SizeOf((Statement)statement)).isEqualTo(expectedSize);
    }

    private int v5SizeOf(Statement statement) {
        return statement.requestSizeInBytes(ProtocolVersion.V5, CodecRegistry.DEFAULT_INSTANCE);
    }

    private int dseV1SizeOf(Statement statement) {
        return statement.requestSizeInBytes(ProtocolVersion.DSE_V1, CodecRegistry.DEFAULT_INSTANCE);
    }

    private int dseV2SizeOf(Statement statement) {
        return statement.requestSizeInBytes(ProtocolVersion.DSE_V2, CodecRegistry.DEFAULT_INSTANCE);
    }
}

