/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Assertions;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.CCMTestsSupport;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.LimitingLoadBalancingPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RoundRobinPolicy;
import java.net.InetAddress;
import java.util.concurrent.TimeUnit;
import org.mockito.Mockito;
import org.testng.annotations.Test;

@CCMConfig(dirtiesContext={true}, numberOfNodes={2}, createCluster={false})
public class RefreshConnectedHostTest
extends CCMTestsSupport {
    @Test(groups={"long"})
    public void should_refresh_single_connected_host() {
        LimitingLoadBalancingPolicy loadBalancingPolicy = new LimitingLoadBalancingPolicy((LoadBalancingPolicy)new RoundRobinPolicy(), 2, 1);
        PoolingOptions poolingOptions = (PoolingOptions)Mockito.spy((Object)new PoolingOptions());
        Cluster cluster = this.register(Cluster.builder().addContactPoints(new InetAddress[]{this.getContactPoints().get(0)}).withPort(this.ccm().getBinaryPort()).withPoolingOptions(poolingOptions).withLoadBalancingPolicy((LoadBalancingPolicy)loadBalancingPolicy).withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(1000L)).withQueryOptions(TestUtils.nonDebouncingQueryOptions()).build());
        Session session = cluster.connect();
        Assertions.assertThat(cluster).usesControlHost(1);
        Assertions.assertThat(cluster).host(1).hasState(Host.State.UP).isAtDistance(HostDistance.LOCAL);
        Assertions.assertThat(cluster).host(2).comesUpWithin(Cluster.NEW_NODE_DELAY_SECONDS + 1, TimeUnit.SECONDS).isAtDistance(HostDistance.LOCAL);
        this.ccm().add(3);
        this.ccm().start(3);
        this.ccm().waitForUp(3);
        Assertions.assertThat(cluster).host(1).hasState(Host.State.UP).isAtDistance(HostDistance.LOCAL);
        Assertions.assertThat(cluster).host(2).hasState(Host.State.UP).isAtDistance(HostDistance.LOCAL);
        Assertions.assertThat(cluster).host(3).comesUpWithin(Cluster.NEW_NODE_DELAY_SECONDS + 1, TimeUnit.SECONDS).isAtDistance(HostDistance.IGNORED);
        Assertions.assertThat(session).hasNoPoolFor(3);
        this.ccm().stop(2);
        TestUtils.waitForUp(TestUtils.ipOfNode(3), cluster);
        Assertions.assertThat(cluster).host(1).hasState(Host.State.UP).isAtDistance(HostDistance.LOCAL);
        Assertions.assertThat(cluster).host(2).hasState(Host.State.DOWN);
        Assertions.assertThat(cluster).host(3).hasState(Host.State.UP).isAtDistance(HostDistance.LOCAL);
        Assertions.assertThat(session).hasPoolFor(3);
        ((PoolingOptions)Mockito.verify((Object)poolingOptions)).refreshConnectedHost(TestUtils.findHost(cluster, 3));
    }
}

