/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.AbstractPoliciesTest;
import com.datastax.driver.core.CCMConfig;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CreateCCM;
import com.datastax.driver.core.TestUtils;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import org.testng.Assert;
import org.testng.annotations.Test;

@CreateCCM(value=CreateCCM.TestMode.PER_METHOD)
@CCMConfig(dirtiesContext={true}, createKeyspace={false})
public class ReconnectionPolicyTest
extends AbstractPoliciesTest {
    private Cluster.Builder exponential() {
        return Cluster.builder().withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy(2000L, 300000L));
    }

    private Cluster.Builder constant() {
        return Cluster.builder().withReconnectionPolicy((ReconnectionPolicy)new ConstantReconnectionPolicy(10000L));
    }

    @Test(groups={"long"})
    @CCMConfig(clusterProvider="exponential")
    public void exponentialReconnectionPolicyTest() throws Throwable {
        ExponentialReconnectionPolicy reconnectionPolicy;
        if (!(this.cluster().getConfiguration().getPolicies().getReconnectionPolicy() instanceof ExponentialReconnectionPolicy)) {
            Assert.fail((String)"Set policy does not match retrieved policy.");
        }
        Assert.assertTrue(((reconnectionPolicy = (ExponentialReconnectionPolicy)this.cluster().getConfiguration().getPolicies().getReconnectionPolicy()).getBaseDelayMs() == 2000L ? 1 : 0) != 0);
        Assert.assertTrue((reconnectionPolicy.getMaxDelayMs() == 300000L ? 1 : 0) != 0);
        try {
            new ExponentialReconnectionPolicy(-1L, 1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ExponentialReconnectionPolicy(1L, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ExponentialReconnectionPolicy(-1L, -1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new ExponentialReconnectionPolicy(2L, 1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ReconnectionPolicy.ReconnectionSchedule schedule = new ExponentialReconnectionPolicy(2000L, 300000L).newSchedule();
        Assert.assertTrue((schedule.nextDelayMs() == 2000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 4000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 8000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 16000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 32000L ? 1 : 0) != 0);
        for (int i = 0; i < 64; ++i) {
            schedule.nextDelayMs();
        }
        Assert.assertTrue((schedule.nextDelayMs() == reconnectionPolicy.getMaxDelayMs() ? 1 : 0) != 0);
        long restartTime = 16L;
        long retryTime = 30L;
        long breakTime = 62L;
    }

    @Test(groups={"long"})
    @CCMConfig(clusterProvider="constant")
    public void constantReconnectionPolicyTest() throws Throwable {
        ConstantReconnectionPolicy reconnectionPolicy;
        if (!(this.cluster().getConfiguration().getPolicies().getReconnectionPolicy() instanceof ConstantReconnectionPolicy)) {
            Assert.fail((String)"Set policy does not match retrieved policy.");
        }
        Assert.assertTrue(((reconnectionPolicy = (ConstantReconnectionPolicy)this.cluster().getConfiguration().getPolicies().getReconnectionPolicy()).getConstantDelayMs() == 10000L ? 1 : 0) != 0);
        try {
            new ConstantReconnectionPolicy(-1L);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ReconnectionPolicy.ReconnectionSchedule schedule = new ConstantReconnectionPolicy(10000L).newSchedule();
        Assert.assertTrue((schedule.nextDelayMs() == 10000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 10000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 10000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 10000L ? 1 : 0) != 0);
        Assert.assertTrue((schedule.nextDelayMs() == 10000L ? 1 : 0) != 0);
        long restartTime = 32L;
        long retryTime = 40L;
        long breakTime = 10L;
    }

    public void reconnectionPolicyTest(long restartTime, long retryTime, long breakTime) throws Throwable {
        long thisTime;
        this.createSchema(1);
        this.init(12);
        this.query(12);
        this.assertQueried(TestUtils.IP_PREFIX + '1', 12);
        this.resetCoordinators();
        this.ccm().forceStop(1);
        long startTime = 0L;
        try {
            startTime = System.nanoTime() / 1000000000L;
            this.query(12);
            Assert.fail((String)"Test race condition where node has not shut off quickly enough.");
        }
        catch (NoHostAvailableException noHostAvailableException) {
            // empty catch block
        }
        boolean restarted = false;
        while (true) {
            thisTime = System.nanoTime() / 1000000000L;
            if (!restarted && thisTime - startTime > restartTime) {
                this.ccm().start(1);
                restarted = true;
            }
            try {
                this.query(12);
                this.assertQueried(TestUtils.IP_PREFIX + '1', 12);
                this.resetCoordinators();
                Assert.assertTrue((retryTime - 2L < thisTime - startTime && thisTime - startTime < retryTime + 2L ? 1 : 0) != 0, (String)String.format("Waited %s seconds instead an expected %s seconds wait", thisTime - startTime, retryTime));
            }
            catch (NoHostAvailableException e) {
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
        Thread.sleep(breakTime);
        this.query(12);
        this.assertQueried(TestUtils.IP_PREFIX + '1', 12);
        this.resetCoordinators();
        this.ccm().forceStop(1);
        startTime = 0L;
        try {
            startTime = System.nanoTime() / 1000000000L;
            this.query(12);
            Assert.fail((String)"Test race condition where node has not shut off quickly enough.");
        }
        catch (NoHostAvailableException e) {
            // empty catch block
        }
        restarted = false;
        while (true) {
            thisTime = System.nanoTime() / 1000000000L;
            if (!restarted && thisTime - startTime > restartTime) {
                this.ccm().start(1);
                restarted = true;
            }
            try {
                this.query(12);
                this.assertQueried(TestUtils.IP_PREFIX + '1', 12);
                this.resetCoordinators();
                Assert.assertTrue((retryTime - 2L < thisTime - startTime && thisTime - startTime < retryTime + 2L ? 1 : 0) != 0, (String)String.format("Waited %s seconds instead an expected %s seconds wait", thisTime - startTime, retryTime));
            }
            catch (NoHostAvailableException e) {
                Thread.sleep(1000L);
                continue;
            }
            break;
        }
    }
}

